/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type;

import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.output.InternalSignalOutput;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleStructureMessage
extends LittleStructure {
    public String text;
    public boolean allowRightClick = true;

    public LittleStructureMessage(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    @Override
    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        if (this.allowRightClick) {
            playerIn.func_146105_b((ITextComponent)new TextComponentString(this.text), true);
            return true;
        }
        return false;
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.text = nbt.func_74779_i("text");
        this.allowRightClick = nbt.func_74767_n("right");
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74778_a("text", this.text);
        nbt.func_74757_a("right", this.allowRightClick);
    }

    @Override
    public void performInternalOutputChange(InternalSignalOutput output) {
        if (((LittleStructureType.InternalComponentOutput)output.component).is("message")) {
            World world = this.getWorld();
            if (world.field_72995_K) {
                return;
            }
            PlayerChunkMapEntry entry = ((WorldServer)world).func_184164_w().func_187301_b(this.getPos().func_177958_n() >> 4, this.getPos().func_177952_p() >> 4);
            if (entry != null) {
                for (EntityPlayerMP player : entry.getWatchingPlayers()) {
                    player.func_146105_b((ITextComponent)new TextComponentString(this.text), true);
                }
            }
        }
    }

    public static class LittleMessageStructureParser
    extends LittleStructureGuiParser {
        public LittleMessageStructureParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(LittlePreviews previews, LittleStructure structure) {
            this.parent.addControl((GuiControl)new GuiTextfield("text", structure instanceof LittleStructureMessage ? ((LittleStructureMessage)structure).text : "Hello World!", 0, 0, 140, 14));
            this.parent.controls.add(new GuiCheckBox("rightclick", CoreControl.translate((String)"gui.door.rightclick"), 0, 20, structure instanceof LittleStructureMessage ? ((LittleStructureMessage)structure).allowRightClick : true));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleStructureMessage parseStructure(LittlePreviews previews) {
            LittleStructureMessage structure = this.createStructure(LittleStructureMessage.class, null);
            GuiTextfield text = (GuiTextfield)this.parent.get("text");
            structure.text = text.text;
            GuiCheckBox box = (GuiCheckBox)this.parent.get("rightclick");
            structure.allowRightClick = box.value;
            return structure;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected LittleStructureType getStructureType() {
            return LittleStructureRegistry.getStructureType(LittleStructureMessage.class);
        }
    }
}

