/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.box;

import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.common.tile.combine.BasicCombiner;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class LittleBoxesNoOverlap
extends LittleBoxes {
    protected HashMapList<BlockPos, LittleBox> blockMap = new HashMapList();
    protected HashMapList<BlockPos, LittleBox> tempMap = new HashMapList();
    protected List<LittleBox> cutOutTemp = new ArrayList<LittleBox>();

    public LittleBoxesNoOverlap(BlockPos pos, LittleGridContext context, HashMapList<BlockPos, LittleBox> map) {
        super(pos, context);
        this.blockMap = map;
    }

    public LittleBoxesNoOverlap(BlockPos pos, LittleGridContext context) {
        super(pos, context);
    }

    @Override
    public void add(LittleBox box) {
        this.tempMap.clear();
        box.split(this.context, this.pos, this.tempMap, null);
        for (Map.Entry entry : this.tempMap.entrySet()) {
            boolean missing;
            ArrayList<LittleBox> existingBoxes = this.blockMap.getValues(entry.getKey());
            boolean bl = missing = existingBoxes == null;
            if (missing) {
                existingBoxes = new ArrayList<LittleBox>();
            }
            for (LittleBox splitted : (ArrayList)entry.getValue()) {
                this.cutOutTemp.clear();
                existingBoxes.addAll(splitted.cutOut(existingBoxes, this.cutOutTemp, null));
            }
            BasicCombiner.combineBoxesOnlyLast(existingBoxes);
            if (!missing) continue;
            this.blockMap.add(entry.getKey(), existingBoxes);
        }
    }

    @Override
    public LittleBoxesNoOverlap copy() {
        return new LittleBoxesNoOverlap(this.pos, this.context, (HashMapList<BlockPos, LittleBox>)new HashMapList(this.blockMap));
    }

    @Override
    public void convertTo(LittleGridContext to) {
        for (LittleBox box : this.blockMap) {
            box.convertTo(this.context, to);
        }
        this.context = to;
    }

    @Override
    public void convertToSmallest() {
        int size = LittleGridContext.minSize;
        for (LittleBox box : this.blockMap) {
            size = Math.max(size, box.getSmallestContext(this.context));
        }
        if (size < this.context.size) {
            this.convertTo(LittleGridContext.get(size));
        }
    }

    @Override
    public void clear() {
        this.blockMap.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.blockMap.isEmpty();
    }

    @Override
    public int size() {
        return this.blockMap.sizeOfValues();
    }

    @Override
    public LittleBox getSurroundingBox() {
        if (this.isEmpty()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (Map.Entry entry : this.blockMap.entrySet()) {
            int x = ((BlockPos)entry.getKey()).func_177958_n() * this.context.size;
            int y = ((BlockPos)entry.getKey()).func_177956_o() * this.context.size;
            int z = ((BlockPos)entry.getKey()).func_177952_p() * this.context.size;
            for (LittleBox box : (ArrayList)entry.getValue()) {
                minX = Math.min(minX, x + box.minX);
                minY = Math.min(minY, y + box.minY);
                minZ = Math.min(minZ, z + box.minZ);
                maxX = Math.max(maxX, x + box.maxX);
                maxY = Math.max(maxY, y + box.maxY);
                maxZ = Math.max(maxZ, z + box.maxZ);
            }
        }
        return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public HashMapList<BlockPos, LittleBox> generateBlockWise() {
        return this.blockMap;
    }

    @Override
    public Iterable<LittleBox> all() {
        ArrayList<LittleBox> boxes = new ArrayList<LittleBox>();
        LittleVec vec = new LittleVec(0, 0, 0);
        for (Map.Entry entry : this.blockMap.entrySet()) {
            vec.set(this.context, (Vec3i)((BlockPos)entry.getKey()).func_177973_b((Vec3i)this.pos));
            for (LittleBox box : (ArrayList)entry.getValue()) {
                LittleBox toAdd = box.copy();
                toAdd.add(vec);
                boxes.add(toAdd);
            }
        }
        return boxes;
    }

    @Override
    public void flip(EnumFacing.Axis axis, LittleAbsoluteBox absoluteBox) {
        this.ensureContext(absoluteBox, () -> {
            HashMapList<BlockPos, LittleBox> oldMap = this.blockMap;
            this.blockMap = new HashMapList();
            LittleVec center = absoluteBox.getDoubledCenter(this.pos);
            for (LittleBox box : this.all()) {
                box.flipBox(axis, center);
                this.add(box);
            }
        });
    }

    @Override
    public void combineBoxesBlocks() {
    }
}

