/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.box;

import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.combine.BasicCombiner;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.util.grid.IGridBased;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class LittleBoxesSimple
extends LittleBoxes
implements IGridBased,
Iterable<LittleBox> {
    protected List<LittleBox> boxes = new ArrayList<LittleBox>();

    public LittleBoxesSimple(BlockPos pos, LittleGridContext context) {
        super(pos, context);
    }

    @Override
    public void add(LittleBox box) {
        this.boxes.add(box);
    }

    @Override
    public boolean isEmpty() {
        return this.boxes.isEmpty();
    }

    @Override
    public void clear() {
        this.boxes.clear();
    }

    @Override
    public int size() {
        return this.boxes.size();
    }

    @Override
    public LittleBox addBox(IParentTileList parent, LittleTile tile) {
        return this.addBox(parent.getContext(), parent.getPos(), tile.getBox().copy());
    }

    @Override
    public LittleBox addBox(LittleGridContext context, BlockPos pos, LittleBox box) {
        if (this.context != context) {
            if (this.context.size > context.size) {
                box.convertTo(context, this.context);
                context = this.context;
            } else {
                this.convertTo(context);
            }
        }
        box.add(new LittleVec(context, (Vec3i)pos.func_177973_b((Vec3i)this.pos)));
        this.add(box);
        return box;
    }

    @Override
    public LittleGridContext getContext() {
        return this.context;
    }

    @Override
    public void convertTo(LittleGridContext to) {
        for (LittleBox box : this.boxes) {
            box.convertTo(this.context, to);
        }
        this.context = to;
    }

    @Override
    public void convertToSmallest() {
        int size = LittleGridContext.minSize;
        for (LittleBox box : this.boxes) {
            size = Math.max(size, box.getSmallestContext(this.context));
        }
        if (size < this.context.size) {
            this.convertTo(LittleGridContext.get(size));
        }
    }

    @Override
    public LittleBox getSurroundingBox() {
        if (this.isEmpty()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittleBox box : this.boxes) {
            minX = Math.min(minX, box.minX);
            minY = Math.min(minY, box.minY);
            minZ = Math.min(minZ, box.minZ);
            maxX = Math.max(maxX, box.maxX);
            maxY = Math.max(maxY, box.maxY);
            maxZ = Math.max(maxZ, box.maxZ);
        }
        return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public Iterator<LittleBox> iterator() {
        return this.boxes.iterator();
    }

    @Override
    public Iterable<LittleBox> all() {
        return this;
    }

    @Override
    public HashMapList<BlockPos, LittleBox> generateBlockWise() {
        HashMapList map = new HashMapList();
        for (LittleBox box : this) {
            box.split(this.context, this.pos, (HashMapList<BlockPos, LittleBox>)map, null);
        }
        return map;
    }

    @Override
    public void flip(EnumFacing.Axis axis, LittleAbsoluteBox absoluteBox) {
        this.ensureContext(absoluteBox, () -> {
            LittleVec center = absoluteBox.getDoubledCenter(this.pos);
            for (LittleBox box : this.boxes) {
                box.flipBox(axis, center);
            }
        });
    }

    @Override
    public LittleBoxes copy() {
        LittleBoxesSimple boxes = new LittleBoxesSimple(this.pos, this.context);
        boxes.boxes.addAll(this.boxes);
        return boxes;
    }

    @Override
    public void combineBoxesBlocks() {
        HashMapList chunked = new HashMapList();
        for (int i = 0; i < this.boxes.size(); ++i) {
            chunked.add((Object)this.boxes.get(i).getMinVec().getBlockPos(this.context), (Object)this.boxes.get(i));
        }
        this.boxes.clear();
        for (ArrayList list : chunked.values()) {
            BasicCombiner.combineBoxes(list);
            this.boxes.addAll(list);
        }
    }
}

