/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.box.slice;

import com.creativemd.creativecore.CreativeCore;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.VectorUtils;
import com.creativemd.creativecore.common.utils.math.box.BoxCorner;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import java.util.Arrays;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public enum LittleSlice {
    X_US_DN_RIGHT(EnumFacing.Axis.X, true, 2, 0, BoxCorner.EUS, BoxCorner.EDN),
    X_US_DN_LEFT(EnumFacing.Axis.X, false, 0, 2, BoxCorner.EUS, BoxCorner.EDN),
    X_DS_UN_RIGHT(EnumFacing.Axis.X, true, 0, 2, BoxCorner.EDS, BoxCorner.EUN),
    X_DS_UN_LEFT(EnumFacing.Axis.X, false, 2, 0, BoxCorner.EDS, BoxCorner.EUN),
    Y_ES_WN_RIGHT(EnumFacing.Axis.Y, true, 1, 0, BoxCorner.EUS, BoxCorner.WUN),
    Y_ES_WN_LEFT(EnumFacing.Axis.Y, false, 0, 1, BoxCorner.EUS, BoxCorner.WUN),
    Y_WS_EN_RIGHT(EnumFacing.Axis.Y, true, 0, 1, BoxCorner.WUS, BoxCorner.EUN),
    Y_WS_EN_LEFT(EnumFacing.Axis.Y, false, 1, 0, BoxCorner.WUS, BoxCorner.EUN),
    Z_WU_ED_RIGHT(EnumFacing.Axis.Z, true, 2, 0, BoxCorner.WUS, BoxCorner.EDS),
    Z_WU_ED_LEFT(EnumFacing.Axis.Z, false, 0, 2, BoxCorner.WUS, BoxCorner.EDS),
    Z_WD_EU_RIGHT(EnumFacing.Axis.Z, true, 0, 2, BoxCorner.WDS, BoxCorner.EUS),
    Z_WD_EU_LEFT(EnumFacing.Axis.Z, false, 2, 0, BoxCorner.WDS, BoxCorner.EUS);

    public final EnumFacing.Axis axis;
    public final Vec3i sliceVec;
    public final EnumFacing emptySideOne;
    public final EnumFacing emptySideTwo;
    public final boolean isRight;
    public final BoxCorner start;
    public final BoxCorner end;
    public final int traingleOrderPositive;
    public final int traingleOrderNegative;
    private final int[] normal;

    public static LittleSlice getSliceFromNormal(int[] normal) {
        for (LittleSlice slice : LittleSlice.values()) {
            if (!Arrays.equals(slice.normal, normal)) continue;
            return slice;
        }
        return null;
    }

    public static int getDirectionBetweenFacing(EnumFacing facing, EnumFacing facing2) {
        if (facing.func_176743_c() == facing2.func_176743_c()) {
            return 0;
        }
        return facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? -1 : 1;
    }

    public static LittleSlice getSliceByID(int id) {
        if (id < 12) {
            return LittleSlice.getOlderSlice(id);
        }
        if (id < 24) {
            return LittleSlice.getOldSlice(id - 12);
        }
        return LittleSlice.values()[id - 24];
    }

    private static void checkVersion() {
        if (ReflectionHelper.getPrivateValue(CreativeCore.class, null, (String[])new String[]{"version"}).equals("1.7.4") || ReflectionHelper.getPrivateValue(CreativeCore.class, null, (String[])new String[]{"version"}).equals("1.9.8")) {
            throw new RuntimeException("Please update CreativeCore");
        }
    }

    public static LittleSlice getOldSlice(int id) {
        LittleSlice.checkVersion();
        LittleSlice wrongSlice = LittleSlice.values()[id];
        if (wrongSlice.axis == EnumFacing.Axis.Y) {
            for (LittleSlice slice : LittleSlice.values()) {
                if (slice.axis != wrongSlice.axis || !slice.start.equals((Object)wrongSlice.start) || !slice.end.equals((Object)wrongSlice.end) || slice.isRight == wrongSlice.isRight) continue;
                return slice;
            }
            throw new RuntimeException("Slice id=" + id + " could not be converted to the new slice format");
        }
        return wrongSlice;
    }

    public static LittleSlice getOlderSlice(int id) {
        LittleSlice.checkVersion();
        LittleSlice wrongSlice = LittleSlice.values()[id];
        if (wrongSlice.axis == EnumFacing.Axis.X) {
            for (LittleSlice slice : LittleSlice.values()) {
                if (slice.axis != wrongSlice.axis || !slice.start.equals((Object)wrongSlice.start) || !slice.end.equals((Object)wrongSlice.end) || slice.isRight == wrongSlice.isRight) continue;
                return slice;
            }
            throw new RuntimeException("Slice id=" + id + " could not be converted to the new slice format");
        }
        return wrongSlice;
    }

    private LittleSlice(EnumFacing.Axis axis, boolean isRight, int traingleOrderPositive, int traingleOrderNegative, BoxCorner start, BoxCorner end) {
        this.axis = axis;
        this.isRight = isRight;
        this.start = start;
        this.end = end;
        this.traingleOrderPositive = traingleOrderPositive;
        this.traingleOrderNegative = traingleOrderNegative;
        this.sliceVec = new Vec3i(LittleSlice.getDirectionBetweenFacing(start.x, end.x), LittleSlice.getDirectionBetweenFacing(start.y, end.y), LittleSlice.getDirectionBetweenFacing(start.z, end.z));
        Vec3i temp = RotationUtils.rotate((Vec3i)this.sliceVec, (Rotation)Rotation.getRotation((EnumFacing.Axis)axis, (boolean)isRight));
        this.normal = new int[]{temp.func_177958_n(), temp.func_177956_o(), temp.func_177952_p()};
        EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
        EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
        this.emptySideOne = EnumFacing.func_181076_a((EnumFacing.AxisDirection)(this.normal[one.ordinal()] == 1 ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)one);
        this.emptySideTwo = EnumFacing.func_181076_a((EnumFacing.AxisDirection)(this.normal[two.ordinal()] == 1 ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)two);
    }

    public LittleSlice getOpposite() {
        return LittleSlice.getSliceFromNormal(new int[]{-this.normal[0], -this.normal[1], -this.normal[2]});
    }

    public int getDirectionScale(EnumFacing.Axis axis) {
        return VectorUtils.get((EnumFacing.Axis)axis, (Vec3i)this.sliceVec);
    }

    public boolean isFacingPositive(EnumFacing.Axis axis) {
        return this.normal[axis.ordinal()] > 0;
    }

    public EnumFacing getEmptySide(EnumFacing.Axis axis) {
        return EnumFacing.func_181076_a((EnumFacing.AxisDirection)(this.normal[axis.ordinal()] > 0 ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)axis);
    }

    public int[] getNormal() {
        return this.normal;
    }

    public Vec3d getNormalVec() {
        return new Vec3d((double)this.normal[0], (double)this.normal[1], (double)this.normal[2]).func_72432_b();
    }

    public LittleSlice rotate(Rotation rotation) {
        return LittleSlice.getSliceFromNormal(new int[]{rotation.getMatrix().getX(this.normal), rotation.getMatrix().getY(this.normal), rotation.getMatrix().getZ(this.normal)});
    }

    public LittleSlice flip(EnumFacing.Axis axis) {
        int[] newNormal = Arrays.copyOf(this.normal, this.normal.length);
        newNormal[axis.ordinal()] = -newNormal[axis.ordinal()];
        return LittleSlice.getSliceFromNormal(newNormal);
    }

    public EnumFacing getPreferedSide(LittleVec size) {
        int sizeTwo;
        int sizeOne = size.get(this.emptySideOne.func_176740_k());
        if (sizeOne > (sizeTwo = size.get(this.emptySideTwo.func_176740_k()))) {
            return this.emptySideTwo;
        }
        if (sizeOne < sizeTwo) {
            return this.emptySideOne;
        }
        return this.emptySideOne.func_176740_k() == EnumFacing.Axis.Y ? this.emptySideOne : this.emptySideTwo;
    }

    public EnumFacing getPreferedSide(Vector3d size) {
        double sizeTwo;
        double sizeOne = VectorUtils.get((EnumFacing.Axis)this.emptySideOne.func_176740_k(), (Tuple3d)size);
        if (sizeOne > (sizeTwo = VectorUtils.get((EnumFacing.Axis)this.emptySideTwo.func_176740_k(), (Tuple3d)size))) {
            return this.emptySideTwo;
        }
        if (sizeOne < sizeTwo) {
            return this.emptySideOne;
        }
        return this.emptySideOne.func_176740_k() == EnumFacing.Axis.Y ? this.emptySideOne : this.emptySideTwo;
    }

    public EnumFacing getPreferedSide(Vec3d size) {
        double sizeTwo;
        double sizeOne = VectorUtils.get((EnumFacing.Axis)this.emptySideOne.func_176740_k(), (Vec3d)size);
        if (sizeOne > (sizeTwo = VectorUtils.get((EnumFacing.Axis)this.emptySideTwo.func_176740_k(), (Vec3d)size))) {
            return this.emptySideTwo;
        }
        if (sizeOne < sizeTwo) {
            return this.emptySideOne;
        }
        return this.emptySideOne.func_176740_k() == EnumFacing.Axis.Y ? this.emptySideOne : this.emptySideTwo;
    }

    public boolean shouldRenderSide(EnumFacing facing, LittleVec size) {
        if (this.normal[facing.func_176740_k().ordinal()] == facing.func_176743_c().func_179524_a()) {
            int sizeTwo;
            int sizeOne;
            EnumFacing.Axis otherAxis = RotationUtils.getOne((EnumFacing.Axis)this.axis);
            if (otherAxis == facing.func_176740_k()) {
                otherAxis = RotationUtils.getTwo((EnumFacing.Axis)this.axis);
            }
            if ((sizeOne = size.get(facing.func_176740_k())) > (sizeTwo = size.get(otherAxis))) {
                return false;
            }
            if (sizeOne < sizeTwo) {
                return true;
            }
            return this.axis == EnumFacing.Axis.Y ? RotationUtils.getOne((EnumFacing.Axis)this.axis) == facing.func_176740_k() : otherAxis != EnumFacing.Axis.Y;
        }
        return true;
    }

    public boolean shouldRenderSide(EnumFacing facing, Vec3d size) {
        if (this.normal[facing.func_176740_k().ordinal()] == facing.func_176743_c().func_179524_a()) {
            double sizeTwo;
            double sizeOne;
            EnumFacing.Axis otherAxis = RotationUtils.getOne((EnumFacing.Axis)this.axis);
            if (otherAxis == facing.func_176740_k()) {
                otherAxis = RotationUtils.getTwo((EnumFacing.Axis)this.axis);
            }
            if ((sizeOne = VectorUtils.get((EnumFacing.Axis)facing.func_176740_k(), (Vec3d)size)) > (sizeTwo = VectorUtils.get((EnumFacing.Axis)otherAxis, (Vec3d)size))) {
                return false;
            }
            if (sizeOne < sizeTwo) {
                return true;
            }
            return this.axis == EnumFacing.Axis.Y ? RotationUtils.getOne((EnumFacing.Axis)this.axis) == facing.func_176740_k() : otherAxis != EnumFacing.Axis.Y;
        }
        return true;
    }

    public BoxCorner getFilledCorner() {
        return BoxCorner.getCornerUnsorted((EnumFacing)RotationUtils.getFacing((EnumFacing.Axis)this.axis), (EnumFacing)this.emptySideOne.func_176734_d(), (EnumFacing)this.emptySideTwo.func_176734_d());
    }

    public BoxCorner getEmptyCorner() {
        return BoxCorner.getCornerUnsorted((EnumFacing)RotationUtils.getFacing((EnumFacing.Axis)this.axis), (EnumFacing)this.emptySideOne, (EnumFacing)this.emptySideTwo);
    }

    public boolean isCornerAffected(BoxCorner corner) {
        return !(corner.x != this.emptySideOne && corner.y != this.emptySideOne && corner.z != this.emptySideOne || corner.x != this.emptySideTwo && corner.y != this.emptySideTwo && corner.z != this.emptySideTwo);
    }

    public int getSliceID() {
        return this.ordinal() + 24;
    }
}

