/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.instantunify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import wanion.unidict.UniDict;
import wanion.unidict.resource.ResourceHandler;

@Mod(modid="instantunify", name="InstantUnify", version="1.1.2", dependencies="before:unidict@[1.12.2-2.2,);", acceptedMinecraftVersions="[1.12,1.13)", acceptableRemoteVersions="*")
@Mod.EventBusSubscriber
public class InstantUnify {
    @Mod.Instance(value="instantunify")
    public static InstantUnify INSTANCE;
    public static final String VERSION = "1.1.2";
    public static final String NAME = "InstantUnify";
    public static final String MODID = "instantunify";
    public static Configuration config;
    public static List<String> blacklist;
    public static List<String> whitelist;
    public static List<String> preferredMods;
    public static List<String> blacklistMods;
    public static boolean drop;
    public static boolean harvest;
    public static boolean gui;
    public static boolean second;
    public static boolean death;
    public static boolean useUnidict;
    public static int listMode;
    public static Map<String, List<String>> alternatives;
    private static Object resourceHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        blacklist = new ArrayList<String>(Arrays.asList(config.getStringList("blacklist", "List", new String[]{".*Wood", ".*Glass.*", "stair.*", "fence.*", "plank.*", "slab.*", ".*Marble.*"}, "OreDict names that shouldn't be unified. (supports regex)" + Configuration.NEW_LINE)));
        whitelist = new ArrayList<String>(Arrays.asList(config.getStringList("whitelist", "List", new String[]{"block.*", "chunk.*", "dust.*", "dustSmall.*", "dustTiny.*", "gear.*", "gem.*", "ingot.*", "nugget.*", "ore.*", "plate.*", "rod.*"}, "OreDict names that should be unified. (supports regex)" + Configuration.NEW_LINE)));
        listMode = config.getInt("listMode", "List", 2, 0, 3, "0 - use whitelist" + Configuration.NEW_LINE + "1 - use blacklist" + Configuration.NEW_LINE + "2 - use both lists" + Configuration.NEW_LINE + "3 - use no list" + Configuration.NEW_LINE);
        preferredMods = new ArrayList<String>(Arrays.asList(config.getStringList("preferredMods", "general", new String[]{"minecraft", "thermalfoundation", "immersiveengineering", "embers"}, "Preferred Mods" + Configuration.NEW_LINE)));
        blacklistMods = new ArrayList<String>(Arrays.asList(config.getStringList("blacklistMods", "general", new String[]{"chisel", "astralsorcery"}, "Blacklisted Mods" + Configuration.NEW_LINE)));
        drop = config.getBoolean("drop", "unifyEvent", true, "Unify when items drop.");
        harvest = config.getBoolean("harvest", "unifyEvent", true, "Unify when blocks are harvested.");
        death = config.getBoolean("death", "unifyEvent", false, "Unify drops when entities die.");
        second = config.getBoolean("second", "unifyEvent", false, "Unify every second items in player's inventory.");
        gui = config.getBoolean("gui", "unifyEvent", true, "Unify items in player's inventory when GUI is opened/closed.");
        useUnidict = config.getBoolean("useUnidict", "general", true, "Use UniDict's settings to unify. (Other settings from this mod will be ignored.)") && Loader.isModLoaded((String)"unidict");
        List alts = Arrays.stream(config.getStringList("alternatives", "general", new String[]{"aluminum aluminium bauxite"}, "OreDict names that should be unified even if they are different." + Configuration.NEW_LINE)).map(s -> Arrays.stream(s.trim().split("\\s+")).filter(ss -> !ss.isEmpty()).collect(Collectors.toList())).collect(Collectors.toList());
        for (List lis : alts) {
            for (String n : lis) {
                ArrayList copy = new ArrayList(lis);
                copy.remove(n);
                if (copy.isEmpty()) continue;
                alternatives.put(n, copy);
            }
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (useUnidict) {
            resourceHandler = UniDict.getResourceHandler();
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        if (useUnidict) {
            try {
                ((ResourceHandler)resourceHandler).populateIndividualStackAttributes();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void spawn(EntityJoinWorldEvent event) {
        if (drop && event.getEntity() instanceof EntityItem && !event.getWorld().field_72995_K) {
            EntityItem ei = (EntityItem)event.getEntity();
            ei.func_92058_a(InstantUnify.replace(ei.func_92059_d()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void harvest(BlockEvent.HarvestDropsEvent event) {
        if (harvest) {
            try {
                event.getDrops().replaceAll(InstantUnify::replace);
            }
            catch (UnsupportedOperationException e) {
                Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
                LogManager.getLogger((String)MODID).warn("Drops of " + block + " can't be replaced.");
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void death(LivingDropsEvent event) {
        if (death && !event.getEntity().field_70170_p.field_72995_K) {
            event.getDrops().forEach(ei -> ei.func_92058_a(InstantUnify.replace(ei.func_92059_d())));
        }
    }

    @SubscribeEvent
    public static void player(TickEvent.PlayerTickEvent event) {
        if (second && event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K && event.player.field_70173_aa % 20 == 0) {
            boolean changed = false;
            for (int i = 0; i < event.player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack slot = event.player.field_71071_by.func_70301_a(i);
                Optional<ItemStack> op = InstantUnify.replaceOptional(slot);
                if (!op.isPresent()) continue;
                event.player.field_71071_by.func_70299_a(i, op.get());
                changed = true;
            }
            if (changed && event.player.field_71070_bA != null) {
                event.player.field_71070_bA.func_75142_b();
            }
        }
    }

    @SubscribeEvent
    public static void open(PlayerContainerEvent event) {
        if (gui && !event.getEntityPlayer().field_70170_p.field_72995_K) {
            event.getContainer().field_75151_b.stream().filter(slot -> slot.field_75224_c instanceof InventoryPlayer).forEach(slot -> slot.func_75215_d(InstantUnify.replace(slot.func_75211_c())));
            event.getContainer().func_75142_b();
        }
    }

    private static ItemStack replace(ItemStack orig) {
        Optional<ItemStack> op = InstantUnify.replaceOptional(orig);
        return op.isPresent() ? op.get() : orig;
    }

    private static Optional<ItemStack> replaceOptional(ItemStack orig) {
        if (useUnidict && resourceHandler != null) {
            ItemStack res = ((ResourceHandler)resourceHandler).getMainItemStack(orig);
            return res.func_190926_b() || res.func_77969_a(orig) ? Optional.empty() : Optional.of(res);
        }
        if (orig.func_190926_b() || blacklistMods.contains(orig.func_77973_b().getRegistryName().func_110624_b())) {
            return Optional.empty();
        }
        Object[] oreNames = InstantUnify.oreNames(orig);
        if (oreNames.length == 0) {
            return Optional.empty();
        }
        for (String string : oreNames) {
            if (!(listMode != 0 && listMode != 2 || whitelist.stream().anyMatch(s -> Pattern.matches(s, o)))) {
                return Optional.empty();
            }
            if (listMode != 1 && listMode != 2 || !blacklist.stream().anyMatch(s -> Pattern.matches(s, o))) continue;
            return Optional.empty();
        }
        List stacks = OreDictionary.getOres((String)oreNames[0]).stream().sorted((s1, s2) -> {
            int i1 = preferredMods.indexOf(s1.func_77973_b().getRegistryName().func_110624_b());
            int i2 = preferredMods.indexOf(s2.func_77973_b().getRegistryName().func_110624_b());
            return Integer.compare(i1 == -1 ? 999 : i1, i2 == -1 ? 999 : i2);
        }).collect(Collectors.toList());
        if (stacks.stream().map(s -> s.func_77973_b().getRegistryName().func_110624_b()).distinct().count() == 1L) {
            return Optional.empty();
        }
        for (ItemStack s3 : stacks) {
            if (!Arrays.equals(oreNames, InstantUnify.oreNames(s3))) continue;
            if (s3.func_77952_i() == Short.MAX_VALUE) {
                if (s3.func_77973_b() != orig.func_77973_b()) continue;
                return Optional.empty();
            }
            ItemStack itemStack = ItemHandlerHelper.copyStackWithSize((ItemStack)s3, (int)orig.func_190916_E());
            return itemStack.func_77969_a(orig) ? Optional.empty() : Optional.of(itemStack);
        }
        return Optional.empty();
    }

    private static String[] oreNames(ItemStack s) {
        List ores = Arrays.stream(OreDictionary.getOreIDs((ItemStack)s)).mapToObj(OreDictionary::getOreName).collect(Collectors.toList());
        for (String ore : new ArrayList(ores)) {
            for (Map.Entry<String, List<String>> e : alternatives.entrySet()) {
                String key = e.getKey();
                if (!ore.contains(key)) continue;
                List<String> val = e.getValue();
                for (String alt : val) {
                    ores.add(ore.replace(key, alt));
                }
            }
        }
        return (String[])ores.stream().distinct().sorted().toArray(String[]::new);
    }

    static {
        alternatives = new HashMap<String, List<String>>();
    }
}

