/*
 * Decompiled with CFR 0.152.
 */
package openmods.config.game;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;

public class FactoryRegistry<T> {
    private final Map<String, Factory<T>> customFactories = Maps.newHashMap();

    public void registerFactory(String feature, Factory<T> factory) {
        this.customFactories.put(feature, factory);
    }

    public <C extends T> C construct(String feature, Class<? extends C> cls) {
        Factory<T> customFactory = this.customFactories.get(feature);
        if (customFactory != null) {
            T result = customFactory.construct();
            Preconditions.checkArgument((boolean)cls.isInstance(result), (String)"Invalid class for feature entry '%s', got '%s', expected '%s'", (Object)feature, (Object)(result != null ? result.getClass().toString() : "null"), cls);
            return (C)result;
        }
        try {
            return cls.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface Factory<T> {
        public T construct();
    }
}

