/*
 * Decompiled with CFR 0.152.
 */
package openmods.geometry;

public class Box2d {
    public static final Box2d NULL = new Box2d(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public final float top;
    public final float bottom;
    public final float left;
    public final float right;
    public final float width;
    public final float height;

    private Box2d(float top, float bottom, float left, float right, float width, float height) {
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
        this.width = width;
        this.height = height;
    }

    public static Box2d fromCoords(float top, float bottom, float left, float right) {
        float tmp;
        if (bottom < top) {
            tmp = bottom;
            bottom = top;
            top = tmp;
        }
        if (left > right) {
            tmp = left;
            left = right;
            right = tmp;
        }
        return new Box2d(top, bottom, left, right, right - left, bottom - top);
    }

    public static Box2d fromOriginAndSize(float x, float y, float width, float height) {
        float top;
        float bottom;
        float right;
        float left;
        if (width >= 0.0f) {
            left = x;
            right = x + width;
        } else {
            left = x + width;
            right = x;
            width = -width;
        }
        if (height >= 0.0f) {
            bottom = y + height;
            top = y;
        } else {
            bottom = y;
            top = y + height;
            height = -height;
        }
        return new Box2d(top, bottom, left, right, width, height);
    }

    public boolean isInside(float x, float y) {
        float dx = x - this.left;
        float dy = y - this.top;
        return 0.0f <= dx && 0.0f <= dy && dx < this.width && dy < this.height;
    }

    public String toString() {
        return "[" + this.top + "," + this.left + "->" + this.bottom + "," + this.right + "]";
    }
}

