/*
 * Decompiled with CFR 0.152.
 */
package openmods.liquids;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import openmods.utils.BlockUtils;
import openmods.utils.CollectionUtils;
import openmods.utils.CompatibilityUtils;

public class GenericTank
extends FluidTank {
    private List<EnumFacing> surroundingTanks = Lists.newArrayList();
    private final IFluidFilter filter;
    private static final IFluidFilter NO_RESTRICTIONS = stack -> true;

    private static IFluidFilter filter(FluidStack ... acceptableFluids) {
        if (acceptableFluids.length == 0) {
            return NO_RESTRICTIONS;
        }
        return stack -> {
            for (FluidStack acceptableFluid : acceptableFluids) {
                if (!acceptableFluid.isFluidEqual(stack)) continue;
                return true;
            }
            return false;
        };
    }

    public GenericTank(int capacity) {
        super(capacity);
        this.filter = NO_RESTRICTIONS;
    }

    public GenericTank(int capacity, FluidStack ... acceptableFluids) {
        super(capacity);
        this.filter = GenericTank.filter(acceptableFluids);
    }

    public GenericTank(int capacity, Fluid ... acceptableFluids) {
        super(capacity);
        this.filter = GenericTank.filter(CollectionUtils.transform(FluidStack.class, acceptableFluids, input -> new FluidStack(input, 0)));
    }

    private static boolean isNeighbourTank(World world, BlockPos coord, EnumFacing dir) {
        TileEntity tile = BlockUtils.getTileInDirectionSafe(world, coord, dir);
        return CompatibilityUtils.isFluidHandler(tile, dir.func_176734_d());
    }

    private static Set<EnumFacing> getSurroundingTanks(World world, BlockPos coord) {
        EnumSet<EnumFacing> result = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!GenericTank.isNeighbourTank(world, coord, dir)) continue;
            result.add(dir);
        }
        return result;
    }

    public int getSpace() {
        return this.getCapacity() - this.getFluidAmount();
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return fluid != null && this.filter.canAcceptFluid(fluid);
    }

    public void updateNeighbours(World world, BlockPos coord, Set<EnumFacing> sides) {
        this.surroundingTanks = Lists.newArrayList((Iterable)Sets.difference(GenericTank.getSurroundingTanks(world, coord), sides));
    }

    public void updateNeighbours(World world, BlockPos coord) {
        this.surroundingTanks = Lists.newArrayList(GenericTank.getSurroundingTanks(world, coord));
    }

    private static int tryFillNeighbour(FluidStack drainedFluid, EnumFacing side, TileEntity otherTank) {
        FluidStack toFill = drainedFluid.copy();
        EnumFacing fillSide = side.func_176734_d();
        IFluidHandler fluidHandler = CompatibilityUtils.getFluidHandler(otherTank, fillSide);
        return fluidHandler != null ? fluidHandler.fill(toFill, true) : 0;
    }

    public void distributeToSides(int amount, World world, BlockPos coord, Set<EnumFacing> allowedSides) {
        FluidStack drainedFluid;
        if (world == null) {
            return;
        }
        if (this.getFluidAmount() <= 0) {
            return;
        }
        if (this.surroundingTanks.isEmpty()) {
            return;
        }
        ArrayList sides = Lists.newArrayList(this.surroundingTanks);
        if (allowedSides != null) {
            sides.retainAll(allowedSides);
            if (sides.isEmpty()) {
                return;
            }
        }
        if ((drainedFluid = this.drain(amount, false)) != null && drainedFluid.amount > 0) {
            int distributed;
            int startingAmount = drainedFluid.amount;
            Collections.shuffle(sides);
            for (EnumFacing side : this.surroundingTanks) {
                if (drainedFluid.amount <= 0) break;
                TileEntity otherTank = BlockUtils.getTileInDirection(world, coord, side);
                if (otherTank == null) continue;
                drainedFluid.amount -= GenericTank.tryFillNeighbour(drainedFluid, side, otherTank);
            }
            if ((distributed = startingAmount - drainedFluid.amount) > 0) {
                this.drain(distributed, true);
            }
        }
    }

    public void fillFromSides(int maxAmount, World world, BlockPos coord) {
        this.fillFromSides(maxAmount, world, coord, null);
    }

    public void fillFromSides(int maxAmount, World world, BlockPos coord, Set<EnumFacing> allowedSides) {
        if (world == null) {
            return;
        }
        int toDrain = Math.min(maxAmount, this.getSpace());
        if (toDrain <= 0) {
            return;
        }
        if (this.surroundingTanks.isEmpty()) {
            return;
        }
        ArrayList sides = Lists.newArrayList(this.surroundingTanks);
        if (allowedSides != null) {
            sides.retainAll(allowedSides);
            if (sides.isEmpty()) {
                return;
            }
        }
        Collections.shuffle(sides);
        for (EnumFacing side : sides) {
            if (toDrain <= 0) break;
            toDrain -= this.fillInternal(world, coord, side, toDrain);
        }
    }

    public int fillFromSide(World world, BlockPos coord, EnumFacing side) {
        int maxDrain = this.getSpace();
        if (maxDrain <= 0) {
            return 0;
        }
        return this.fillInternal(world, coord, side, maxDrain);
    }

    public int fillFromSide(int maxDrain, World world, BlockPos coord, EnumFacing side) {
        if ((maxDrain = Math.min(maxDrain, this.getSpace())) <= 0) {
            return 0;
        }
        return this.fillInternal(world, coord, side, maxDrain);
    }

    private int fillInternal(World world, BlockPos coord, EnumFacing side, int maxDrain) {
        int filled;
        FluidStack drained;
        EnumFacing drainSide;
        TileEntity otherTank = BlockUtils.getTileInDirection(world, coord, side);
        IFluidHandler handler = CompatibilityUtils.getFluidHandler(otherTank, drainSide = side.func_176734_d());
        if (handler != null && (drained = handler.drain(maxDrain, false)) != null && this.filter.canAcceptFluid(drained) && (filled = this.fill(drained, true)) > 0) {
            handler.drain(filled, true);
            return filled;
        }
        return 0;
    }

    @FunctionalInterface
    public static interface IFluidFilter {
        public boolean canAcceptFluid(FluidStack var1);
    }
}

