/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.eval;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import openmods.model.ModelUpdater;
import openmods.model.eval.BakedEvalModel;
import openmods.model.eval.EvalModelBase;
import openmods.model.eval.EvaluatorFactory;
import openmods.model.eval.ITransformEvaluator;

public class EvalModel
extends EvalModelBase {
    public static final IModel EMPTY = new EvalModel(Optional.empty(), new EvaluatorFactory());

    private EvalModel(Optional<ResourceLocation> baseModel, EvaluatorFactory evaluator) {
        super(baseModel, evaluator);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel model = this.loadBaseModel(state, format, bakedTextureGetter);
        ITransformEvaluator evaluator = this.evaluatorFactory.createEvaluator(c -> model.getClip(c));
        return new BakedEvalModel(model, state, format, bakedTextureGetter, evaluator);
    }

    @Override
    protected IModel update(Map<String, String> customData, ModelUpdater updater, Optional<ResourceLocation> baseModel, EvaluatorFactory evaluator) {
        return updater.hasChanged() ? new EvalModel(baseModel, evaluator) : this;
    }
}

