/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer.shaders;

import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;

public class ShaderHelper {
    public static IShaderMethods methods;

    static void initialize() {
        ContextCapabilities caps = GLContext.getCapabilities();
        if (GL20ShaderMethods.isSupported(caps)) {
            methods = new GL20ShaderMethods();
        } else if (ARBShaderMethods.isSupported(caps)) {
            methods = new ARBShaderMethods();
        }
    }

    public static boolean isSupported() {
        return methods != null;
    }

    public static IShaderMethods methods() {
        return methods;
    }

    static {
        ShaderHelper.initialize();
    }

    private static class ARBShaderMethods
    implements IShaderMethods {
        private ARBShaderMethods() {
        }

        public static boolean isSupported(ContextCapabilities caps) {
            return caps.GL_ARB_shader_objects && caps.GL_ARB_vertex_shader && caps.GL_ARB_fragment_shader;
        }

        @Override
        public int glCreateProgram() {
            return ARBShaderObjects.glCreateProgramObjectARB();
        }

        @Override
        public int glCreateShader(int type) {
            return ARBShaderObjects.glCreateShaderObjectARB((int)type);
        }

        @Override
        public void glAttachShader(int program, int shader) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)shader);
        }

        @Override
        public void glDetachShader(int program, int shader) {
            ARBShaderObjects.glDetachObjectARB((int)program, (int)shader);
        }

        @Override
        public void glLinkProgram(int program) {
            ARBShaderObjects.glLinkProgramARB((int)program);
        }

        @Override
        public void glValidateProgram(int program) {
            ARBShaderObjects.glValidateProgramARB((int)program);
        }

        @Override
        public void glDeleteProgram(int program) {
            ARBShaderObjects.glDeleteObjectARB((int)program);
        }

        @Override
        public void glDeleteShader(int shader) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
        }

        @Override
        public int glGetProgrami(int program, int parameter) {
            return ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)parameter);
        }

        @Override
        public int glGetShaderi(int shader, int parameter) {
            return ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)parameter);
        }

        @Override
        public String getProgramLogInfo(int program) {
            return ARBShaderObjects.glGetInfoLogARB((int)program, (int)this.glGetProgrami(program, 35716));
        }

        @Override
        public String getShaderLogInfo(int shader) {
            return ARBShaderObjects.glGetInfoLogARB((int)shader, (int)this.glGetShaderi(shader, 35716));
        }

        @Override
        public void glUseProgram(int program) {
            ARBShaderObjects.glUseProgramObjectARB((int)program);
        }

        @Override
        public void glShaderSource(int shader, String shaderSource) {
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)shaderSource);
        }

        @Override
        public void glCompileShader(int shader) {
            ARBShaderObjects.glCompileShaderARB((int)shader);
        }

        @Override
        public int glGetUniformLocation(int program, String uniform) {
            return ARBShaderObjects.glGetUniformLocationARB((int)program, (CharSequence)uniform);
        }

        @Override
        public void glUniform1i(int loc, int val) {
            ARBShaderObjects.glUniform1iARB((int)loc, (int)val);
        }

        @Override
        public void glUniform1f(int loc, float val) {
            ARBShaderObjects.glUniform1fARB((int)loc, (float)val);
        }

        @Override
        public void glUniform3f(int loc, float x, float y, float z) {
            ARBShaderObjects.glUniform3fARB((int)loc, (float)x, (float)y, (float)z);
        }

        @Override
        public int glGetAttribLocation(int program, String attrib) {
            return ARBVertexShader.glGetAttribLocationARB((int)program, (CharSequence)attrib);
        }

        @Override
        public void glEnableVertexAttribArray(int index) {
            ARBVertexShader.glEnableVertexAttribArrayARB((int)index);
        }

        @Override
        public void glDisableVertexAttribArray(int index) {
            ARBVertexShader.glDisableVertexAttribArrayARB((int)index);
        }

        @Override
        public void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long offset) {
            ARBVertexShader.glVertexAttribPointerARB((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (long)offset);
        }
    }

    private static class GL20ShaderMethods
    implements IShaderMethods {
        private GL20ShaderMethods() {
        }

        public static boolean isSupported(ContextCapabilities caps) {
            return caps.OpenGL20;
        }

        @Override
        public int glCreateProgram() {
            return GL20.glCreateProgram();
        }

        @Override
        public int glCreateShader(int type) {
            return GL20.glCreateShader((int)type);
        }

        @Override
        public void glAttachShader(int program, int shader) {
            GL20.glAttachShader((int)program, (int)shader);
        }

        @Override
        public void glDetachShader(int program, int shader) {
            GL20.glDetachShader((int)program, (int)shader);
        }

        @Override
        public void glLinkProgram(int program) {
            GL20.glLinkProgram((int)program);
        }

        @Override
        public void glValidateProgram(int program) {
            GL20.glValidateProgram((int)program);
        }

        @Override
        public void glDeleteProgram(int program) {
            GL20.glDeleteProgram((int)program);
        }

        @Override
        public void glDeleteShader(int shader) {
            GL20.glDeleteShader((int)shader);
        }

        @Override
        public int glGetProgrami(int program, int parameter) {
            return GL20.glGetProgrami((int)program, (int)parameter);
        }

        @Override
        public int glGetShaderi(int shader, int parameter) {
            return GL20.glGetShaderi((int)shader, (int)parameter);
        }

        @Override
        public String getProgramLogInfo(int program) {
            return GL20.glGetProgramInfoLog((int)program, (int)this.glGetProgrami(program, 35716));
        }

        @Override
        public String getShaderLogInfo(int shader) {
            return GL20.glGetShaderInfoLog((int)shader, (int)this.glGetShaderi(shader, 35716));
        }

        @Override
        public void glUseProgram(int program) {
            GL20.glUseProgram((int)program);
        }

        @Override
        public void glShaderSource(int shader, String shaderSource) {
            GL20.glShaderSource((int)shader, (CharSequence)shaderSource);
        }

        @Override
        public void glCompileShader(int shader) {
            GL20.glCompileShader((int)shader);
        }

        @Override
        public int glGetUniformLocation(int program, String uniform) {
            return GL20.glGetUniformLocation((int)program, (CharSequence)uniform);
        }

        @Override
        public void glUniform1i(int loc, int val) {
            GL20.glUniform1i((int)loc, (int)val);
        }

        @Override
        public void glUniform1f(int loc, float val) {
            GL20.glUniform1f((int)loc, (float)val);
        }

        @Override
        public void glUniform3f(int loc, float x, float y, float z) {
            GL20.glUniform3f((int)loc, (float)x, (float)y, (float)z);
        }

        @Override
        public int glGetAttribLocation(int program, String attrib) {
            return GL20.glGetAttribLocation((int)program, (CharSequence)attrib);
        }

        @Override
        public void glEnableVertexAttribArray(int index) {
            GL20.glEnableVertexAttribArray((int)index);
        }

        @Override
        public void glDisableVertexAttribArray(int index) {
            GL20.glDisableVertexAttribArray((int)index);
        }

        @Override
        public void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long offset) {
            GL20.glVertexAttribPointer((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (long)offset);
        }
    }

    public static interface IShaderMethods {
        public int glCreateProgram();

        public int glCreateShader(int var1);

        public void glAttachShader(int var1, int var2);

        public void glDetachShader(int var1, int var2);

        public void glLinkProgram(int var1);

        public void glValidateProgram(int var1);

        public void glDeleteProgram(int var1);

        public void glDeleteShader(int var1);

        public int glGetProgrami(int var1, int var2);

        public int glGetShaderi(int var1, int var2);

        public String getProgramLogInfo(int var1);

        public String getShaderLogInfo(int var1);

        public void glUseProgram(int var1);

        public void glShaderSource(int var1, String var2);

        public void glCompileShader(int var1);

        public int glGetUniformLocation(int var1, String var2);

        public void glUniform1i(int var1, int var2);

        public void glUniform1f(int var1, float var2);

        public void glUniform3f(int var1, float var2, float var3, float var4);

        public int glGetAttribLocation(int var1, String var2);

        public void glEnableVertexAttribArray(int var1);

        public void glDisableVertexAttribArray(int var1);

        public void glVertexAttribPointer(int var1, int var2, int var3, boolean var4, int var5, long var6);
    }
}

