/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.io;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import openmods.utils.io.IByteSink;
import openmods.utils.io.IByteSource;

public class StreamAdapters {
    public static IByteSink createSink(DataOutput output) {
        return output::write;
    }

    public static IByteSink createSink(OutputStream output) {
        return output::write;
    }

    public static IByteSink createSink(ByteBuf output) {
        return arg_0 -> ((ByteBuf)output).writeByte(arg_0);
    }

    public static IByteSource createSource(DataInput input) {
        return input::readByte;
    }

    public static IByteSource createSource(InputStream input) {
        return () -> {
            int b = input.read();
            if (b < 0) {
                throw new EOFException();
            }
            return b;
        };
    }

    public static IByteSource createSource(ByteBuf output) {
        return () -> {
            try {
                return output.readUnsignedByte();
            }
            catch (IndexOutOfBoundsException e) {
                throw new EOFException();
            }
        };
    }

    public static IByteSource createSource(byte[] bytes) {
        return StreamAdapters.createSource(new ByteArrayInputStream(bytes));
    }
}

