/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.lootcapacitortooltips;

import com.tfar.lootcapacitortooltips.LootCapacitorTooltips;
import com.tfar.lootcapacitortooltips.Tooltips;
import crazypants.enderio.endergy.capacitor.ItemEndergyCapacitor;
import crazypants.enderio.endergy.capacitor.ItemTotemicCapacitor;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EndergyTooltips {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof ItemEndergyCapacitor && !(stack.func_77973_b() instanceof ItemTotemicCapacitor)) {
            float value = this.getCapacitorValue(stack);
            ArrayList tooltip = (ArrayList)event.getToolTip();
            tooltip.add(I18n.func_135052_a((String)LootCapacitorTooltips.s1, (Object[])new Object[0]) + " " + TextFormatting.func_175744_a((int)Tooltips.getColor(value)) + value);
        } else if (stack.func_77973_b() instanceof ItemTotemicCapacitor) {
            int uses = stack.func_77958_k() - stack.func_77952_i();
            ArrayList tooltip = (ArrayList)event.getToolTip();
            int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
            float value = (float)(3.5 + 0.5 * (double)level);
            if (value > 5.0f) {
                tooltip.add(I18n.func_135052_a((String)LootCapacitorTooltips.s1, (Object[])new Object[0]) + " " + TextFormatting.WHITE + TextFormatting.BOLD + value);
            } else {
                tooltip.add(I18n.func_135052_a((String)LootCapacitorTooltips.s1, (Object[])new Object[0]) + " " + TextFormatting.func_175744_a((int)Tooltips.getColor(value)) + value);
            }
            if (Tooltips.showTotemicDurability) {
                tooltip.add(I18n.func_135052_a((String)(LootCapacitorTooltips.s3 + "uses"), (Object[])new Object[0]) + " " + TextFormatting.func_175744_a((int)this.getUsesColor(uses)) + uses);
            }
        }
    }

    public float getCapacitorValue(ItemStack stack) {
        String key;
        switch (key = stack.func_77973_b().func_77658_a()) {
            case "item.item_capacitor_silver": {
                return 1.0f;
            }
            case "item.item_capacitor_energetic_silver": {
                return 2.0f;
            }
            case "item.item_capacitor_vivid": {
                return 3.0f;
            }
            case "item.item_capacitor_crystalline": {
                return 3.5f;
            }
            case "item.item_capacitor_melodic": {
                return 4.0f;
            }
            case "item.item_capacitor_stellar": {
                return 5.0f;
            }
            case "item.item_capacitor_grainy": {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    public int getUsesColor(int uses) {
        if (uses > 400) {
            return 10;
        }
        if (uses > 300) {
            return 14;
        }
        if (uses > 200) {
            return 6;
        }
        if (uses > 100) {
            return 12;
        }
        return 4;
    }
}

