/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.world.biomes;

import java.util.Random;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import prospector.traverse.world.WorldGenConstants;
import prospector.traverse.world.features.WorldGenCustomSwampTree;

public class BiomeLushSwamp
extends Biome
implements WorldGenConstants {
    protected static final WorldGenCustomSwampTree CUSTOM_SWAMP_TREE_FEATURE = new WorldGenCustomSwampTree(true, 7);
    protected static final IBlockState WATER_LILY = Blocks.field_150392_bi.func_176223_P();
    public static Biome.BiomeProperties properties = new Biome.BiomeProperties("Lush Swamp");

    public BiomeLushSwamp() {
        super(properties);
        this.field_76760_I.field_76832_z = 2;
        this.field_76760_I.field_76802_A = 5;
        this.field_76760_I.field_76804_C = 1;
        this.field_76760_I.field_76798_D = 4;
        this.field_76760_I.field_76799_E = 10;
        this.field_76760_I.field_76806_I = 1;
        this.field_76760_I.field_76833_y = 4;
        this.field_76760_I.field_76805_H = 0;
        this.field_76760_I.field_76803_B = 10;
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySlime.class, 1, 1, 1));
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return CUSTOM_SWAMP_TREE_FEATURE;
    }

    public BlockFlower.EnumFlowerType func_180623_a(Random rand, BlockPos pos) {
        return BlockFlower.EnumFlowerType.BLUE_ORCHID;
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        double d0 = field_180281_af.func_151601_a((double)x * 0.25, (double)z * 0.25);
        if (d0 > 0.0) {
            int i = x & 0xF;
            int j = z & 0xF;
            for (int k = 255; k >= 0; --k) {
                if (chunkPrimerIn.func_177856_a(j, k, i).func_185904_a() == Material.field_151579_a) continue;
                if (k != 62 || chunkPrimerIn.func_177856_a(j, k, i).func_177230_c() == Blocks.field_150355_j) break;
                chunkPrimerIn.func_177855_a(j, k, i, field_185372_h);
                if (!(d0 < 0.12)) break;
                chunkPrimerIn.func_177855_a(j, k + 1, i, WATER_LILY);
                break;
            }
        }
        this.func_180628_b(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        super.func_180624_a(worldIn, rand, pos);
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FOSSIL) && rand.nextInt(64) == 0) {
            new WorldGenFossils().func_180709_b(worldIn, rand, pos);
        }
    }

    public int getModdedBiomeGrassColor(int original) {
        return super.getModdedBiomeGrassColor(-11675592);
    }

    public int getModdedBiomeFoliageColor(int original) {
        return super.getModdedBiomeFoliageColor(-11675592);
    }

    public void addDefaultFlowers() {
        this.addFlower(Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.BLUE_ORCHID), 10);
    }

    static {
        properties.func_185410_a(Biomes.field_76780_h.func_185353_n());
        properties.func_185398_c(Biomes.field_76780_h.func_185355_j());
        properties.func_185400_d(Biomes.field_76780_h.func_185360_m());
    }
}

