/*
 * Decompiled with CFR 0.152.
 */
package assets.recipehandler;

import assets.recipehandler.RecipeMod;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class RecipeCommand
extends CommandBase {
    private static final RecipeItemHelper HELPER = new RecipeItemHelper();
    private Thread conclictCheck;
    private List<ITextComponent> dump = Lists.newArrayListWithCapacity((int)1000);
    private static int PAGE_SIZE = 30;
    private final String NAME;
    private final boolean CLIENT;

    public RecipeCommand(String title, boolean isClient) {
        this.NAME = title;
        this.CLIENT = isClient;
    }

    public String func_71517_b() {
        return this.NAME;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return this.CLIENT || super.func_184882_a(server, sender);
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_71514_a() {
        return Lists.newArrayList((Object[])new String[]{"recipes"});
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.recipes.usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if ("get".equals(args[0])) {
            if (args.length == 2) {
                return RecipeCommand.func_71530_a((String[])args, (String[])new String[]{"by_name", "by_item", "by_held"});
            }
            if (args.length == 3) {
                if ("by_name".equals(args[1])) {
                    return RecipeCommand.func_175762_a((String[])args, (Collection)ForgeRegistries.RECIPES.getKeys());
                }
                if ("by_item".equals(args[1])) {
                    return RecipeCommand.func_175762_a((String[])args, (Collection)ForgeRegistries.ITEMS.getKeys());
                }
            }
        }
        if ("check".equals(args[0])) {
            return RecipeCommand.func_71530_a((String[])args, (String[])new String[]{"result", "ingredients", "space"});
        }
        if ("container".equals(args[0])) {
            return RecipeCommand.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
        }
        return args.length == 1 ? RecipeCommand.func_71530_a((String[])args, (String[])new String[]{"check", "conflict", "get", "dump", "container", "furnace"}) : super.func_184883_a(server, sender, args, targetPos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(final MinecraftServer server, final ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if ("dump".equals(args[0])) {
            if (this.dump.isEmpty()) {
                ITextComponent separator = new TextComponentString(" | ").func_150255_a(new Style().func_150228_d(Boolean.valueOf(false)).func_150209_a(null).func_150241_a(null));
                for (ResourceLocation key : ForgeRegistries.RECIPES.getKeys()) {
                    this.dump.add(RecipeCommand.textHoverAndDisplay(key).func_150257_a(separator));
                }
            }
            int page = 1;
            int max = 1 + this.dump.size() / PAGE_SIZE;
            if (args.length > 1) {
                page = RecipeCommand.func_175764_a((String)args[1], (int)1, (int)max);
            }
            RecipeCommand.sendMessages(sender, this.dump.subList((page - 1) * PAGE_SIZE, Math.min(this.dump.size(), page * PAGE_SIZE)), PAGE_SIZE);
            sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, this.dump.size());
            TextComponentTranslation next = new TextComponentTranslation("commands.recipes.dump.page", new Object[]{page, max});
            int nextPage = page == max ? 1 : page + 1;
            next.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/recipes dump " + nextPage)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("commands.recipes.dump.next", new Object[]{nextPage})));
            sender.func_145747_a((ITextComponent)next);
            return;
        }
        this.dump.clear();
        if ("conflict".equals(args[0])) {
            if (this.conclictCheck != null && this.conclictCheck.isAlive()) {
                return;
            }
            final Collection recipes = ForgeRegistries.RECIPES.getValuesCollection();
            this.conclictCheck = new Thread(new Runnable(){

                @Override
                public void run() {
                    HashSet done = Sets.newHashSetWithExpectedSize((int)recipes.size());
                    IntArrayList leftA = new IntArrayList();
                    IntArrayList leftB = new IntArrayList();
                    for (IRecipe recipeA : recipes) {
                        for (IRecipe recipeB : recipes) {
                            if (done.contains(recipeB.getRegistryName()) || RecipeCommand.areSameGroup(recipeA, recipeB) || ItemStack.func_77989_b((ItemStack)recipeA.func_77571_b(), (ItemStack)recipeB.func_77571_b()) || !RecipeCommand.canFit(recipeA, recipeB)) continue;
                            HELPER.func_194119_a();
                            recipeA.func_192400_c().forEach(x$0 -> RecipeCommand.accountStacks(x$0));
                            leftB.clear();
                            if (!HELPER.func_194116_a(recipeB, (IntList)leftB)) continue;
                            HELPER.func_194119_a();
                            recipeB.func_192400_c().forEach(x$0 -> RecipeCommand.accountStacks(x$0));
                            leftA.clear();
                            if (!HELPER.func_194116_a(recipeA, (IntList)leftA) || !leftA.equals(leftB)) continue;
                            TextComponentTranslation message = new TextComponentTranslation("commands.recipes.conflict", new Object[]{RecipeCommand.textHoverAndDisplay(recipeA.getRegistryName()), RecipeCommand.textHoverAndDisplay(recipeB.getRegistryName())});
                            server.func_152344_a(new Runnable((ITextComponent)message){
                                final /* synthetic */ ITextComponent val$message;
                                {
                                    this.val$message = iTextComponent;
                                }

                                @Override
                                public void run() {
                                    sender.func_145747_a(this.val$message);
                                }
                            });
                        }
                        done.add(recipeA.getRegistryName());
                    }
                }
            }, "Recipes Conflict");
            this.conclictCheck.setDaemon(true);
            this.conclictCheck.start();
            return;
        }
        if ("get".equals(args[0])) {
            if (args.length < 2) {
                throw new WrongUsageException("commands.recipes.get.usage", new Object[0]);
            }
            Object stack = ItemStack.field_190927_a;
            if ("by_held".equals(args[1]) && sender.func_174793_f() != null) {
                for (Object equiped : sender.func_174793_f().func_184214_aD()) {
                    if (equiped.func_190926_b()) continue;
                    stack = equiped;
                    break;
                }
            } else if ("by_item".equals(args[1]) && args.length == 3) {
                stack = new ItemStack(RecipeCommand.func_147179_f((ICommandSender)sender, (String)args[2]));
            }
            if (!stack.func_190926_b()) {
                ArrayList messages = Lists.newArrayListWithCapacity((int)20);
                for (IRecipe recipeReg : ForgeRegistries.RECIPES) {
                    if (!ItemStack.func_185132_d((ItemStack)recipeReg.func_77571_b(), (ItemStack)stack)) continue;
                    messages.add(RecipeCommand.textHoverAndDisplay(recipeReg.getRegistryName()));
                }
                messages.add(0, new TextComponentTranslation("commands.recipes.get.item." + (messages.size() > 0), new Object[]{messages.size(), stack.func_151000_E()}));
                RecipeCommand.sendMessages(sender, messages, 1);
                return;
            } else {
                if (!"by_name".equals(args[1]) || args.length < 3) return;
                String[] texts = new String[args.length - 2];
                System.arraycopy(args, 2, texts, 0, texts.length);
                String arg = Strings.join((String[])texts, (String)" ");
                IRecipe recipe = (IRecipe)ForgeRegistries.RECIPES.getValue(new ResourceLocation(arg));
                if (recipe != null) {
                    RecipeCommand.displayRecipe(sender, recipe);
                    return;
                } else {
                    int minlv = -1;
                    ResourceLocation suggest = null;
                    for (ResourceLocation key : ForgeRegistries.RECIPES.getKeys()) {
                        String test = RecipeCommand.pathName(key);
                        int lv = StringUtils.getLevenshteinDistance((CharSequence)arg, (CharSequence)test, (int)Math.abs(test.length() - arg.length()));
                        if (lv == -1 || minlv != -1 && lv >= minlv) continue;
                        minlv = lv;
                        suggest = key;
                    }
                    if (suggest == null) throw new CommandException("commands.recipes.notFound", new Object[]{arg});
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.recipes.suggest", new Object[]{arg, RecipeCommand.textHoverAndDisplay(suggest)}));
                }
            }
            return;
        }
        if ("check".equals(args[0])) {
            ArrayList messages = Lists.newArrayListWithCapacity((int)20);
            if (args.length == 2) {
                if ("result".equals(args[1])) {
                    for (IRecipe recipe : ForgeRegistries.RECIPES) {
                        if (recipe.func_192399_d() || !recipe.func_77571_b().func_190926_b()) continue;
                        messages.add(RecipeCommand.translateAndDisplay("commands.recipes.empty_output", recipe.getRegistryName()));
                    }
                } else if ("ingredients".equals(args[1])) {
                    for (IRecipe recipe : ForgeRegistries.RECIPES) {
                        if (recipe.func_192399_d() || !RecipeCommand.emptyIngredients((Collection<Ingredient>)recipe.func_192400_c())) continue;
                        messages.add(RecipeCommand.translateAndDisplay("commands.recipes.empty_ingredients", recipe.getRegistryName()));
                    }
                }
            } else {
                if (args.length != 4 || !"space".equals(args[1])) throw new WrongUsageException("commands.recipes.check.usage", new Object[0]);
                int width = RecipeCommand.func_180528_a((String)args[2], (int)1);
                int height = RecipeCommand.func_180528_a((String)args[3], (int)1);
                InventoryCrafting inv = new InventoryCrafting(new Container(){

                    public boolean func_75145_c(EntityPlayer playerIn) {
                        return true;
                    }
                }, width, height);
                messages.add(new TextComponentTranslation("commands.recipes.check.space", new Object[]{width, height}));
                for (IRecipe recipe : ForgeRegistries.RECIPES) {
                    if (recipe.func_192399_d()) continue;
                    if (!recipe.func_194133_a(width, height)) {
                        messages.add(RecipeCommand.translateAndDisplay("commands.recipes.bigger_space", recipe.getRegistryName()));
                    }
                    try {
                        if (!recipe.func_77569_a(inv, sender.func_130014_f_())) continue;
                        messages.add(RecipeCommand.translateAndDisplay("commands.recipes.match_empty", recipe.getRegistryName()));
                    }
                    catch (Exception error) {
                        messages.add(RecipeCommand.translateAndDisplay("commands.recipes.match_error", recipe.getRegistryName()));
                    }
                }
            }
            RecipeCommand.sendMessages(sender, messages, 1);
            messages.clear();
            return;
        }
        if ("container".equals(args[0])) {
            try {
                boolean flag = RecipeCommand.func_180527_d((String)(args.length == 2 ? args[1] : ""));
                Set<String> cont = RecipeMod.registry.craftingHandler.getContainers(flag);
                if (cont == null) return;
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.recipes.container." + flag, new Object[]{cont.size()}));
                sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, cont.size());
                for (String key : cont) {
                    String temp = RecipeCommand.pathName(key.replace('.', '/'));
                    sender.func_145747_a(new TextComponentString(temp).func_150255_a(RecipeCommand.hover(RecipeCommand.getModAndPath(key.substring(0, key.length() - temp.length() - 1)))));
                }
                return;
            }
            catch (CommandException flagError) {
                throw new WrongUsageException("commands.recipes.container.usage", new Object[0]);
            }
        } else {
            if (!"furnace".equals(args[0])) return;
            int compare = RecipeMod.registry.furnaceHandler.compare();
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.recipes.furnace", new Object[]{compare}));
            sender.func_174794_a(CommandResultStats.Type.QUERY_RESULT, compare);
        }
    }

    private static ITextComponent getModAndPath(String temp) {
        TextComponentString text = new TextComponentString(temp.replace('.', '/'));
        if (text.func_150265_g().startsWith("net/minecraft/")) {
            return text.func_150258_a("\n").func_150258_a("Minecraft");
        }
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            for (String pack : mod.getOwnedPackages()) {
                if (!pack.contains(temp)) continue;
                return text.func_150258_a("\n").func_150258_a(mod.getName());
            }
        }
        return text;
    }

    private static ITextComponent textHoverAndDisplay(ResourceLocation recipeKey) {
        return new TextComponentString(RecipeCommand.pathName(recipeKey)).func_150255_a(RecipeCommand.display(recipeKey).func_150209_a(RecipeCommand.hover(recipeKey).func_150210_i()));
    }

    private static ITextComponent translateAndDisplay(String text, ResourceLocation recipeKey) {
        return new TextComponentTranslation(text, new Object[]{RecipeCommand.textHoverAndDisplay(recipeKey)});
    }

    private static Style display(ResourceLocation recipeKey) {
        return new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/recipes get by_name " + recipeKey)).func_150228_d(Boolean.valueOf(true));
    }

    private static ITextComponent translateAndHover(String text, ResourceLocation recipeKey) {
        return new TextComponentTranslation(text, new Object[]{new TextComponentString(RecipeCommand.pathName(recipeKey)).func_150255_a(RecipeCommand.hover(recipeKey))});
    }

    private static Style hover(ResourceLocation recipeKey) {
        String simple = RecipeCommand.pathName(recipeKey);
        int diff = recipeKey.func_110623_a().length() - simple.length();
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(recipeKey.func_110624_b());
        return RecipeCommand.hover((ITextComponent)new TextComponentString((diff > 0 ? recipeKey.func_110623_a().substring(0, diff) + "\n" : "") + (mod != null ? mod.getName() : recipeKey.func_110624_b())));
    }

    private static Style hover(ITextComponent hoverText) {
        return new Style().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverText)).func_150238_a(TextFormatting.BLUE);
    }

    private static String pathName(ResourceLocation recipeKey) {
        return RecipeCommand.pathName(recipeKey.func_110623_a());
    }

    private static String pathName(String recipeKey) {
        int pos = recipeKey.lastIndexOf("/") + 1;
        return pos > 0 ? recipeKey.substring(pos) : recipeKey;
    }

    private static boolean areSameGroup(IRecipe recipeA, IRecipe recipeB) {
        return recipeA.getRegistryName().func_110624_b().equals(recipeB.getRegistryName().func_110624_b()) || RecipeCommand.emptyIngredients((Collection<Ingredient>)recipeA.func_192400_c()) || RecipeCommand.emptyIngredients((Collection<Ingredient>)recipeB.func_192400_c());
    }

    private static boolean emptyIngredients(Collection<Ingredient> ingredients) {
        return ingredients.isEmpty() || ingredients.stream().allMatch(ingredient -> ingredient == Ingredient.field_193370_a || ingredient.apply(ItemStack.field_190927_a) || Arrays.stream(ingredient.func_193365_a()).allMatch(ItemStack::func_190926_b));
    }

    private static void displayRecipe(ICommandSender sender, IRecipe recipe) {
        sender.func_145747_a(RecipeCommand.translateAndHover(recipe instanceof IShapedRecipe ? "commands.recipes.found_shaped" : "commands.recipes.found_shapeless", recipe.getRegistryName()));
        if (!recipe.func_77571_b().func_190926_b()) {
            sender.func_145747_a(recipe.func_77571_b().func_151000_E());
        } else {
            sender.func_145747_a(RecipeCommand.translateAndHover("commands.recipes.empty_output", recipe.getRegistryName()));
        }
        int max = 0;
        for (Ingredient ingredient : recipe.func_192400_c()) {
            max = max < ingredient.func_193365_a().length ? ingredient.func_193365_a().length : max;
        }
        if (max == 0) {
            sender.func_145747_a(RecipeCommand.translateAndHover("commands.recipes.empty_ingredients", recipe.getRegistryName()));
            return;
        }
        ArrayList texts = Lists.newArrayListWithCapacity((int)recipe.func_192400_c().size());
        ITextComponent AIR = ItemStack.field_190927_a.func_151000_E();
        ITextComponent MADE_FROM = new TextComponentTranslation("commands.recipes.orMadeFrom", new Object[0]).func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)));
        for (int index = 0; index < max; ++index) {
            sender.func_145747_a(index > 0 ? MADE_FROM : new TextComponentTranslation("commands.recipes.madeFrom", new Object[0]).func_150255_a(MADE_FROM.func_150256_b()));
            for (Ingredient ingredient : recipe.func_192400_c()) {
                int length = ingredient.func_193365_a().length;
                texts.add(length > 0 ? ingredient.func_193365_a()[index < length ? index : 0].func_151000_E() : AIR);
            }
            RecipeCommand.sendMessages(sender, texts, recipe instanceof IShapedRecipe ? ((IShapedRecipe)recipe).getRecipeWidth() : (int)Math.ceil(Math.sqrt(texts.size())));
            texts.clear();
        }
    }

    private static void sendMessages(ICommandSender sender, List<ITextComponent> texts, int width) {
        for (int divider = 0; divider < texts.size(); divider += width) {
            Iterator<ITextComponent> itr = texts.subList(divider, Math.min(texts.size(), divider + width)).iterator();
            ITextComponent message = itr.next();
            while (itr.hasNext()) {
                message.func_150257_a(itr.next());
            }
            sender.func_145747_a(message);
        }
    }

    private static boolean canFit(IRecipe recipeA, IRecipe recipeB) {
        int maxW = 10;
        int maxH = 10;
        if (recipeA instanceof IShapedRecipe) {
            maxW = ((IShapedRecipe)recipeA).getRecipeWidth();
            maxH = ((IShapedRecipe)recipeA).getRecipeHeight();
            if (recipeB instanceof IShapedRecipe) {
                return maxW == ((IShapedRecipe)recipeB).getRecipeWidth() && maxH == ((IShapedRecipe)recipeB).getRecipeHeight();
            }
            return recipeB.func_194133_a(maxW, maxH) && !recipeB.func_194133_a(maxW - 1, maxH) && !recipeB.func_194133_a(maxW, maxH - 1);
        }
        if (recipeB instanceof IShapedRecipe) {
            maxW = ((IShapedRecipe)recipeB).getRecipeWidth();
            return recipeA.func_194133_a(maxW, maxH = ((IShapedRecipe)recipeB).getRecipeHeight()) && !recipeA.func_194133_a(maxW - 1, maxH) && !recipeA.func_194133_a(maxW, maxH - 1);
        }
        for (int i = 1; i < maxW; ++i) {
            for (int j = 1; j < maxH; ++j) {
                if (recipeA.func_194133_a(i, j) != recipeB.func_194133_a(i, j)) {
                    return false;
                }
                if (!recipeA.func_194133_a(i, j)) continue;
                return true;
            }
        }
        return true;
    }

    private static void accountStacks(Ingredient ingredient) {
        for (ItemStack stack : ingredient.func_193365_a()) {
            HELPER.func_194112_a(stack);
        }
    }
}

