/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.api;

import com.buuz135.industrial.api.extractor.ExtractorEntry;
import com.buuz135.industrial.api.recipe.BioReactorEntry;
import com.buuz135.industrial.api.recipe.FluidDictionaryEntry;
import com.buuz135.industrial.api.recipe.LaserDrillEntry;
import com.buuz135.industrial.api.recipe.ProteinReactorEntry;
import com.buuz135.industrial.api.recipe.SludgeEntry;
import com.buuz135.industrial.api.recipe.ore.OreFluidEntryFermenter;
import com.buuz135.industrial.api.recipe.ore.OreFluidEntryRaw;
import com.buuz135.industrial.api.recipe.ore.OreFluidEntrySieve;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class IndustrialForegoingHelper {
    public static final String MOD_ID = "industrialforegoing";
    public static final String API_VERSION = "5";
    public static final String API_ID = "industrialforegoingapi";

    public static boolean addBioReactorEntry(BioReactorEntry entry) {
        if (BioReactorEntry.BIO_REACTOR_ENTRIES.stream().noneMatch(entry1 -> entry.doesStackMatch(entry1.getStack()))) {
            BioReactorEntry.BIO_REACTOR_ENTRIES.add(entry);
            return true;
        }
        return false;
    }

    public static boolean removeBioReactorEntry(ItemStack stack) {
        return BioReactorEntry.BIO_REACTOR_ENTRIES.removeIf(entry -> entry.doesStackMatch(stack));
    }

    @Deprecated
    public static boolean addLaserDrillEntry(LaserDrillEntry entry) {
        try {
            throw new UnsupportedOperationException("Deprecated API Method since v1.12.0, use the new config for the Laser Drill located in config/laser_drill_ores");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public static boolean removeLaserDrillEntry(ItemStack stack) {
        try {
            throw new UnsupportedOperationException("Deprecated API Method since v1.12.0, use the new config for the Laser Drill located in config/laser_drill_ores");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean addSludgeRefinerEntry(SludgeEntry entry) {
        if (SludgeEntry.SLUDGE_RECIPES.stream().noneMatch(entry1 -> entry1.getStack().func_77969_a(entry.getStack()))) {
            SludgeEntry.SLUDGE_RECIPES.add(entry);
            return true;
        }
        return false;
    }

    public static boolean removeSludgeRefinerEntry(ItemStack stack) {
        return SludgeEntry.SLUDGE_RECIPES.removeIf(entry -> entry.getStack().func_77969_a(stack));
    }

    public static boolean addProteinReactorEntry(ProteinReactorEntry entry) {
        if (ProteinReactorEntry.PROTEIN_REACTOR_ENTRIES.stream().noneMatch(entry1 -> entry.doesStackMatch(entry1.getStack()))) {
            ProteinReactorEntry.PROTEIN_REACTOR_ENTRIES.add(entry);
            return true;
        }
        return false;
    }

    public static boolean removeProteinReactorEntry(ItemStack stack) {
        return ProteinReactorEntry.PROTEIN_REACTOR_ENTRIES.removeIf(entry -> entry.doesStackMatch(stack));
    }

    public static boolean addFluidDictionaryEntry(FluidDictionaryEntry entry) {
        if (FluidRegistry.isFluidRegistered((String)entry.getFluidOrigin()) && FluidRegistry.isFluidRegistered((String)entry.getFluidResult()) && FluidDictionaryEntry.FLUID_DICTIONARY_RECIPES.stream().noneMatch(entry1 -> entry1.getFluidOrigin().equals(entry.getFluidOrigin()) && entry1.getFluidResult().equals(entry.getFluidResult()))) {
            FluidDictionaryEntry.FLUID_DICTIONARY_RECIPES.add(entry);
            return true;
        }
        return false;
    }

    public static boolean removeFluidDictionaryEntry(FluidDictionaryEntry entry) {
        return FluidDictionaryEntry.FLUID_DICTIONARY_RECIPES.removeIf(entry1 -> entry1.getFluidOrigin().equals(entry.getFluidOrigin()) && entry1.getFluidResult().equals(entry.getFluidResult()));
    }

    public static boolean addWoodToLatex(ExtractorEntry entry) {
        if (ExtractorEntry.EXTRACTOR_ENTRIES.stream().noneMatch(extractorEntry -> extractorEntry.isEqual(entry.getItemStack()))) {
            ExtractorEntry.EXTRACTOR_ENTRIES.add(entry);
            return true;
        }
        return false;
    }

    public static boolean removeWoodToLatex(ItemStack stack) {
        return ExtractorEntry.EXTRACTOR_ENTRIES.removeIf(extractorEntry -> extractorEntry.isEqual(stack));
    }

    public static boolean addOreFluidEntryRaw(OreFluidEntryRaw raw) {
        if (OreFluidEntryRaw.ORE_RAW_ENTRIES.stream().noneMatch(raw1 -> raw1.getOre().equalsIgnoreCase(raw.getOre()))) {
            OreFluidEntryRaw.ORE_RAW_ENTRIES.add(raw);
            return true;
        }
        return false;
    }

    public static boolean removeOreFluidEntryRaw(String ore) {
        return OreFluidEntryRaw.ORE_RAW_ENTRIES.removeIf(raw -> raw.getOre().equalsIgnoreCase(ore));
    }

    public static boolean addOreFluidEntryFermenter(OreFluidEntryFermenter entryFermenter) {
        if (OreFluidEntryFermenter.ORE_FLUID_FERMENTER.stream().noneMatch(entryFermenter1 -> entryFermenter.getInput().isFluidEqual(entryFermenter1.getInput()))) {
            OreFluidEntryFermenter.ORE_FLUID_FERMENTER.add(entryFermenter);
            return true;
        }
        return false;
    }

    public static boolean removeOreFluidEntryFermenter(FluidStack input) {
        return OreFluidEntryFermenter.ORE_FLUID_FERMENTER.removeIf(raw -> raw.getInput().isFluidEqual(input));
    }

    public static boolean addOreFluidEntrySieve(OreFluidEntrySieve entrySieve) {
        if (OreFluidEntrySieve.ORE_FLUID_SIEVE.stream().noneMatch(entrySieve1 -> entrySieve1.getOutput().func_77969_a(entrySieve.getOutput()))) {
            OreFluidEntrySieve.ORE_FLUID_SIEVE.add(entrySieve);
            return true;
        }
        return false;
    }

    public static boolean removeOreFluidEntrySieve(ItemStack stack) {
        return OreFluidEntrySieve.ORE_FLUID_SIEVE.removeIf(entrySieve -> entrySieve.getOutput().func_77969_a(stack));
    }
}

