/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.agriculture;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.proxy.client.ClientProxy;
import com.buuz135.industrial.tile.WorkingAreaElectricMachine;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.LockedInventoryTogglePiece;
import net.ndrei.teslacorelib.gui.TiledRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.ToggleButtonPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.LockableItemHandler;
import net.ndrei.teslacorelib.inventory.SyncProviderLevel;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropSowerTile
extends WorkingAreaElectricMachine {
    private static final String NBT_POINTER = "pointer";
    public static EnumDyeColor[] colors = new EnumDyeColor[]{EnumDyeColor.RED, EnumDyeColor.CYAN, EnumDyeColor.PURPLE, EnumDyeColor.YELLOW, EnumDyeColor.WHITE, EnumDyeColor.MAGENTA, EnumDyeColor.LIME, EnumDyeColor.BLUE, EnumDyeColor.BLACK};
    private LockableItemHandler inPlant;
    private int pointer;
    private boolean hoeGround = true;

    public CropSowerTile() {
        super(CropSowerTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.inPlant = new LockableItemHandler(9){

            protected void onContentsChanged(int slot) {
                CropSowerTile.this.func_70296_d();
            }

            public int getSlotLimit(int slot) {
                return 16;
            }
        };
        this.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.inPlant, EnumDyeColor.GREEN, "Seeds input", new BoundingRectangle(54, 25, 54, 54)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return super.canInsertItem(slot, stack) && (stack.func_77973_b() instanceof IPlantable || ItemStackUtils.isStackOreDict(stack, "treeSapling") || ItemStackUtils.isChorusFlower(stack));
            }

            public boolean canExtractItem(int slot) {
                return false;
            }

            public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer<?> container) {
                List guiContainerPieces = super.getGuiContainerPieces(container);
                int i = 0;
                for (int x = 0; x < 3; ++x) {
                    for (int y = 0; y < 3; ++y) {
                        guiContainerPieces.add(new TiledRenderedGuiPiece(54 + 18 * x, 25 + 18 * y, 18, 18, 1, 1, BasicTeslaGuiContainer.Companion.getMACHINE_BACKGROUND(), 108, 225, colors[i]));
                        ++i;
                    }
                }
                return guiContainerPieces;
            }
        });
        this.addInventoryToStorage((ItemStackHandler)this.inPlant, "inPlant");
        this.registerSyncIntPart("hoe", nbtTagInt -> {
            this.hoeGround = nbtTagInt.func_150287_d() == 1;
        }, () -> new NBTTagInt(this.hoeGround ? 1 : 0), SyncProviderLevel.GUI);
    }

    @Override
    public AxisAlignedBB getWorkingArea() {
        return super.getWorkingArea().func_72317_d(0.0, 1.0, 0.0);
    }

    @Override
    public float work() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        List<BlockPos> blockPos = BlockUtils.getBlockPosInAABB(this.getWorkingArea());
        ++this.pointer;
        if (this.pointer >= blockPos.size()) {
            this.pointer = 0;
        }
        if (this.pointer < blockPos.size()) {
            BlockPos pos = blockPos.get(this.pointer);
            if (this.field_145850_b.func_175623_d(pos) && !this.field_145850_b.func_175623_d(pos.func_177977_b())) {
                FakePlayer player = IndustrialForegoing.getFakePlayer(this.field_145850_b);
                ItemStack stack = this.inPlant.getStackInSlot(this.getFilteredSlot(pos));
                if (stack.func_190926_b() && this.inPlant.getLocked()) {
                    ItemStack filter = this.inPlant.getFilterStack(this.getFilteredSlot(pos));
                    for (int i = 0; i < this.inPlant.getSlots(); ++i) {
                        if (this.inPlant.getStackInSlot(i).func_190926_b() || !this.inPlant.getStackInSlot(i).func_77969_a(filter)) continue;
                        stack = this.inPlant.getStackInSlot(i);
                        break;
                    }
                }
                if (!stack.func_190926_b()) {
                    if (this.hoeGround && !ItemStackUtils.isChorusFlower(stack) && !ItemStackUtils.isStackOreDict(stack, "treeSapling") && (this.field_145850_b.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c().equals(Blocks.field_150346_d) || this.field_145850_b.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c().equals(Blocks.field_150349_c))) {
                        this.field_145850_b.func_175656_a(pos.func_177972_a(EnumFacing.DOWN), Blocks.field_150458_ak.func_176223_P());
                    }
                    player.func_184611_a(EnumHand.MAIN_HAND, stack);
                    if (stack.func_77973_b().getRegistryName() != null && stack.func_77973_b().getRegistryName().func_110624_b().equals("forestry")) {
                        player.func_70080_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 90.0f, 90.0f);
                        stack.func_77957_a(this.field_145850_b, (EntityPlayer)player, EnumHand.MAIN_HAND);
                        return 1.0f;
                    }
                    EnumActionResult result = stack.func_179546_a((EntityPlayer)player, this.field_145850_b, pos.func_177977_b(), EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
                    return result == EnumActionResult.SUCCESS ? 1.0f : 0.0f;
                }
            }
        } else {
            this.pointer = 0;
        }
        return 0.1f;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound tagCompound = super.func_189515_b(compound);
        tagCompound.func_74768_a(NBT_POINTER, this.pointer);
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.pointer = !compound.func_74764_b(NBT_POINTER) ? 0 : compound.func_74762_e(NBT_POINTER);
    }

    @Override
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add(1, (IGuiContainerPiece)new LockedInventoryTogglePiece(110, 27, (SidedTileEntity)this, EnumDyeColor.GREEN));
        pieces.add((IGuiContainerPiece)new ToggleButtonPiece(118, 84, 13, 13, 0){

            protected int getCurrentState() {
                return CropSowerTile.this.hoeGround ? 1 : 0;
            }

            protected void renderState(BasicTeslaGuiContainer container, int state, BoundingRectangle box) {
            }

            public void drawBackgroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                super.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
                container.field_146297_k.func_110434_K().func_110577_a(ClientProxy.GUI);
                container.drawTexturedRect(this.getLeft() - 1, this.getTop() - 1, 49, 56, 16, 16);
                ItemStackUtils.renderItemIntoGUI(CropSowerTile.this.hoeGround ? new ItemStack(Items.field_151081_bc, 1, 0) : new ItemStack((Block)Blocks.field_150328_O, 1, 3), this.getLeft() + guiX - 2, this.getTop() + guiY - (CropSowerTile.this.hoeGround ? 1 : 5), 9);
            }

            protected void clicked() {
                CropSowerTile.this.sendToServer(CropSowerTile.this.setupSpecialNBTMessage("HOE"));
            }

            @NotNull
            protected List<String> getStateToolTip(int state) {
                return Arrays.asList(new TextComponentTranslation("text.industrialforegoing.button.sower.hoe." + CropSowerTile.this.hoeGround, new Object[0]).func_150254_d());
            }
        });
        return pieces;
    }

    @Nullable
    protected SimpleNBTMessage processClientMessage(@Nullable String messageType, @NotNull NBTTagCompound compound) {
        if (messageType != null && messageType.equalsIgnoreCase("HOE")) {
            this.hoeGround = !this.hoeGround;
            this.func_70296_d();
            this.forceSync();
        }
        return super.processClientMessage(messageType, compound);
    }

    private int getFilteredSlot(BlockPos pos) {
        int radius = this.getRadius();
        if (radius == 0) {
            for (int i = 0; i < this.inPlant.getSlots(); ++i) {
                if (this.inPlant.getStackInSlot(i).func_190926_b()) continue;
                return i;
            }
        }
        int x = Math.round(1.49f * (float)(pos.func_177958_n() - this.field_174879_c.func_177958_n()) / (float)radius);
        int z = Math.round(1.49f * (float)(pos.func_177952_p() - this.field_174879_c.func_177952_p()) / (float)radius);
        return 4 + x + 3 * z;
    }
}

