/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.misc;

import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.WorkUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;

public class OreProcessorTile
extends CustomElectricMachine {
    private ItemStackHandler input;
    private IFluidTank tank;
    private ItemStackHandler output;

    public OreProcessorTile() {
        super(OreProcessorTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.input = new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                OreProcessorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.input, EnumDyeColor.BLUE, "Ores input", 48, 25, 1, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                if (ItemStackUtils.isOre(stack) && Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150350_a) {
                    Block block = Block.func_149634_a((Item)stack.func_77973_b());
                    NonNullList stacks = NonNullList.func_191196_a();
                    block.getDrops(stacks, (IBlockAccess)OreProcessorTile.this.field_145850_b, OreProcessorTile.this.field_174879_c, block.func_176203_a(stack.func_77960_j()), 0);
                    if (stacks.size() > 0 && !((ItemStack)stacks.get(0)).func_77969_a(stack)) {
                        return true;
                    }
                }
                return false;
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        });
        this.addInventoryToStorage(this.input, "input");
        this.tank = this.addFluidTank(FluidsRegistry.ESSENCE, 8000, EnumDyeColor.GREEN, "Essence tank", new BoundingRectangle(70, 25, 18, 54));
        this.output = new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                OreProcessorTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.output, EnumDyeColor.ORANGE, "Processed ores output", 110, 25, 3, 3){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage(this.output, "outout");
    }

    private ItemStack getFirstStack() {
        for (int i = 0; i < this.input.getSlots(); ++i) {
            if (this.input.getStackInSlot(i).func_190926_b()) continue;
            return this.input.getStackInSlot(i);
        }
        return ItemStack.field_190927_a;
    }

    protected float performWork() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return 0.0f;
        }
        ItemStack stack = this.getFirstStack();
        if (stack.func_190926_b()) {
            return 0.0f;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        int fortune = this.getFortuneLevel();
        NonNullList stacks = NonNullList.func_191196_a();
        block.getDrops(stacks, (IBlockAccess)this.field_145850_b, this.field_174879_c, block.func_176203_a(stack.func_77960_j()), fortune);
        boolean canInsert = true;
        for (ItemStack temp : stacks) {
            if (ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)temp, (boolean)true).func_190926_b()) continue;
            canInsert = false;
            break;
        }
        if (canInsert) {
            for (ItemStack temp : stacks) {
                ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)temp, (boolean)false);
            }
            this.tank.drain(fortune * BlockRegistry.oreProcessorBlock.getEssenceFortune(), true);
            stack.func_190920_e(stack.func_190916_E() - 1);
            return 1.0f;
        }
        return 0.0f;
    }

    private int getFortuneLevel() {
        for (int i = 3; i > 0; --i) {
            if (i * BlockRegistry.oreProcessorBlock.getEssenceFortune() > this.tank.getFluidAmount()) continue;
            return i;
        }
        return 0;
    }
}

