/*
 * Decompiled with CFR 0.152.
 */
package codechicken.asm.transformers;

import codechicken.asm.ASMBlock;
import codechicken.asm.ASMHelper;
import codechicken.asm.ModularASMTransformer;
import codechicken.asm.ObfMapping;
import codechicken.asm.transformers.ClassNodeTransformer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class MethodWriter
extends ClassNodeTransformer {
    public final int access;
    public final ObfMapping method;
    public final String[] exceptions;
    public InsnList list;

    public MethodWriter(int access, @Nonnull ObfMapping method) {
        this(access, method, null, (InsnList)null);
    }

    public MethodWriter(int access, @Nonnull ObfMapping method, @Nullable InsnList list) {
        this(access, method, null, list);
    }

    public MethodWriter(int access, @Nonnull ObfMapping method, @Nonnull ASMBlock block) {
        this(access, method, null, block);
    }

    public MethodWriter(int access, @Nonnull ObfMapping method, @Nullable String[] exceptions) {
        this(access, method, exceptions, (InsnList)null);
    }

    public MethodWriter(int access, @Nonnull ObfMapping method, @Nullable String[] exceptions, @Nullable InsnList list) {
        this.access = access;
        this.method = method.toClassloading();
        this.exceptions = exceptions;
        this.list = list;
    }

    public MethodWriter(int access, @Nonnull ObfMapping method, @Nullable String[] exceptions, @Nonnull ASMBlock block) {
        this(access, method, exceptions, block.rawListCopy());
    }

    @Override
    public String className() {
        return this.method.javaClass();
    }

    @Override
    public void transform(ClassNode cnode) {
        MethodNode mv = ASMHelper.findMethod(this.method, cnode);
        if (mv == null) {
            mv = (MethodNode)this.method.visitMethod((ClassVisitor)cnode, this.access, this.exceptions);
        } else {
            mv.access = this.access;
            mv.instructions.clear();
            if (mv.localVariables != null) {
                mv.localVariables.clear();
            }
            if (mv.tryCatchBlocks != null) {
                mv.tryCatchBlocks.clear();
            }
        }
        this.write(mv);
    }

    public void write(MethodNode mv) {
        ModularASMTransformer.log("Writing method " + this.method);
        this.list.accept((MethodVisitor)mv);
    }
}

