/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget;

import com.github.atomicblom.weirdinggadget.Settings;
import com.github.atomicblom.weirdinggadget.TicketUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkManagerCallback
implements ForgeChunkManager.PlayerOrderedLoadingCallback {
    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            NBTTagCompound modData = ticket.getModData();
            if (!modData.func_74764_b("blockPosition")) continue;
            TicketUtils.activateTicket(world, ticket);
        }
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        ArrayListMultimap returnedTickets = ArrayListMultimap.create();
        if (Settings.emergencyMode) {
            return returnedTickets;
        }
        for (Map.Entry playerTicketMap : tickets.asMap().entrySet()) {
            String player = (String)playerTicketMap.getKey();
            for (ForgeChunkManager.Ticket ticket : (Collection)playerTicketMap.getValue()) {
                if (!TicketUtils.isTicketValid((IBlockAccess)world, ticket)) continue;
                returnedTickets.put((Object)player, (Object)ticket);
            }
        }
        return returnedTickets;
    }
}

