/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.block;

import com.github.atomicblom.weirdinggadget.Logger;
import com.github.atomicblom.weirdinggadget.Settings;
import com.github.atomicblom.weirdinggadget.TicketUtils;
import com.github.atomicblom.weirdinggadget.WeirdingGadgetMod;
import com.github.atomicblom.weirdinggadget.block.tileentity.WeirdingGadgetTileEntity;
import com.github.atomicblom.weirdinggadget.client.opengex.OpenGEXAnimationFrameProperty;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class WeirdingGadgetBlock
extends Block {
    public static final PropertyBool RENDER_DYNAMIC = PropertyBool.func_177716_a((String)"render_dynamic");

    public WeirdingGadgetBlock() {
        super(Material.field_151576_e, MapColor.field_151673_t);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)RENDER_DYNAMIC, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{RENDER_DYNAMIC}, new IUnlistedProperty[]{OpenGEXAnimationFrameProperty.instance});
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"tile.weirdinggadget:weirding_gadget.tooltip", (Object[])new Object[0]));
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!(placer instanceof EntityPlayer)) {
            return;
        }
        WeirdingGadgetBlock.activateChunkLoader(worldIn, pos, (EntityPlayer)placer);
    }

    private static void activateChunkLoader(World worldIn, BlockPos pos, EntityPlayer placer) {
        if (worldIn == null) {
            Logger.severe("While attempting to active a Weirding Gadget, Somehow, the world was null?", new Object[0]);
            return;
        }
        if (placer == null) {
            Logger.severe("While attempting to active a Weirding Gadget, Somehow, the player was null?", new Object[0]);
            return;
        }
        if (placer.func_70005_c_() == null) {
            Logger.severe("While attempting to active a Weirding Gadget, Somehow, the player's NAME was null?", new Object[0]);
            return;
        }
        if (WeirdingGadgetMod.INSTANCE == null) {
            Logger.severe("While attempting to active a Weirding Gadget, Somehow, MOD INSTANCE was null!?", new Object[0]);
            return;
        }
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestPlayerTicket((Object)WeirdingGadgetMod.INSTANCE, (String)placer.func_70005_c_(), (World)worldIn, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket == null) {
            return;
        }
        NBTTagCompound modData = ticket.getModData();
        modData.func_74782_a("blockPosition", (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        modData.func_74768_a("size", Settings.chunkLoaderWidth);
        TicketUtils.activateTicket(worldIn, ticket);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        WeirdingGadgetTileEntity tileEntity = (WeirdingGadgetTileEntity)worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        if (tileEntity.isExpired() || !tileEntity.hasTicket(playerIn)) {
            WeirdingGadgetBlock.activateChunkLoader(worldIn, pos, playerIn);
            return true;
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new WeirdingGadgetTileEntity();
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 5;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        WeirdingGadgetTileEntity tileEntity = (WeirdingGadgetTileEntity)worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            return;
        }
        tileEntity.expireAllTickets();
        super.func_180663_b(worldIn, pos, state);
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float onePixel = 0.0625f;
        return new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
    }

    @Deprecated
    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        WeirdingGadgetTileEntity tileEntity = (WeirdingGadgetTileEntity)worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        tileEntity.func_145842_c(id, param);
        return true;
    }
}

