/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.block.tileentity;

import com.github.atomicblom.weirdinggadget.Logger;
import com.github.atomicblom.weirdinggadget.Settings;
import com.github.atomicblom.weirdinggadget.TicketUtils;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.ForgeChunkManager;

public class WeirdingGadgetTileEntity
extends TileEntity
implements ITickable {
    private static final int ACTIVE_STATE_CHANGED = 1;
    @Nonnull
    private final List<ForgeChunkManager.Ticket> tickets = Lists.newArrayList();
    @Nonnull
    private final List<WeakReference<EntityPlayer>> trackedPlayers = new LinkedList<WeakReference<EntityPlayer>>();
    private long expireTime = -1L;
    private boolean isActive;

    public void setTicket(@Nonnull ForgeChunkManager.Ticket ticket) {
        String playerName = ticket.getPlayerName();
        Iterator<ForgeChunkManager.Ticket> iterator = this.tickets.iterator();
        while (iterator.hasNext()) {
            ForgeChunkManager.Ticket next = iterator.next();
            if (next.getPlayerName() != playerName) continue;
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)next);
            iterator.remove();
        }
        this.tickets.add(ticket);
        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 1);
        this.expireTime = -1L;
        Logger.info("Waking up Chunk Loader at %s because %s placed/interacted with it", this.field_174879_c, playerName);
    }

    public void addTrackedPlayer(@Nullable EntityPlayer player) {
        for (WeakReference<EntityPlayer> trackedPlayerReference : this.trackedPlayers) {
            EntityPlayer trackedPlayer = (EntityPlayer)trackedPlayerReference.get();
            if (trackedPlayer == null || player == null || player.func_70005_c_() != trackedPlayer.func_70005_c_()) continue;
            return;
        }
        this.trackedPlayers.add(new WeakReference<EntityPlayer>(player));
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tickets.isEmpty()) {
            return;
        }
        long totalWorldTime = this.field_145850_b.func_82737_E();
        if ((totalWorldTime & 0x1FL) != 31L) {
            return;
        }
        boolean noTrackedPlayers = true;
        Iterator<WeakReference<EntityPlayer>> trackedPlayerIterator = this.trackedPlayers.iterator();
        while (trackedPlayerIterator.hasNext()) {
            WeakReference<EntityPlayer> playerWeakReference = trackedPlayerIterator.next();
            Object player = (EntityPlayer)playerWeakReference.get();
            if (player == null) continue;
            player = TicketUtils.getOnlinePlayerByName(this.field_145850_b.func_73046_m(), player.func_70005_c_());
            if (player == null) {
                playerWeakReference.clear();
                trackedPlayerIterator.remove();
                continue;
            }
            noTrackedPlayers = false;
        }
        boolean ticketNeedsExpiring = noTrackedPlayers;
        if (noTrackedPlayers) {
            for (ForgeChunkManager.Ticket ticket : this.tickets) {
                EntityPlayerMP playerEntityByName = TicketUtils.getOnlinePlayerByName(this.field_145850_b.func_73046_m(), ticket.getPlayerName());
                if (playerEntityByName == null) continue;
                this.expireTime = -1L;
                this.trackedPlayers.add(new WeakReference<EntityPlayerMP>(playerEntityByName));
                Logger.info("Chunk Loader at %s is revived because %s returned", this.field_174879_c, playerEntityByName.func_70005_c_());
                this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 1);
                ticketNeedsExpiring = false;
            }
        }
        if (ticketNeedsExpiring && this.expireTime == -1L) {
            int timeout = Settings.hoursBeforeDeactivation * 72000;
            this.expireTime = totalWorldTime + (long)timeout;
            Logger.info("All players have gone offline. Ticket is scheduled to expire at world time %d", this.expireTime);
        }
        if (this.expireTime != -1L && totalWorldTime >= this.expireTime) {
            Logger.info("Ticket for Weirding Gadget at %s has expired.", this.field_174879_c);
            for (ForgeChunkManager.Ticket ticket : this.tickets) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
            this.tickets.clear();
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.expireTime = compound.func_74764_b("expireTime") ? compound.func_74763_f("expireTime") : -1L;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74772_a("expireTime", this.expireTime);
        return compound;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.isActive = type == 1;
            Logger.info("Active state of chunk loader at %s is now %b", this.field_174879_c, this.isActive);
            return true;
        }
        return false;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        updateTag.func_74757_a("isActive", this.isActive);
        return updateTag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.isActive = tag.func_74767_n("isActive");
        super.handleUpdateTag(tag);
    }

    public boolean isExpired() {
        return this.tickets.isEmpty();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean hasTicket(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        for (ForgeChunkManager.Ticket ticket : this.tickets) {
            if (ticket.getPlayerName() != player.func_70005_c_()) continue;
            return true;
        }
        return false;
    }

    public void expireAllTickets() {
        for (ForgeChunkManager.Ticket ticket : this.tickets) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
        this.tickets.clear();
        this.trackedPlayers.clear();
    }
}

