/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex.oddl;

import com.github.atomicblom.weirdinggadget.client.opengex.oddl.BaseStructure;
import java.lang.reflect.Array;

public enum PrimitiveType {
    Bool("bool", Boolean.TYPE),
    Int8("int8", Byte.TYPE),
    Int16("int16", Short.TYPE),
    Int32("int32", Integer.TYPE),
    Int64("int64", Long.TYPE),
    Uint8("unsigned_int8", Short.TYPE),
    Uint16("unsigned_int16", Integer.TYPE),
    Uint32("unsigned_int32", Long.TYPE),
    Uint64("unsigned_int64", Long.TYPE),
    Float("float", java.lang.Float.TYPE),
    Double("double", java.lang.Double.TYPE),
    String("string", String.class),
    Ref("ref", BaseStructure.class),
    Type("type", PrimitiveType.class);

    private String id;
    private Class javaType;

    private PrimitiveType(String id, Class type) {
        this.id = id;
        this.javaType = type;
    }

    public static PrimitiveType forId(String id) {
        for (PrimitiveType type : PrimitiveType.values()) {
            if (!type.id.equals(id)) continue;
            return type;
        }
        return null;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public String getId() {
        return this.id;
    }

    public String arrayToString(Object array) {
        StringBuilder sb = new StringBuilder();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object val = Array.get(array, i);
            if (val != null && val.getClass().isArray()) {
                val = this.arrayToString(val);
            }
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(val);
        }
        return "[" + sb + "]";
    }
}

