/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex.ogex;

import com.github.atomicblom.weirdinggadget.client.opengex.ogex.BaseMaterialized;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexAtten;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexColor;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTexture;
import java.util.ArrayList;
import java.util.List;

public class OgexLightObject
extends BaseMaterialized {
    private static String KEY_LIGHT = "light";
    private static String KEY_PROJECTION = "projection";
    private static String KEY_INTENSITY = "intensity";
    private Type type;
    private boolean shadow;
    private List<OgexAtten> attenFunctions = new ArrayList<OgexAtten>();

    public void setType(Type t) {
        this.type = t;
    }

    public Type getType() {
        return this.type;
    }

    public void setShadow(boolean b) {
        this.shadow = b;
    }

    public boolean getShadow() {
        return this.shadow;
    }

    public void setLightColor(OgexColor color) {
        this.setColor(KEY_LIGHT, color);
    }

    public OgexColor getLightColor() {
        return this.getColor(KEY_LIGHT, OgexColor.WHITE);
    }

    public void setProjectionTexture(OgexTexture t) {
        this.setTexture(KEY_PROJECTION, t);
    }

    public OgexTexture getProjectionTexture() {
        return this.getTexture(KEY_PROJECTION, null);
    }

    public void setIntensity(float f) {
        this.setParam(KEY_INTENSITY, Float.valueOf(f));
    }

    public float getIntensity() {
        return this.getParam(KEY_INTENSITY, 1.0f);
    }

    public void addAttenuationFunction(OgexAtten atten) {
        this.attenFunctions.add(atten);
    }

    public List<OgexAtten> getAttenuationFunctions() {
        return this.attenFunctions;
    }

    @Override
    protected void appendFieldStrings(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append("type=" + (Object)((Object)this.type));
        sb.append(", shadow=" + this.shadow);
        if (!this.attenFunctions.isEmpty()) {
            sb.append(", attenfuncs=" + this.attenFunctions);
        }
        super.appendFieldStrings(sb);
    }

    public static enum Type {
        Infinite("infinite"),
        Point("point"),
        Spot("spot");

        private String ogexName;

        private Type(String ogexName) {
            this.ogexName = ogexName;
        }

        public String getOgexName() {
            return this.ogexName;
        }

        public static Type lookup(String ogexName) {
            for (Type type : Type.values()) {
                if (!ogexName.equals(type.ogexName)) continue;
                return type;
            }
            return null;
        }
    }
}

