/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex.ogex;

import com.github.atomicblom.weirdinggadget.Logger;
import com.github.atomicblom.weirdinggadget.client.opengex.oddl.BaseStructure;
import com.github.atomicblom.weirdinggadget.client.opengex.oddl.DataStructure;
import com.github.atomicblom.weirdinggadget.client.opengex.oddl.OddlParser;
import com.github.atomicblom.weirdinggadget.client.opengex.oddl.PrimitiveStructure;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.Axis;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.Curve;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.IntArray;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.MeshType;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexAnimation;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexAtten;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexBoneNode;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexCameraNode;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexCameraObject;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexColor;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexGeometryNode;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexGeometryObject;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexIndexArray;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexKey;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexLightNode;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexLightObject;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexMaterial;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexMatrixTransform;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexMesh;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexNode;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexRotation;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexScale;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexScene;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexSkeleton;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexSkin;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTexture;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTime;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTrack;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTranslation;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexValue;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexVertexArray;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.VertexWinding;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OgexParser {
    static Logger log = Logger.INSTANCE;
    private static Set<String> BASE_NODE_CHILDREN = new HashSet<String>(Arrays.asList("Name", "Transform", "Rotation", "Scale", "Translation", "GeometryNode", "Node", "BoneNode", "Animation"));

    public static void main(String ... args) throws IOException {
        OgexParser parser = new OgexParser();
        for (String s : args) {
            FileReader in = new FileReader(s);
            long start = System.nanoTime();
            OgexScene scene = parser.parseScene(in);
            long end = System.nanoTime();
            System.out.println("Time:" + (double)(end - start) / 1.0E9 + " s  Read:");
            scene.dumpTree("");
        }
    }

    public OgexScene parseScene(Reader in) throws IOException {
        OgexScene result = new OgexScene();
        OddlParser oddl = new OddlParser(in);
        List<BaseStructure> list = oddl.parse();
        HashMap<BaseStructure, Object> index = new HashMap<BaseStructure, Object>();
        for (BaseStructure child : list) {
            if (!(child instanceof DataStructure)) {
                throw new IOException("Unknown OGEX structure found in root:" + child + ", from:" + child.location());
            }
            try {
                this.apply((DataStructure)child, result, index);
            }
            catch (Exception e) {
                throw new IOException("Error applying:" + child + ", from:" + child.location(), e);
            }
        }
        return result;
    }

    protected void apply(DataStructure ds, OgexScene result, Map<BaseStructure, Object> index) {
        String type = ds.getType();
        if ("Metric".equals(type)) {
            this.applyMetric(ds, result);
        } else if ("GeometryNode".equals(type)) {
            result.add(this.toGeometryNode(ds, index));
        } else if ("LightNode".equals(type)) {
            result.add(this.toLightNode(ds, index));
        } else if ("Node".equals(type)) {
            result.add(this.toNode(ds, index));
        } else if ("BoneNode".equals(type)) {
            result.add(this.toBoneNode(ds, index));
        } else if ("CameraNode".equals(type)) {
            result.add(this.toCameraNode(ds, index));
        } else if ("GeometryObject".equals(type)) {
            result.addGeometry(this.toGeometry(ds, index));
        } else if ("Material".equals(type)) {
            result.addMaterial(this.toMaterial(ds, index));
        } else if ("LightObject".equals(type)) {
            result.addLight(this.toLight(ds, index));
        } else if ("CameraObject".equals(type)) {
            result.addCamera(this.toCamera(ds, index));
        } else {
            Logger.warning("Unhandled structure type:" + type + ", from:" + ds.location(), new Object[0]);
        }
    }

    protected void configureNode(OgexNode node, DataStructure ds, Map<BaseStructure, Object> index, boolean strict) {
        for (BaseStructure child : ds) {
            String type = child.getType();
            if ("Name".equals(type)) {
                String name = (String)child.getValue();
                node.setName(name);
                continue;
            }
            if ("Transform".equals(type)) {
                node.addTransform(this.toTransform((DataStructure)child, index));
                continue;
            }
            if ("Rotation".equals(type)) {
                node.addTransform(this.toRotation((DataStructure)child, index));
                continue;
            }
            if ("Scale".equals(type)) {
                node.addTransform(this.toScale((DataStructure)child, index));
                continue;
            }
            if ("Translation".equals(type)) {
                node.addTransform(this.toTranslation((DataStructure)child, index));
                continue;
            }
            if ("GeometryNode".equals(type)) {
                node.add(this.toGeometryNode((DataStructure)child, index));
                continue;
            }
            if ("LightNode".equals(type)) {
                node.add(this.toLightNode(ds, index));
                continue;
            }
            if ("CameraNode".equals(type)) {
                node.add(this.toCameraNode(ds, index));
                continue;
            }
            if ("Node".equals(type)) {
                node.add(this.toNode((DataStructure)child, index));
                continue;
            }
            if ("BoneNode".equals(type)) {
                node.add(this.toBoneNode((DataStructure)child, index));
                continue;
            }
            if ("Animation".equals(type)) {
                node.addAnimation(this.toAnimation((DataStructure)child, index));
                continue;
            }
            if (!strict) continue;
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
    }

    protected OgexNode toNode(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexNode result = new OgexNode();
        this.configureNode(result, ds, index, true);
        return result;
    }

    protected OgexGeometryNode toGeometryNode(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexGeometryNode geom = new OgexGeometryNode();
        this.configureNode(geom, ds, index, false);
        if ("false".equals(ds.getProperty("visible"))) {
            geom.setVisible(false);
        }
        if ("false".equals(ds.getProperty("shadow"))) {
            geom.setShadow(false);
        }
        if ("false".equals(ds.getProperty("motionBlur"))) {
            geom.setMotionBlur(false);
        }
        for (BaseStructure child : ds) {
            String type = child.getType();
            if (BASE_NODE_CHILDREN.contains(type)) continue;
            if ("MaterialRef".equals(type)) {
                BaseStructure[] array;
                for (BaseStructure ref : array = (BaseStructure[])child.getData()) {
                    geom.addMaterial(this.toMaterial((DataStructure)ref, index));
                }
                continue;
            }
            if ("ObjectRef".equals(type)) {
                geom.setGeometry(this.toGeometry((DataStructure)child.getValue(), index));
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        return geom;
    }

    protected OgexLightNode toLightNode(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexLightNode result = new OgexLightNode();
        this.configureNode(result, ds, index, false);
        result.setShadow((Boolean)ds.getProperty("shadow"));
        OgexLightObject light = null;
        for (BaseStructure child : ds) {
            String type = child.getType();
            if (BASE_NODE_CHILDREN.contains(type)) continue;
            if ("ObjectRef".equals(type)) {
                if (light != null) {
                    throw new RuntimeException("Too many ObjectRef structures found in LightNode, from:" + child.location());
                }
                BaseStructure[] array = (BaseStructure[])child.getData();
                if (array.length != 1) {
                    throw new RuntimeException("Too many references (" + array.length + ") found in LightNode ObjectRef, from:" + child.location());
                }
                light = this.toLight((DataStructure)array[0], index);
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        result.setLight(light);
        return result;
    }

    protected OgexBoneNode toBoneNode(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexBoneNode result = (OgexBoneNode)index.get(ds);
        if (result != null) {
            return result;
        }
        result = new OgexBoneNode();
        index.put(ds, result);
        this.configureNode(result, ds, index, true);
        return result;
    }

    protected OgexCameraNode toCameraNode(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexCameraNode result = (OgexCameraNode)index.get(ds);
        if (result != null) {
            return result;
        }
        result = new OgexCameraNode();
        index.put(ds, result);
        this.configureNode(result, ds, index, false);
        OgexCameraObject camera = null;
        for (BaseStructure child : ds) {
            String type = child.getType();
            if (BASE_NODE_CHILDREN.contains(type)) continue;
            if ("ObjectRef".equals(type)) {
                if (camera != null) {
                    throw new RuntimeException("Too many ObjectRef structures found in CameraNode, from:" + child.location());
                }
                BaseStructure[] array = (BaseStructure[])child.getData();
                if (array.length != 1) {
                    throw new RuntimeException("Too many references (" + array.length + ") found in CameraNode ObjectRef, from:" + child.location());
                }
                camera = this.toCamera((DataStructure)array[0], index);
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        result.setCamera(camera);
        return result;
    }

    protected OgexTrack toTrack(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexTrack result = new OgexTrack();
        BaseStructure target = (BaseStructure)ds.getProperty("target");
        Object resolved = index.get(target);
        if (resolved == null) {
            throw new UnsupportedOperationException("Forward track targets not yet supported.");
        }
        result.setTarget(resolved);
        OgexTime time = null;
        OgexValue value = null;
        for (BaseStructure child : ds) {
            if ("Time".equals(child.getType())) {
                if (time != null) {
                    throw new RuntimeException("Only one Time structure is allowed in Track, from:" + ds.location());
                }
                time = this.toTime((DataStructure)child);
                continue;
            }
            if ("Value".equals(child.getType())) {
                if (value != null) {
                    throw new RuntimeException("Only one Value structure is allowed in Track, from:" + ds.location());
                }
                value = this.toValue((DataStructure)child);
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        if (time == null) {
            throw new RuntimeException("No Time structure found in Track, from:" + ds.location());
        }
        if (value == null) {
            throw new RuntimeException("No Value structure found in Track, from:" + ds.location());
        }
        result.setTime(time);
        result.setValue(value);
        return result;
    }

    protected OgexTime toTime(DataStructure ds) {
        OgexKey[] keys;
        OgexTime result = new OgexTime();
        String s = ds.getProperty("curve", "linear");
        Curve curve = Curve.lookup(s);
        result.setCurve(curve);
        switch (curve) {
            case Linear: {
                keys = new OgexKey[1];
                break;
            }
            case Bezier: {
                keys = new OgexKey[3];
                break;
            }
            default: {
                throw new RuntimeException("Unhandled curve type:" + (Object)((Object)curve) + ", from:" + ds.location());
            }
        }
        int index = 0;
        for (BaseStructure child : ds) {
            if ("Key".equals(child.getType())) {
                if (index >= keys.length) {
                    throw new RuntimeException("Too many Key structures found in Time, from:" + ds.location());
                }
                keys[index++] = this.toKey((DataStructure)child);
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        if (index < keys.length) {
            throw new RuntimeException("Missing Key structure for Time structure with curve:" + (Object)((Object)curve) + ", from:" + ds.location());
        }
        result.setKeys(keys);
        return result;
    }

    protected OgexKey toKey(DataStructure ds) {
        OgexKey key = new OgexKey();
        String s = ds.getProperty("kind", "value");
        OgexKey.Kind kind = OgexKey.Kind.lookup(s);
        key.setKind(kind);
        key.setData(ds.getData());
        return key;
    }

    protected OgexValue toValue(DataStructure ds) {
        OgexKey[] keys;
        OgexValue result = new OgexValue();
        String s = ds.getProperty("curve", "linear");
        Curve curve = Curve.lookup(s);
        result.setCurve(curve);
        switch (curve) {
            case Linear: {
                keys = new OgexKey[1];
                break;
            }
            case Bezier: {
                keys = new OgexKey[3];
                break;
            }
            case Tcb: {
                keys = new OgexKey[4];
                break;
            }
            default: {
                throw new RuntimeException("Unhandled curve type:" + (Object)((Object)curve) + ", from:" + ds.location());
            }
        }
        int index = 0;
        for (BaseStructure child : ds) {
            if ("Key".equals(child.getType())) {
                if (index >= keys.length) {
                    throw new RuntimeException("Too many Key structures found in Value, from:" + ds.location());
                }
                keys[index++] = this.toKey((DataStructure)child);
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        if (index < keys.length) {
            throw new RuntimeException("Missing Key structure for Value structure with curve:" + (Object)((Object)curve) + ", from:" + ds.location());
        }
        result.setKeys(keys);
        return result;
    }

    protected OgexAnimation toAnimation(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexAnimation result = new OgexAnimation();
        result.setClip(((Number)ds.getProperty("clip", 0)).intValue());
        result.setBegin(((Number)ds.getProperty("begin", Float.valueOf(0.0f))).floatValue());
        result.setEnd(((Number)ds.getProperty("end", Float.valueOf(0.0f))).floatValue());
        for (BaseStructure child : ds) {
            if ("Track".equals(child.getType())) {
                result.add(this.toTrack((DataStructure)child, index));
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        return result;
    }

    protected void applyMetric(DataStructure ds, OgexScene result) {
        String key = (String)ds.getProperty("key");
        Object value = ds.getValue();
        if ("distance".equals(key)) {
            result.getMetrics().setDistance(((Float)value).floatValue());
        } else if ("angle".equals(key)) {
            result.getMetrics().setAngle(((Float)value).floatValue());
        } else if ("time".equals(key)) {
            result.getMetrics().setTime(((Float)value).floatValue());
        } else if ("up".equals(key)) {
            Axis axis = Axis.valueOf(String.valueOf(value).toUpperCase());
            result.getMetrics().setUp(axis);
        } else {
            result.getMetrics().put(key, value);
        }
    }

    protected OgexGeometryObject toGeometry(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexGeometryObject result = (OgexGeometryObject)index.get(ds);
        if (result != null) {
            return result;
        }
        result = new OgexGeometryObject();
        index.put(ds, result);
        if ("false".equals(ds.getProperty("visible"))) {
            result.setVisible(false);
        }
        if ("false".equals(ds.getProperty("shadow"))) {
            result.setShadow(false);
        }
        if ("false".equals(ds.getProperty("motionBlur"))) {
            result.setMotionBlur(false);
        }
        for (BaseStructure child : ds) {
            if ("Mesh".equals(child.getType())) {
                result.addMesh(this.toMesh((DataStructure)child, index));
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        return result;
    }

    protected OgexCameraObject toCamera(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexCameraObject result = (OgexCameraObject)index.get(ds);
        if (result != null) {
            return result;
        }
        result = new OgexCameraObject();
        index.put(ds, result);
        for (BaseStructure child : ds) {
            String name;
            String type = child.getType();
            if ("Color".equals(type)) {
                name = (String)((DataStructure)child).getProperty("attrib");
                result.setColor(name, new OgexColor((float[])child.getValue()));
                continue;
            }
            if ("Texture".equals(type)) {
                name = (String)((DataStructure)child).getProperty("attrib");
                result.setTexture(name, this.toTexture((DataStructure)child, index));
                continue;
            }
            if ("Param".equals(type)) {
                name = (String)((DataStructure)child).getProperty("attrib");
                result.setParam(name, (Float)child.getValue());
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        return result;
    }

    protected OgexLightObject toLight(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexLightObject result = (OgexLightObject)index.get(ds);
        if (result != null) {
            return result;
        }
        result = new OgexLightObject();
        index.put(ds, result);
        String s = (String)ds.getProperty("type");
        if (s == null) {
            throw new RuntimeException("No type defined for LightObject, from:" + ds.location());
        }
        OgexLightObject.Type lightType = OgexLightObject.Type.lookup(s);
        result.setType(lightType);
        OgexColor color = null;
        OgexTexture texture = null;
        Float intensity = null;
        for (BaseStructure child : ds) {
            String name;
            String type = child.getType();
            if ("Color".equals(type)) {
                name = (String)((DataStructure)child).getProperty("attrib");
                if ("light".equals(name)) {
                    if (color != null) {
                        throw new RuntimeException("Too many 'light' Color structures found in LightObject, from:" + child.location());
                    }
                    color = new OgexColor((float[])child.getValue());
                    continue;
                }
                result.setColor(name, new OgexColor((float[])child.getValue()));
                continue;
            }
            if ("Texture".equals(type)) {
                name = (String)((DataStructure)child).getProperty("attrib");
                if ("projection".equals(name)) {
                    if (texture != null) {
                        throw new RuntimeException("Too many 'projection' Texture structures found in LightObject, from:" + child.location());
                    }
                    texture = this.toTexture((DataStructure)child, index);
                    continue;
                }
                result.setTexture(name, this.toTexture((DataStructure)child, index));
                continue;
            }
            if ("Param".equals(type)) {
                name = (String)((DataStructure)child).getProperty("attrib");
                if ("intensity".equals(name)) {
                    if (intensity != null) {
                        throw new RuntimeException("Too many 'intensity' Param structures found in LightObject, from:" + child.location());
                    }
                    intensity = (Float)child.getValue();
                    continue;
                }
                result.setParam(name, (Float)child.getValue());
                continue;
            }
            if ("Atten".equals(type)) {
                result.addAttenuationFunction(this.toAtten((DataStructure)child, index));
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        if (color != null) {
            result.setLightColor(color);
        }
        if (texture != null) {
            result.setProjectionTexture(texture);
        }
        if (intensity != null) {
            result.setIntensity(intensity.floatValue());
        }
        return result;
    }

    protected OgexAtten toAtten(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexAtten result = new OgexAtten();
        String s = ds.getProperty("kind", "distance");
        result.setKind(OgexAtten.Kind.lookup(s));
        s = ds.getProperty("curve", "linear");
        result.setCurve(Curve.lookup(s));
        for (BaseStructure child : ds) {
            if ("Param".equals(child.getType())) {
                String name = (String)((DataStructure)child).getProperty("attrib");
                result.setParam(name, (Float)child.getValue());
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        return result;
    }

    protected OgexSkin toSkin(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexSkin result = new OgexSkin();
        for (BaseStructure child : ds) {
            if ("Transform".equals(child.getType())) {
                result.setTransform(this.toTransform((DataStructure)child, index));
                continue;
            }
            if ("Skeleton".equals(child.getType())) {
                result.setSkeleton(this.toSkeleton((DataStructure)child, index));
                continue;
            }
            if ("BoneCountArray".equals(child.getType())) {
                result.setBoneCount(new IntArray(child.getData()));
                continue;
            }
            if ("BoneIndexArray".equals(child.getType())) {
                result.setBoneIndex(new IntArray(child.getData()));
                continue;
            }
            if ("BoneWeightArray".equals(child.getType())) {
                result.setBoneWeight((float[])child.getData());
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        return result;
    }

    protected OgexSkeleton toSkeleton(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexSkeleton result = new OgexSkeleton();
        for (BaseStructure child : ds) {
            Object array;
            if ("Transform".equals(child.getType())) {
                array = (float[][])child.getData();
                result.setTransforms((float[][])array);
                continue;
            }
            if ("BoneRefArray".equals(child.getType())) {
                array = (BaseStructure[])child.getData();
                OgexNode[] boneNodes = new OgexNode[((float[][])array).length];
                for (int i = 0; i < ((float[][])array).length; ++i) {
                    boneNodes[i] = !"BoneNode".equals(array[i].getType()) ? this.toNode((DataStructure)array[i], index) : this.toBoneNode((DataStructure)array[i], index);
                }
                result.setBoneNodes(boneNodes);
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        return result;
    }

    protected OgexMesh toMesh(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexMesh result = new OgexMesh();
        result.setType(this.toType((String)ds.getProperty("primitive")));
        long lod = ((Number)ds.getProperty("lod", 0L)).longValue();
        result.setLod(lod);
        for (BaseStructure child : ds) {
            if ("VertexArray".equals(child.getType())) {
                result.addVertexArray(this.toVertexArray((DataStructure)child));
                continue;
            }
            if ("IndexArray".equals(child.getType())) {
                result.addIndexArray(this.toIndexArray((DataStructure)child));
                continue;
            }
            if ("Skin".equals(child.getType())) {
                result.setSkin(this.toSkin((DataStructure)child, index));
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        return result;
    }

    protected OgexIndexArray toIndexArray(DataStructure ds) {
        VertexWinding winding;
        OgexIndexArray result = new OgexIndexArray();
        result.setMaterial(((Number)ds.getProperty("material", 0L)).longValue());
        result.setRestart(((Number)ds.getProperty("restart", 0L)).longValue());
        String front = ds.getProperty("front", "ccw");
        VertexWinding vertexWinding = winding = "ccw".equals(front) ? VertexWinding.CounterClockwise : VertexWinding.Clockwise;
        if ("ccw".equals(front)) {
            winding = VertexWinding.CounterClockwise;
        } else if ("cw".equals(front)) {
            winding = VertexWinding.Clockwise;
        } else {
            throw new RuntimeException("Invalude value for front:" + front);
        }
        result.setFront(winding);
        PrimitiveStructure struct = ds.getPrimitiveChild(true);
        result.setArray(struct.getData(), struct.getPrimitiveType(), struct.getElementSize());
        return result;
    }

    protected OgexVertexArray toVertexArray(DataStructure ds) {
        OgexVertexArray result = new OgexVertexArray();
        String name = (String)ds.getProperty("attrib");
        if (name == null) {
            throw new RuntimeException("VertexArray has no 'attrib' property");
        }
        result.setName(name);
        result.setMorph(ds.getProperty("morph", 0).intValue());
        PrimitiveStructure struct = ds.getPrimitiveChild(true);
        if (struct.getElementSize() > 1) {
            result.setArray((float[][])struct.getData(), struct.getElementSize());
        } else {
            result.setArray((float[])struct.getData());
        }
        return result;
    }

    protected MeshType toType(String s) {
        if (s == null) {
            return MeshType.Triangles;
        }
        MeshType result = MeshType.lookup(s);
        if (result == null) {
            throw new RuntimeException("Unknown mesh type:" + s);
        }
        return result;
    }

    protected OgexMatrixTransform toTransform(DataStructure ds, Map<BaseStructure, Object> index) {
        float[][] array;
        OgexMatrixTransform result = (OgexMatrixTransform)index.get(ds);
        if (result != null) {
            return result;
        }
        result = new OgexMatrixTransform();
        index.put(ds, result);
        Object object = ds.getProperty("object");
        if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
            result.setObjectOnly(true);
        }
        if ((array = (float[][])ds.getData()).length != 1) {
            throw new RuntimeException("Unexpected outer array length:" + array.length + ", from:" + ds.location());
        }
        result.setMatrix(array[0]);
        return result;
    }

    protected OgexRotation toRotation(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexRotation result = (OgexRotation)index.get(ds);
        if (result != null) {
            return result;
        }
        if (ds.getChildren().isEmpty()) {
            throw new RuntimeException("Missing data in Rotation, from:" + ds.location());
        }
        if (ds.getChildren().size() > 1) {
            throw new RuntimeException("Too many children in Rotation structure, from:" + ds.location());
        }
        String s = ds.getProperty("kind", "axis");
        OgexRotation.Kind kind = OgexRotation.Kind.lookup(s);
        Object value = ds.getValue();
        result = OgexRotation.create(kind, value);
        if ("true".equals(ds.getProperty("object"))) {
            result.setObjectOnly(true);
        }
        index.put(ds, result);
        return result;
    }

    protected OgexScale toScale(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexScale result = (OgexScale)index.get(ds);
        if (result != null) {
            return result;
        }
        if (ds.getChildren().isEmpty()) {
            throw new RuntimeException("Missing data in Scale, from:" + ds.location());
        }
        if (ds.getChildren().size() > 1) {
            throw new RuntimeException("Too many children in Scale structure, from:" + ds.location());
        }
        String s = ds.getProperty("kind", "xyz");
        OgexScale.Kind kind = OgexScale.Kind.lookup(s);
        Object value = ds.getValue();
        result = OgexScale.create(kind, value);
        if ("true".equals(ds.getProperty("object"))) {
            result.setObjectOnly(true);
        }
        index.put(ds, result);
        return result;
    }

    protected OgexTranslation toTranslation(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexTranslation result = (OgexTranslation)index.get(ds);
        if (result != null) {
            return result;
        }
        if (ds.getChildren().isEmpty()) {
            throw new RuntimeException("Missing data in Translation, from:" + ds.location());
        }
        if (ds.getChildren().size() > 1) {
            throw new RuntimeException("Too many children in Translation structure, from:" + ds.location());
        }
        String s = ds.getProperty("kind", "xyz");
        OgexTranslation.Kind kind = OgexTranslation.Kind.lookup(s);
        Object value = ds.getValue();
        result = OgexTranslation.create(kind, value);
        if ("true".equals(ds.getProperty("object"))) {
            result.setObjectOnly(true);
        }
        index.put(ds, result);
        return result;
    }

    protected OgexTexture toTexture(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexTexture result = new OgexTexture();
        result.setTexCoord(((Number)ds.getProperty("texCoord", 0L)).longValue());
        for (BaseStructure child : ds) {
            if (child instanceof PrimitiveStructure) {
                String texture = (String)child.getValue();
                result.setTexture(texture);
                continue;
            }
            if ("Transform".equals(child.getType())) {
                result.addTransform(this.toTransform((DataStructure)child, index));
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        return result;
    }

    protected OgexMaterial toMaterial(DataStructure ds, Map<BaseStructure, Object> index) {
        OgexMaterial result = (OgexMaterial)index.get(ds);
        if (result != null) {
            return result;
        }
        result = new OgexMaterial();
        index.put(ds, result);
        if ("true".equals(ds.getProperty("two_sided"))) {
            result.setTwoSided(true);
        }
        for (BaseStructure child : ds) {
            String name;
            String type = child.getType();
            if ("Name".equals(type)) {
                result.setName((String)child.getValue());
                continue;
            }
            if ("Color".equals(type)) {
                name = (String)((DataStructure)child).getProperty("attrib");
                result.setColor(name, new OgexColor((float[])child.getValue()));
                continue;
            }
            if ("Texture".equals(type)) {
                name = (String)((DataStructure)child).getProperty("attrib");
                result.setTexture(name, this.toTexture((DataStructure)child, index));
                continue;
            }
            if ("Param".equals(type)) {
                name = (String)((DataStructure)child).getProperty("attrib");
                result.setParam(name, (Float)child.getValue());
                continue;
            }
            Logger.warning("Unhandled structure type:" + child.getType() + ", from:" + child.location(), new Object[0]);
        }
        return result;
    }
}

