/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex.ogex;

import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexTransform;

public abstract class OgexScale
implements OgexTransform {
    private Kind kind;
    private boolean object;

    protected OgexScale(Kind kind) {
        this.kind = kind;
    }

    @Override
    public void setObjectOnly(boolean b) {
        this.object = b;
    }

    @Override
    public boolean isObjectOnly() {
        return this.object;
    }

    protected void setKind(Kind kind) {
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public static OgexScale create(Kind kind, Object data) {
        switch (kind) {
            case X: 
            case Y: 
            case Z: {
                return new ComponentScale(kind, ((Float)data).floatValue());
            }
            case Xyz: {
                return new XyzScale(kind, (float[])data);
            }
        }
        return null;
    }

    public static class XyzScale
    extends OgexScale {
        private float[] scale;

        public XyzScale(Kind kind, float[] data) {
            super(kind);
            this.scale = data;
        }

        @Override
        public void setKind(Kind kind) {
            if (kind != Kind.Xyz) {
                throw new IllegalArgumentException("Incompatible Xyz kind:" + (Object)((Object)kind));
            }
        }

        public void setScale(float[] scale) {
            if (scale.length != 3) {
                throw new IllegalArgumentException("Scale array must be length 3, found:" + scale.length);
            }
            this.scale = scale;
        }

        public float[] getScale() {
            return this.scale;
        }

        @Override
        public float[] toMatrix() {
            float x = this.scale[0];
            float y = this.scale[1];
            float z = this.scale[2];
            return new float[]{x, 0.0f, 0.0f, 0.0f, 0.0f, y, 0.0f, 0.0f, 0.0f, 0.0f, z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[kind=" + (Object)((Object)this.getKind()) + ", scale=[" + this.scale[0] + ", " + this.scale[1] + ", " + this.scale[2] + "]]";
        }
    }

    public static class ComponentScale
    extends OgexScale {
        private float scale;

        public ComponentScale(Kind kind, float scale) {
            super(kind);
            this.scale = scale;
        }

        @Override
        public void setKind(Kind kind) {
            switch (kind) {
                case X: 
                case Y: 
                case Z: {
                    super.setKind(kind);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incompatible ComponentScale kind:" + (Object)((Object)kind));
                }
            }
        }

        public void setScale(float scale) {
            this.scale = scale;
        }

        public float getScale() {
            return this.scale;
        }

        @Override
        public float[] toMatrix() {
            float x = 1.0f;
            float y = 1.0f;
            float z = 1.0f;
            switch (this.getKind()) {
                case X: {
                    x = this.scale;
                    break;
                }
                case Y: {
                    y = this.scale;
                    break;
                }
                case Z: {
                    z = this.scale;
                }
            }
            return new float[]{x, 0.0f, 0.0f, 0.0f, 0.0f, y, 0.0f, 0.0f, 0.0f, 0.0f, z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[kind=" + (Object)((Object)this.getKind()) + ", scale=" + this.scale + "]";
        }
    }

    public static enum Kind {
        X("x"),
        Y("y"),
        Z("z"),
        Xyz("xyz");

        private String ogexName;

        private Kind(String ogexName) {
            this.ogexName = ogexName;
        }

        public String getOgexName() {
            return this.ogexName;
        }

        public static Kind lookup(String ogexName) {
            for (Kind kind : Kind.values()) {
                if (!ogexName.equals(kind.ogexName)) continue;
                return kind;
            }
            return null;
        }
    }
}

