/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.container;

import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.item.ItemLittleRecipeAdvanced;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import team.creative.littleframes.common.structure.LittleFrame;
import team.creative.littleframes.common.structure.LittleFrameBuilder;

public class SubContainerBuilder
extends SubContainer {
    public LittleFrameBuilder builder;

    public SubContainerBuilder(EntityPlayer player, LittleFrameBuilder builder) {
        super(player);
        this.builder = builder;
    }

    public void createControls() {
        this.addSlotToContainer(new Slot((IInventory)this.builder.inventory, 0, 152, 61));
        this.addPlayerSlotsToContainer(this.player);
    }

    public void onPacketReceive(NBTTagCompound nbt) {
        if (this.player.func_184812_l_() && this.builder.inventory.func_70301_a(0).func_190926_b() || ItemLittleRecipeAdvanced.isRecipe((Item)this.builder.inventory.func_70301_a(0).func_77973_b())) {
            IBlockState state;
            int width = nbt.func_74762_e("width");
            int height = nbt.func_74762_e("height");
            int thickness = nbt.func_74762_e("thickness");
            String[] parts = nbt.func_74779_i("block").split(":");
            Block block = Block.func_149684_b((String)(parts[0] + ":" + parts[1]));
            int meta = parts.length == 3 ? Integer.parseInt(parts[2]) : 0;
            this.builder.lastBlockState = state = block.func_176203_a(meta);
            this.builder.lastSizeX = width;
            this.builder.lastSizeY = height;
            this.builder.lastThickness = thickness;
            this.builder.updateStructure();
            NBTTagCompound structureNBT = new NBTTagCompound();
            LittleStructureType type = LittleStructureRegistry.getStructureType(LittleFrame.class);
            LittleGridContext context = LittleGridContext.get();
            structureNBT.func_74778_a("id", type.id);
            structureNBT.func_74783_a("topRight", new int[]{Float.floatToIntBits(0.0f), Float.floatToIntBits(1.0f), Float.floatToIntBits(1.0f)});
            structureNBT.func_74783_a("frame", new int[]{thickness, 0, 0, thickness + 1, height, width, context.size});
            LittlePreviews previews = new LittlePreviews(structureNBT, context);
            NBTTagCompound tileData = new NBTTagCompound();
            tileData.func_74778_a("block", nbt.func_74779_i("block"));
            for (int x = 0; x < thickness; x += context.size) {
                for (int y = 0; y < height; y += context.size) {
                    for (int z = 0; z < width; z += context.size) {
                        previews.addWithoutCheckingPreview(new LittlePreview(new LittleBox(x, y, z, Math.min(x + 16, thickness), Math.min(y + 16, height), Math.min(z + 16, width)), tileData));
                    }
                }
            }
            ItemStack stack = this.builder.inventory.func_70301_a(0);
            if (stack.func_190926_b()) {
                stack = new ItemStack(LittleTiles.recipeAdvanced);
                this.builder.inventory.func_70299_a(0, stack);
            }
            LittlePreview.savePreview((LittlePreviews)previews, (ItemStack)stack);
        }
    }
}

