/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.structure;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.VectorUtils;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.creativecore.common.utils.math.box.BoxCorner;
import com.creativemd.creativecore.common.utils.math.box.BoxFace;
import com.creativemd.littletiles.client.gui.handler.LittleStructureGuiHandler;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.directional.StructureDirectional;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.client.texture.TextureCache;
import team.creative.littleframes.common.packet.LittleFramePacket;

public class LittleFrame
extends LittleStructure {
    @StructureDirectional(color=0xFF0001)
    public StructureRelative frame;
    @StructureDirectional
    public EnumFacing facing;
    @StructureDirectional
    public Vector3f topRight;
    private String url = "";
    public float brightness = 1.0f;
    public float alpha = 1.0f;
    public int renderDistance = 64;
    public FitMode fitMode = FitMode.CROP;
    public float volume = 1.0f;
    public boolean loop = true;
    public int tick = 0;
    public boolean playing = true;
    @SideOnly(value=Side.CLIENT)
    public TextureCache cache;
    @SideOnly(value=Side.CLIENT)
    public FrameDisplay display;

    @SideOnly(value=Side.CLIENT)
    public boolean isURLEmpty() {
        return this.url.isEmpty();
    }

    public static String getUrl(String url) {
        String result = url.replace("$(name)", Minecraft.func_71410_x().field_71439_g.getDisplayNameString()).replace("$(uuid)", Minecraft.func_71410_x().field_71439_g.func_189512_bd());
        if (result.startsWith("minecraft://")) {
            result = result.replace("minecraft://", "file:///" + Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("\\", "/") + "/");
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public String getURL() {
        return LittleFrame.getUrl(this.url);
    }

    public String getRealURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    @SideOnly(value=Side.CLIENT)
    public FrameDisplay requestDisplay() {
        String url = this.getURL();
        if (this.cache == null || !this.cache.url.equals(url)) {
            this.cache = TextureCache.get(url);
            if (this.display != null) {
                this.display.release();
            }
            this.display = null;
        }
        if (this.display != null) {
            return this.display;
        }
        if (this.cache.ready()) {
            this.display = this.cache.createDisplay(url, this.volume, this.loop);
            return this.display;
        }
        return null;
    }

    public LittleFrame(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    public void play() {
        this.playing = true;
        PacketHandler.sendPacketToTrackingPlayers((CreativeCorePacket)new LittleFramePacket(this.getStructureLocation(), this.playing, this.tick), (World)this.getWorld(), (BlockPos)this.getPos(), null);
    }

    public void pause() {
        this.playing = false;
        PacketHandler.sendPacketToTrackingPlayers((CreativeCorePacket)new LittleFramePacket(this.getStructureLocation(), this.playing, this.tick), (World)this.getWorld(), (BlockPos)this.getPos(), null);
    }

    public void stop() {
        this.playing = false;
        this.tick = 0;
        PacketHandler.sendPacketToTrackingPlayers((CreativeCorePacket)new LittleFramePacket(this.getStructureLocation(), this.playing, this.tick), (World)this.getWorld(), (BlockPos)this.getPos(), null);
    }

    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.url = nbt.func_74779_i("url");
        this.renderDistance = nbt.func_74764_b("render") ? nbt.func_74762_e("render") : 64;
        this.alpha = nbt.func_74764_b("alpha") ? nbt.func_74760_g("alpha") : 1.0f;
        this.brightness = nbt.func_74764_b("brightness") ? nbt.func_74760_g("brightness") : 1.0f;
        this.volume = nbt.func_74760_g("volume");
        this.playing = nbt.func_74767_n("playing");
        this.tick = nbt.func_74762_e("tick");
        this.loop = nbt.func_74767_n("loop");
        this.fitMode = FitMode.values()[nbt.func_74762_e("fitMode")];
    }

    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74778_a("url", this.url);
        nbt.func_74768_a("render", this.renderDistance);
        nbt.func_74776_a("alpha", this.alpha);
        nbt.func_74776_a("brightness", this.brightness);
        nbt.func_74776_a("volume", this.volume);
        nbt.func_74757_a("playing", this.playing);
        nbt.func_74768_a("tick", this.tick);
        nbt.func_74757_a("loop", this.loop);
        nbt.func_74768_a("fitMode", this.fitMode.ordinal());
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        LittleStructureGuiHandler.openGui((String)"little_frame", (NBTTagCompound)new NBTTagCompound(), (EntityPlayer)playerIn, (LittleStructure)this);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTick(BlockPos pos, double x, double y, double z, float partialTickTime) {
        if (this.isURLEmpty() || this.alpha == 0.0f) {
            if (this.display != null) {
                this.display.release();
            }
            return;
        }
        FrameDisplay display = this.requestDisplay();
        if (display == null) {
            return;
        }
        display.prepare(this.getURL(), this.volume * Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER), this.playing, this.loop, this.tick);
        GlStateManager.func_179147_l();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)this.brightness, (float)this.brightness, (float)this.brightness, (float)this.alpha);
        int texture = display.texture();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179144_i((int)texture);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        AlignedBox box = this.frame.getBox().getCube(this.frame.getContext());
        BoxFace face = BoxFace.get((EnumFacing)this.facing);
        if (this.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            box.setMax(this.facing.func_176740_k(), box.getMin(this.facing.func_176740_k()) + 0.01f);
        } else {
            box.setMin(this.facing.func_176740_k(), box.getMax(this.facing.func_176740_k()) - 0.01f);
        }
        EnumFacing.Axis uAxis = face.getTexUAxis();
        EnumFacing.Axis vAxis = face.getTexVAxis();
        if (this.fitMode == FitMode.CROP) {
            float videoRatio;
            float height;
            float width = box.getSize(uAxis);
            float ratio = width / (height = box.getSize(vAxis));
            if (ratio > (videoRatio = (float)display.getWidth() / (float)display.getHeight())) {
                box.shrink(uAxis, width - height * videoRatio);
            } else if (ratio < videoRatio) {
                box.shrink(vAxis, height - width / videoRatio);
            }
        }
        GlStateManager.func_179091_B();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(9, DefaultVertexFormats.field_181707_g);
        for (BoxCorner corner : face.corners) {
            builder.func_181662_b((double)box.getValueOfFacing(corner.x), (double)box.getValueOfFacing(corner.y), (double)box.getValueOfFacing(corner.z)).func_187315_a(corner.isFacingPositive(uAxis) != VectorUtils.get((EnumFacing.Axis)uAxis, (Tuple3f)this.topRight) > 0.0f ? 1.0 : 0.0, corner.isFacingPositive(vAxis) != VectorUtils.get((EnumFacing.Axis)vAxis, (Tuple3f)this.topRight) > 0.0f ? 1.0 : 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return Math.pow(this.renderDistance, 2.0);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.frame.getBox().getBox(this.frame.getContext());
    }

    public void tick() {
        super.tick();
        if (this.playing) {
            ++this.tick;
        }
    }

    public void unload() {
        super.unload();
        if (this.getWorld().field_72995_K && this.display != null) {
            this.display.release();
        }
    }

    public static enum FitMode {
        CROP,
        STRETCH;

    }
}

