/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_equalizer_t;
import uk.co.caprica.vlcj.factory.BaseApi;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.base.Equalizer;

public final class EqualizerApi
extends BaseApi {
    private final List<Float> bands = this.cacheBands();
    private final List<String> presets = this.cachePresets();

    EqualizerApi(MediaPlayerFactory factory) {
        super(factory);
    }

    public final List<Float> bands() {
        return new ArrayList<Float>(this.bands);
    }

    public final List<String> presets() {
        return new ArrayList<String>(this.presets);
    }

    public final Equalizer newEqualizer() {
        return new Equalizer(LibVlc.libvlc_audio_equalizer_get_band_count());
    }

    public final Equalizer newEqualizer(String presetName) {
        int index = this.presets.indexOf(presetName);
        if (index != -1) {
            libvlc_equalizer_t presetEqualizer = LibVlc.libvlc_audio_equalizer_new_from_preset(index);
            if (presetEqualizer != null) {
                Equalizer equalizer = new Equalizer(LibVlc.libvlc_audio_equalizer_get_band_count());
                equalizer.setPreamp(LibVlc.libvlc_audio_equalizer_get_preamp(presetEqualizer));
                for (int i = 0; i < LibVlc.libvlc_audio_equalizer_get_band_count(); ++i) {
                    equalizer.setAmp(i, LibVlc.libvlc_audio_equalizer_get_amp_at_index(presetEqualizer, i));
                }
                LibVlc.libvlc_audio_equalizer_release(presetEqualizer);
                return equalizer;
            }
            return null;
        }
        throw new IllegalArgumentException("No such preset named '" + presetName + "'");
    }

    public final Map<String, Equalizer> allPresetEqualizers() {
        TreeMap<String, Equalizer> result = new TreeMap<String, Equalizer>();
        for (String preset : this.presets) {
            result.put(preset, this.newEqualizer(preset));
        }
        return result;
    }

    private List<Float> cacheBands() {
        int numBands = LibVlc.libvlc_audio_equalizer_get_band_count();
        ArrayList<Float> result = new ArrayList<Float>(numBands);
        for (int i = 0; i < numBands; ++i) {
            result.add(Float.valueOf(LibVlc.libvlc_audio_equalizer_get_band_frequency(i)));
        }
        return Collections.unmodifiableList(result);
    }

    private List<String> cachePresets() {
        int numPresets = LibVlc.libvlc_audio_equalizer_get_preset_count();
        ArrayList<String> result = new ArrayList<String>(numPresets);
        for (int i = 0; i < numPresets; ++i) {
            result.add(LibVlc.libvlc_audio_equalizer_get_preset_name(i));
        }
        return Collections.unmodifiableList(result);
    }
}

