/*
 * Decompiled with CFR 0.152.
 */
package net.elnounch.mc.biggerpacketsplz;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.elnounch.mc.biggerpacketsplz.Logger;
import net.elnounch.mc.utils.VersionFilteredReader;
import net.elnounch.mc.utils.VersionSeeker;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class BiggerPacketsPlzClassTransformer
implements IClassTransformer {
    private static final Logger log = new Logger("ClassTransformer");
    private static final String mcVersion;
    private static final Map<String, Map<String, Set<String>>> whereToPatch;
    private static final Map<Object, Object> valueTranslations;
    private static Set<BiConsumer<String, String[]>> statusChangesListeners;
    private static Set<String> patchedClasses;
    private static String currentStatus;

    public static void registerPatchedClass(String cl) {
        currentStatus = "Patches applied";
        log.debug("Class '{}' patched", cl);
        if (patchedClasses.add(cl)) {
            BiggerPacketsPlzClassTransformer.informListeners();
        }
    }

    public static Set<String> getPatchedClasses() {
        return patchedClasses;
    }

    public static void registerStatusListener(BiConsumer<String, String[]> listener) {
        statusChangesListeners.add(listener);
        BiggerPacketsPlzClassTransformer.informListeners();
    }

    private static void informListeners() {
        statusChangesListeners.forEach(fn -> fn.accept(currentStatus, patchedClasses.toArray(new String[0])));
    }

    public byte[] transform(String name, String transformedName, byte[] classBeingTransformed) {
        Map<String, Set<String>> found = whereToPatch.get(name);
        if (found != null) {
            log.info("Transforming class '{}', alias '{}'", name, transformedName);
            BiggerPacketsPlzClassTransformer.registerPatchedClass(name + ", alias '" + transformedName + "'");
            return this.transformFunctions(found, classBeingTransformed);
        }
        return classBeingTransformed;
    }

    public byte[] transformFunctions(final Map<String, Set<String>> functionsIDs, byte[] classBeingTransformed) {
        ClassReader cr = new ClassReader(classBeingTransformed);
        ClassWriter cw = new ClassWriter(cr, 0);
        cr.accept(new ClassVisitor(327680, (ClassVisitor)cw){

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object cst) {
                if (valueTranslations.containsKey(cst)) {
                    log.info("Patching field '{}' ({})", name, desc);
                    cst = valueTranslations.get(cst);
                }
                return super.visitField(access, name, desc, signature, cst);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                Set descriptions = (Set)functionsIDs.get(name);
                if (descriptions != null && descriptions.contains(desc)) {
                    log.info("Scanning method '{}{}'", name, desc);
                    return new MethodVisitor(327680, mv){

                        public void visitLdcInsn(Object cst) {
                            if (valueTranslations.containsKey(cst)) {
                                log.info("Patching constant ({}) {}", cst.getClass().getName(), cst.toString());
                                cst = valueTranslations.get(cst);
                            }
                            super.visitLdcInsn(cst);
                        }
                    };
                }
                return mv;
            }
        }, 0);
        return cw.toByteArray();
    }

    static {
        currentStatus = "Unknown";
        whereToPatch = new HashMap<String, Map<String, Set<String>>>();
        valueTranslations = new HashMap<Object, Object>();
        statusChangesListeners = new HashSet<BiConsumer<String, String[]>>();
        patchedClasses = new HashSet<String>();
        VersionSeeker versionSeeker = new VersionSeeker();
        log.debug("Looking for mcVersion", new Object[0]);
        String detectedMcVersion = "";
        try {
            ClassReader classReader = new ClassReader("net.minecraft.server.MinecraftServer");
            classReader.accept((ClassVisitor)versionSeeker, 0);
            if (versionSeeker.getVersionFound() != null) {
                detectedMcVersion = versionSeeker.getVersionFound();
                log.debug("Detected mcVersion '{}'", detectedMcVersion);
            }
        }
        catch (IOException e) {
            log.error("Exception while seeking for mcVersion", new Object[0]);
        }
        mcVersion = detectedMcVersion;
        if (mcVersion.equals("")) {
            log.error("Undetected Minecraft version", new Object[0]);
            currentStatus = "Error detecting Minecraft version";
        } else {
            Pattern splitter = Pattern.compile("^(?<classname>.+)\\.(?<methodname>.+)(?<methoddesc>\\(.*\\).+)$");
            VersionFilteredReader reader = new VersionFilteredReader(mcVersion, line -> {
                Matcher def = splitter.matcher((CharSequence)line);
                if (def.matches()) {
                    whereToPatch.computeIfAbsent(def.group("classname"), x -> new HashMap()).computeIfAbsent(def.group("methodname"), x -> new HashSet()).add(def.group("methoddesc"));
                } else {
                    log.error("Invalid patch definition : " + line + " (against '" + splitter + "')", new Object[0]);
                }
            });
            try {
                reader.ingest(BiggerPacketsPlzClassTransformer.class.getResource("definitions.txt"));
            }
            catch (IOException e) {
                log.error("Exception while reading patchs definitions", new Object[0]);
            }
        }
        log.debug("Will look after classes : {}", whereToPatch);
        currentStatus = whereToPatch.size() == 0 ? "Unsupported Minecraft version" : "No class patched yet. Connect client or launch server.";
        valueTranslations.put(0x200000L, 0x1000000L);
        valueTranslations.put(0x200000, 0x1000000);
        log.debug("Will look after values : {}", valueTranslations);
    }
}

