/*
 * Decompiled with CFR 0.152.
 */
package net.elnounch.mc.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.elnounch.mc.utils.Version;

public class VersionRange {
    private Version lowerBound;
    private Version higherBound;
    private boolean lowerBoundExclusive;
    private boolean higherBoundExclusive;
    private static Pattern pattern = Pattern.compile("^(?<lowerType>[(\\[])?\\s?(?<lower>\\d+(?:\\.\\d*)*)(?:\\s?,\\s?(?<higher>\\d+(?:\\.\\d*)*))?\\s?(?<higherType>[)\\]])?$");

    private VersionRange() {
    }

    public static VersionRange createFromVersionSpec(String str) {
        VersionRange ret = new VersionRange();
        Matcher data = pattern.matcher(str);
        if (data.matches()) {
            ret.lowerBound = new Version(data.group("lower"));
            ret.higherBound = data.group("higher") == null ? ret.lowerBound : new Version(data.group("higher"));
            ret.lowerBoundExclusive = "(".equals(data.group("lowerType"));
            ret.higherBoundExclusive = ")".equals(data.group("higherType"));
        }
        return ret;
    }

    public boolean isValid() {
        return this.lowerBound != null && this.higherBound != null;
    }

    public String toString() {
        if (!this.isValid()) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        if (this.lowerBoundExclusive) {
            ret.append("(");
        } else {
            ret.append("[");
        }
        ret.append(this.lowerBound);
        if (!this.lowerBound.isEqualTo(this.higherBound)) {
            ret.append(",");
            ret.append(this.higherBound);
        }
        if (this.higherBoundExclusive) {
            ret.append(")");
        } else {
            ret.append("]");
        }
        return ret.toString();
    }

    public boolean containsVersion(Version v) {
        if (!this.isValid()) {
            return false;
        }
        if (v.isLowerThan(this.lowerBound) || this.lowerBoundExclusive && v.isEqualTo(this.lowerBound)) {
            return false;
        }
        return !this.higherBound.isLowerThan(v) && (!this.higherBoundExclusive || !this.higherBound.isEqualTo(v));
    }
}

