/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.render;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MagicBellRenderer {
    private static MagicBellRenderer instance;
    private final Set<PositionInfo> highlightedPositions = new HashSet<PositionInfo>();
    private final Set<EntityInfo> highlightedEntities = new HashSet<EntityInfo>();
    private final ShaderGroup cqrOutlineShader;
    private final Framebuffer cqrOutlineFramebuffer;
    public static int outlineColor;

    public MagicBellRenderer() {
        Minecraft mc = Minecraft.func_71410_x();
        if (ShaderLinkHelper.func_148074_b() == null) {
            ShaderLinkHelper.func_148076_a();
        }
        ResourceLocation resourcelocation = new ResourceLocation("shaders/post/entity_outline.json");
        ShaderGroup shader = null;
        Framebuffer framebuffer = null;
        try {
            shader = new ShaderGroup(mc.func_110434_K(), mc.func_110442_L(), mc.func_147110_a(), resourcelocation);
            shader.func_148026_a(mc.field_71443_c, mc.field_71440_d);
            framebuffer = shader.func_177066_a("final");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cqrOutlineShader = shader;
        this.cqrOutlineFramebuffer = framebuffer;
    }

    public static MagicBellRenderer getInstance() {
        if (instance == null) {
            instance = new MagicBellRenderer();
        }
        return instance;
    }

    public void clear() {
        this.highlightedPositions.clear();
        this.highlightedEntities.clear();
    }

    public void add(int color, int lifetime, BlockPos pos) {
        Optional<PositionInfo> existing = this.highlightedPositions.stream().filter(posInfo -> posInfo.pos.equals((Object)pos)).findFirst();
        if (existing.isPresent()) {
            existing.get().lifetime = Math.max(existing.get().lifetime, lifetime);
        } else {
            this.highlightedPositions.add(new PositionInfo(color, lifetime, pos));
        }
    }

    public void add(int color, int lifetime, int entityId) {
        Optional<EntityInfo> existing = this.highlightedEntities.stream().filter(entityInfo -> entityInfo.entityId == entityId).findFirst();
        if (existing.isPresent()) {
            existing.get().lifetime = Math.max(existing.get().lifetime, lifetime);
        } else {
            this.highlightedEntities.add(new EntityInfo(color, lifetime, entityId));
        }
    }

    public void tick() {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        if (world == null) {
            this.clear();
            return;
        }
        Iterator<HighlightInfo> iterator = this.highlightedPositions.iterator();
        while (iterator.hasNext()) {
            PositionInfo positionInfo = iterator.next();
            if (positionInfo.lifetime-- > 0 && world.func_180495_p(positionInfo.pos).func_177230_c() != Blocks.field_150350_a) continue;
            iterator.remove();
        }
        iterator = this.highlightedEntities.iterator();
        while (iterator.hasNext()) {
            EntityInfo entityInfo = (EntityInfo)iterator.next();
            if (entityInfo.lifetime-- > 0 && world.func_73045_a(entityInfo.entityId) != null) continue;
            iterator.remove();
        }
    }

    public void render(float partialTicks) {
        if (this.highlightedPositions.isEmpty() && this.highlightedEntities.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        double x = mc.field_71439_g.field_70142_S + (mc.field_71439_g.field_70165_t - mc.field_71439_g.field_70142_S) * (double)partialTicks;
        double y = mc.field_71439_g.field_70137_T + (mc.field_71439_g.field_70163_u - mc.field_71439_g.field_70137_T) * (double)partialTicks;
        double z = mc.field_71439_g.field_70136_U + (mc.field_71439_g.field_70161_v - mc.field_71439_g.field_70136_U) * (double)partialTicks;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        this.cqrOutlineFramebuffer.func_147614_f();
        this.cqrOutlineFramebuffer.func_147610_a(false);
        GlStateManager.func_179143_c((int)519);
        buffer.func_178969_c(-x, -y, -z);
        this.highlightedPositions.forEach(arg_0 -> MagicBellRenderer.lambda$render$2((World)world, buffer, mc, tessellator, arg_0));
        buffer.func_178969_c(0.0, 0.0, 0.0);
        TileEntityRendererDispatcher.field_147556_a.preDrawBatch();
        this.highlightedPositions.forEach(arg_0 -> MagicBellRenderer.lambda$render$3((World)world, partialTicks, arg_0));
        TileEntityRendererDispatcher.field_147556_a.drawBatch(0);
        mc.func_175598_ae().func_178632_c(true);
        this.highlightedEntities.forEach(arg_0 -> MagicBellRenderer.lambda$render$4((World)world, mc, partialTicks, arg_0));
        mc.func_175598_ae().func_178632_c(false);
        this.cqrOutlineShader.func_148018_a(partialTicks);
        GlStateManager.func_179143_c((int)515);
        mc.func_147110_a().func_147610_a(false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)0, (int)1);
        this.cqrOutlineFramebuffer.func_178038_a(mc.field_71443_c, mc.field_71440_d, false);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179089_o();
        GlStateManager.func_179106_n();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179119_h();
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
    }

    private static /* synthetic */ void lambda$render$4(World world, Minecraft mc, float partialTicks, EntityInfo entityInfo) {
        Entity entity = world.func_73045_a(entityInfo.entityId);
        if (entity == null) {
            return;
        }
        outlineColor = entityInfo.color;
        mc.func_175598_ae().func_188388_a(entity, partialTicks, false);
        outlineColor = -1;
    }

    private static /* synthetic */ void lambda$render$3(World world, float partialTicks, PositionInfo posInfo) {
        TileEntity te = world.func_175625_s(posInfo.pos);
        if (te == null) {
            return;
        }
        GlStateManager.func_179142_g();
        GlStateManager.func_187431_e((int)posInfo.color);
        TileEntityRendererDispatcher.field_147556_a.func_180546_a(te, partialTicks, -1);
        GlStateManager.func_187417_n();
        GlStateManager.func_179119_h();
    }

    private static /* synthetic */ void lambda$render$2(World world, BufferBuilder buffer, Minecraft mc, Tessellator tessellator, PositionInfo posInfo) {
        IBlockState state = world.func_180495_p(posInfo.pos);
        if (state.func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        GlStateManager.func_179142_g();
        GlStateManager.func_187431_e((int)posInfo.color);
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        mc.func_175602_ab().func_175018_a(state, posInfo.pos, (IBlockAccess)mc.field_71441_e, buffer);
        tessellator.func_78381_a();
        GlStateManager.func_187417_n();
        GlStateManager.func_179119_h();
    }

    static {
        outlineColor = -1;
    }

    public static class EntityInfo
    extends HighlightInfo {
        public final int entityId;

        public EntityInfo(int color, int lifetime, int entityId) {
            super(color, lifetime);
            this.entityId = entityId;
        }

        public int hashCode() {
            return this.entityId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntityInfo)) {
                return false;
            }
            return this.entityId == ((EntityInfo)obj).entityId;
        }
    }

    public static class PositionInfo
    extends HighlightInfo {
        public final BlockPos pos;

        public PositionInfo(int color, int lifetime, BlockPos pos) {
            super(color, lifetime);
            this.pos = pos;
        }

        public int hashCode() {
            return this.pos.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PositionInfo)) {
                return false;
            }
            return this.pos.equals((Object)((PositionInfo)obj).pos);
        }
    }

    public static abstract class HighlightInfo {
        public final int color;
        public int lifetime;

        protected HighlightInfo(int color, int lifetime) {
            this.color = color;
            this.lifetime = lifetime;
        }
    }
}

