/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.render.texture;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class CubemapTexture
extends AbstractTexture {
    protected final ResourceLocation originalTexture;
    protected final ResourceLocation texture;

    public CubemapTexture(ResourceLocation originalTexture, ResourceLocation texture) {
        this.originalTexture = originalTexture;
        this.texture = texture;
    }

    public static ResourceLocation get(ResourceLocation originalTexture) {
        ResourceLocation texture = CubemapTexture.appendBeforeEnding(originalTexture, "_cubemap");
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        if (renderManager.field_78724_e.func_110581_b(texture) == null) {
            renderManager.field_78724_e.func_110579_a(texture, (ITextureObject)new CubemapTexture(originalTexture, texture));
        }
        return texture;
    }

    private static ResourceLocation appendBeforeEnding(ResourceLocation location, String suffix) {
        String path = location.func_110623_a();
        int i = path.lastIndexOf(46);
        return new ResourceLocation(location.func_110624_b(), path.substring(0, i) + suffix + path.substring(i));
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
        this.func_147631_c();
        GL11.glBindTexture((int)34067, (int)this.func_110552_b());
        GL11.glTexParameteri((int)34067, (int)10242, (int)33071);
        GL11.glTexParameteri((int)34067, (int)10243, (int)33071);
        GL11.glTexParameteri((int)34067, (int)32882, (int)33071);
        GL11.glTexParameteri((int)34067, (int)10240, (int)9728);
        GL11.glTexParameteri((int)34067, (int)10241, (int)9728);
        GL11.glTexParameteri((int)34067, (int)33084, (int)0);
        GL11.glTexParameteri((int)34067, (int)33085, (int)0);
        this.load(resourceManager, CubemapTexture.appendBeforeEnding(this.originalTexture, "_right"), 34069);
        this.load(resourceManager, CubemapTexture.appendBeforeEnding(this.originalTexture, "_left"), 34070);
        this.load(resourceManager, CubemapTexture.appendBeforeEnding(this.originalTexture, "_top"), 34071);
        this.load(resourceManager, CubemapTexture.appendBeforeEnding(this.originalTexture, "_bottom"), 34072);
        this.load(resourceManager, CubemapTexture.appendBeforeEnding(this.originalTexture, "_front"), 34073);
        this.load(resourceManager, CubemapTexture.appendBeforeEnding(this.originalTexture, "_back"), 34074);
    }

    private void load(IResourceManager resourceManager, ResourceLocation location, int target) throws IOException {
        try (IResource iresource = resourceManager.func_110536_a(location);){
            BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
            int w = bufferedimage.getWidth();
            int h = bufferedimage.getHeight();
            IntBuffer data = ByteBuffer.allocateDirect(w * h * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
            data.put(bufferedimage.getRGB(0, 0, w, h, new int[w * h], 0, w));
            data.flip();
            GL11.glTexImage2D((int)target, (int)0, (int)32856, (int)w, (int)h, (int)0, (int)32993, (int)5121, (IntBuffer)data);
        }
    }
}

