/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.render.texture;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.cqr.cqrepoured.util.Perlin2D;

public class InvisibilityTexture
extends AbstractTexture {
    private static final Random RANDOM = new Random();
    private static final Perlin2D PERLIN = new Perlin2D(RANDOM.nextLong(), 4.0f);
    private static final Logger LOGGER = LogManager.getLogger();
    protected final ResourceLocation originalTextureLocation;
    protected final ResourceLocation textureLocation;

    public InvisibilityTexture(ResourceLocation originalTextureLocation, ResourceLocation textureLocation) {
        this.originalTextureLocation = originalTextureLocation;
        this.textureLocation = textureLocation;
    }

    public static ResourceLocation get(ResourceLocation originalTexture) {
        String path = originalTexture.func_110623_a();
        int i = path.lastIndexOf(46);
        ResourceLocation invisibilityTexture = new ResourceLocation(originalTexture.func_110624_b(), path.substring(0, i) + "_invisible" + path.substring(i));
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        if (renderManager.field_78724_e.func_110581_b(invisibilityTexture) == null) {
            renderManager.field_78724_e.func_110579_a(invisibilityTexture, (ITextureObject)new InvisibilityTexture(originalTexture, invisibilityTexture));
        }
        return invisibilityTexture;
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
        this.func_147631_c();
        try (IResource iresource = resourceManager.func_110536_a(this.originalTextureLocation);){
            BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
            PERLIN.setup(RANDOM.nextLong(), 4.0f);
            for (int x = 0; x < bufferedimage.getWidth(); ++x) {
                for (int y = 0; y < bufferedimage.getHeight(); ++y) {
                    int argb = bufferedimage.getRGB(x, y);
                    if (argb >>> 24 <= 2) continue;
                    float f = PERLIN.getNoiseAt(x, y);
                    bufferedimage.setRGB(x, y, (int)(f * 255.0f) << 24 | argb & 0xFFFFFF);
                }
            }
            boolean flag = false;
            boolean flag1 = false;
            if (iresource.func_110528_c()) {
                try {
                    TextureMetadataSection texturemetadatasection = (TextureMetadataSection)iresource.func_110526_a("texture");
                    if (texturemetadatasection != null) {
                        flag = texturemetadatasection.func_110479_a();
                        flag1 = texturemetadatasection.func_110480_b();
                    }
                }
                catch (RuntimeException runtimeexception) {
                    LOGGER.warn("Failed reading metadata of: {}", (Object)this.originalTextureLocation, (Object)runtimeexception);
                }
            }
            TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)bufferedimage, (boolean)flag, (boolean)flag1);
        }
    }
}

