/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.customtextures;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import team.cqr.cqrepoured.customtextures.UniversalImageBuffer;

public class CTResourcepack
implements IResourcePack {
    private Set<ResourceLocation> VALID_TEXTURES = new HashSet<ResourceLocation>();
    private Map<ResourceLocation, File> FILES = new HashMap<ResourceLocation, File>();
    private Set<String> DOMAIN_SET = new HashSet<String>();
    private static CTResourcepack INSTANCE;

    public static CTResourcepack getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CTResourcepack();
        }
        return INSTANCE;
    }

    private CTResourcepack() {
    }

    public InputStream func_110590_a(ResourceLocation var1) throws IOException {
        File file = this.FILES.getOrDefault(var1, null);
        if (file != null) {
            return new FileInputStream(file);
        }
        return null;
    }

    public boolean func_110589_b(ResourceLocation var1) {
        return this.FILES.containsKey(var1);
    }

    public Set<String> func_110587_b() {
        return this.DOMAIN_SET;
    }

    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer var1, String var2) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    public String func_130077_b() {
        return "CQR-NPC-Textures";
    }

    public static void add(ResourceLocation resLoc, File file) {
        CTResourcepack.getInstance().addImpl(resLoc, file);
    }

    private void addImpl(ResourceLocation resLoc, File file) {
        try {
            this.VALID_TEXTURES.add(resLoc);
            this.DOMAIN_SET.add(resLoc.func_110624_b());
            this.FILES.put(resLoc, file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void remove(ResourceLocation texture) {
        CTResourcepack.getInstance().removeImpl(texture);
    }

    private void removeImpl(ResourceLocation texture) {
        this.VALID_TEXTURES.remove(texture);
        this.DOMAIN_SET.remove(texture.func_110624_b());
        this.FILES.remove(texture);
    }

    public static void clear() {
        CTResourcepack.getInstance().clearImpl();
    }

    private void clearImpl() {
        this.VALID_TEXTURES.clear();
        this.DOMAIN_SET.clear();
        this.FILES.clear();
    }

    public static void loadAllTextures() {
        CTResourcepack.getInstance().loadAllTexturesImpl();
    }

    private void loadAllTexturesImpl() {
        TextureManager tm = Minecraft.func_71410_x().func_110434_K();
        for (Map.Entry<ResourceLocation, File> entry : this.FILES.entrySet()) {
            if (entry.getKey().func_110623_a().endsWith(".mcmeta")) continue;
            ThreadDownloadImageData tex = new ThreadDownloadImageData(entry.getValue(), null, entry.getKey(), (IImageBuffer)new UniversalImageBuffer());
            try {
                tex.func_147641_a(ImageIO.read(entry.getValue()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            tm.func_110579_a(entry.getKey(), (ITextureObject)tex);
        }
    }
}

