/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.spells;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import team.cqr.cqrepoured.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.entity.ai.spells.IEntityAISpell;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;

public class EntityAISpellHandler
extends AbstractCQREntityAI<AbstractEntityCQR> {
    private static final Comparator<SpellEntry> SORTER = (spellEntry1, spellEntry2) -> {
        if (((SpellEntry)spellEntry1).priority < ((SpellEntry)spellEntry2).priority) {
            return -1;
        }
        if (((SpellEntry)spellEntry1).priority > ((SpellEntry)spellEntry2).priority) {
            return 1;
        }
        return 0;
    };
    private final List<SpellEntry> spells = new ArrayList<SpellEntry>();
    private final int cooldown;
    private IEntityAISpell activeSpell;
    private int prevTimeCasted;

    public EntityAISpellHandler(AbstractEntityCQR entity, int cooldown) {
        super(entity);
        this.cooldown = cooldown;
        this.func_75248_a(7);
    }

    public void addSpell(int priority, IEntityAISpell spell) {
        this.spells.add(new SpellEntry(priority, spell));
        if (this.spells.size() >= 2 && this.spells.get(this.spells.size() - 2).priority > priority) {
            this.spells.sort(SORTER);
        }
    }

    public boolean func_75250_a() {
        if (this.spells.isEmpty()) {
            return false;
        }
        if (this.prevTimeCasted + this.cooldown >= this.entity.field_70173_aa) {
            return false;
        }
        int sum = 0;
        ArrayList<IEntityAISpell> possibleSpells = new ArrayList<IEntityAISpell>();
        for (SpellEntry spellEntry : this.spells) {
            IEntityAISpell spell = spellEntry.spell;
            if (!spell.shouldExecute()) continue;
            if (spell.ignoreWeight()) {
                this.activeSpell = spell;
                return true;
            }
            if (spell.getWeight() <= 0) continue;
            sum += spell.getWeight();
            possibleSpells.add(spell);
        }
        if (possibleSpells.isEmpty()) {
            return false;
        }
        int i = this.random.nextInt(sum);
        for (IEntityAISpell spell : possibleSpells) {
            if ((i -= spell.getWeight()) >= 0) continue;
            this.activeSpell = spell;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.activeSpell.shouldContinueExecuting();
    }

    public boolean func_75252_g() {
        return this.activeSpell.isInterruptible();
    }

    public void func_75249_e() {
        this.activeSpell.startExecuting();
    }

    public void func_75251_c() {
        this.activeSpell.resetTask();
        this.activeSpell = null;
        this.prevTimeCasted = this.entity.field_70173_aa;
    }

    public void func_75246_d() {
        this.activeSpell.updateTask();
    }

    @Nullable
    public IEntityAISpell getActiveSpell() {
        return this.activeSpell;
    }

    public boolean isSpellCharging() {
        return this.activeSpell != null && this.activeSpell.isCharging();
    }

    public boolean isSpellCasting() {
        return this.activeSpell != null && this.activeSpell.isCasting();
    }

    private static class SpellEntry {
        private int priority;
        private IEntityAISpell spell;

        private SpellEntry(int priority, IEntityAISpell spell) {
            this.priority = priority;
            this.spell = spell;
        }
    }
}

