/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.bases;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemNameTag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.capability.extraitemhandler.CapabilityExtraItemHandler;
import team.cqr.cqrepoured.capability.extraitemhandler.CapabilityExtraItemHandlerProvider;
import team.cqr.cqrepoured.client.init.ESpeechBubble;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.customtextures.IHasTextureOverride;
import team.cqr.cqrepoured.entity.EntityEquipmentExtraSlot;
import team.cqr.cqrepoured.entity.ISizable;
import team.cqr.cqrepoured.entity.ITextureVariants;
import team.cqr.cqrepoured.entity.ITradeRestockOverTime;
import team.cqr.cqrepoured.entity.ai.EntityAIFireFighter;
import team.cqr.cqrepoured.entity.ai.EntityAIFollowAttackTarget;
import team.cqr.cqrepoured.entity.ai.EntityAIFollowPath;
import team.cqr.cqrepoured.entity.ai.EntityAIIdleSit;
import team.cqr.cqrepoured.entity.ai.EntityAIMoveToHome;
import team.cqr.cqrepoured.entity.ai.EntityAIMoveToLeader;
import team.cqr.cqrepoured.entity.ai.EntityAIOpenCloseDoor;
import team.cqr.cqrepoured.entity.ai.EntityAIRideHorse;
import team.cqr.cqrepoured.entity.ai.EntityAISearchMount;
import team.cqr.cqrepoured.entity.ai.EntityAITameAndLeashPet;
import team.cqr.cqrepoured.entity.ai.EntityAITasksProfiled;
import team.cqr.cqrepoured.entity.ai.EntityAITorchIgniter;
import team.cqr.cqrepoured.entity.ai.attack.EntityAIAttack;
import team.cqr.cqrepoured.entity.ai.attack.EntityAIAttackRanged;
import team.cqr.cqrepoured.entity.ai.attack.EntityAIBackstab;
import team.cqr.cqrepoured.entity.ai.attack.special.EntityAIAttackSpecial;
import team.cqr.cqrepoured.entity.ai.attack.special.EntityAIHooker;
import team.cqr.cqrepoured.entity.ai.attack.special.EntityAILooter;
import team.cqr.cqrepoured.entity.ai.item.EntityAICursedBoneSummoner;
import team.cqr.cqrepoured.entity.ai.item.EntityAIFireball;
import team.cqr.cqrepoured.entity.ai.item.EntityAIHealingPotion;
import team.cqr.cqrepoured.entity.ai.item.EntityAIPotionThrower;
import team.cqr.cqrepoured.entity.ai.spells.EntityAISpellHandler;
import team.cqr.cqrepoured.entity.ai.spells.IEntityAISpellAnimatedVanilla;
import team.cqr.cqrepoured.entity.ai.target.EntityAICQRNearestAttackTarget;
import team.cqr.cqrepoured.entity.ai.target.EntityAIHurtByTarget;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.pathfinding.Path;
import team.cqr.cqrepoured.entity.pathfinding.PathNavigateGroundCQR;
import team.cqr.cqrepoured.entity.trade.TraderOffer;
import team.cqr.cqrepoured.faction.EDefaultFaction;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.faction.FactionRegistry;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.init.CQRSounds;
import team.cqr.cqrepoured.item.IFakeWeapon;
import team.cqr.cqrepoured.item.ISupportWeapon;
import team.cqr.cqrepoured.item.ItemBadge;
import team.cqr.cqrepoured.item.ItemPotionHealing;
import team.cqr.cqrepoured.item.ItemShieldDummy;
import team.cqr.cqrepoured.item.armor.ItemBackpack;
import team.cqr.cqrepoured.item.spear.ItemSpearBase;
import team.cqr.cqrepoured.item.staff.ItemStaffHealing;
import team.cqr.cqrepoured.network.server.packet.SPacketItemStackSync;
import team.cqr.cqrepoured.network.server.packet.SPacketUpdateEntityPrevPos;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.EntityUtil;
import team.cqr.cqrepoured.util.ItemUtil;
import team.cqr.cqrepoured.util.SpawnerFactory;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonPlacement;

public abstract class AbstractEntityCQR
extends EntityCreature
implements IMob,
IEntityAdditionalSpawnData,
ISizable,
IHasTextureOverride,
ITextureVariants,
ITradeRestockOverTime {
    private static final UUID BASE_ATTACK_SPEED_ID = UUID.fromString("be37de40-8857-48b1-aa99-49dd243fc22c");
    private static final UUID HEALTH_SCALE_SLIDER_ID = UUID.fromString("4b654c1d-fb8f-42b9-a278-0d49dab6d176");
    private static final UUID HEALTH_SCALE_DISTANCE_TO_SPAWN_ID = UUID.fromString("cf718cfe-d6a1-4cf6-b6c8-b5cf397f334c");
    protected static final DataParameter<Boolean> IS_LEADER = EntityDataManager.func_187226_a(AbstractEntityCQR.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> INVISIBILITY = EntityDataManager.func_187226_a(AbstractEntityCQR.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> IS_SITTING = EntityDataManager.func_187226_a(AbstractEntityCQR.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HAS_TARGET = EntityDataManager.func_187226_a(AbstractEntityCQR.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> TALKING = EntityDataManager.func_187226_a(AbstractEntityCQR.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> TEXTURE_INDEX = EntityDataManager.func_187226_a(AbstractEntityCQR.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> MAGIC_ARMOR_ACTIVE = EntityDataManager.func_187226_a(AbstractEntityCQR.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> SPELL_INFORMATION = EntityDataManager.func_187226_a(AbstractEntityCQR.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> SPIN_TO_WIN = EntityDataManager.func_187226_a(AbstractEntityCQR.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<String> FACTION_OVERRIDE_SYNC = EntityDataManager.func_187226_a(AbstractEntityCQR.class, (DataSerializer)DataSerializers.field_187194_d);
    protected static final DataParameter<NBTTagCompound> SHOULDER_ENTITY = EntityDataManager.func_187226_a(AbstractEntityCQR.class, (DataSerializer)DataSerializers.field_192734_n);
    protected static final DataParameter<String> TEXTURE_OVERRIDE = EntityDataManager.func_187226_a(AbstractEntityCQR.class, (DataSerializer)DataSerializers.field_187194_d);
    protected BlockPos field_70775_bC;
    protected UUID leaderUUID;
    protected EntityLivingBase leader;
    private int lastTickPingedAsLeader = -1000;
    protected boolean holdingPotion;
    protected byte usedPotions;
    protected double healthScale = 1.0;
    private ItemStack prevPotion;
    private boolean prevSneaking;
    private boolean prevSitting;
    protected float sizeScaling = 1.0f;
    protected int lastTickWithAttackTarget = Integer.MIN_VALUE;
    protected int lastTimeSeenAttackTarget = Integer.MIN_VALUE;
    protected Vec3d lastPosAttackTarget = Vec3d.field_186680_a;
    protected EntityAISpellHandler spellHandler;
    private int invisibilityTick;
    private Faction factionInstance;
    private Faction defaultFactionInstance;
    private String factionName;
    protected int lastTickShieldDisabled = Integer.MIN_VALUE;
    protected float damageBlockedWithShield;
    protected boolean armorActive;
    protected int magicArmorCooldown = 300;
    protected EntityAIRideHorse<AbstractEntityCQR> horseAI;
    protected Path path = new Path(){

        @Override
        public boolean removeNode(Path.PathNode node) {
            boolean flag = super.removeNode(node);
            if (flag) {
                if (AbstractEntityCQR.this.prevPathTargetPoint == node.getIndex()) {
                    AbstractEntityCQR.this.prevPathTargetPoint = -1;
                } else if (AbstractEntityCQR.this.prevPathTargetPoint > node.getIndex()) {
                    --AbstractEntityCQR.this.prevPathTargetPoint;
                }
                if (AbstractEntityCQR.this.currentPathTargetPoint == node.getIndex()) {
                    AbstractEntityCQR.this.currentPathTargetPoint = -1;
                } else if (AbstractEntityCQR.this.currentPathTargetPoint > node.getIndex()) {
                    --AbstractEntityCQR.this.currentPathTargetPoint;
                }
            }
            return flag;
        }

        @Override
        public void clear() {
            super.clear();
            AbstractEntityCQR.this.prevPathTargetPoint = -1;
            AbstractEntityCQR.this.currentPathTargetPoint = -1;
        }

        @Override
        public void copyFrom(Path path, BlockPos offset) {
            super.copyFrom(path, offset);
            AbstractEntityCQR.this.prevPathTargetPoint = -1;
            AbstractEntityCQR.this.currentPathTargetPoint = -1;
        }
    };
    protected int prevPathTargetPoint = -1;
    protected int currentPathTargetPoint = -1;
    private TraderOffer trades = new TraderOffer(this);
    private long lastTimedTradeRestock = 0L;
    protected ResourceLocation textureOverride;
    protected BossInfoServer bossInfoServer;
    @SideOnly(value=Side.CLIENT)
    protected ESpeechBubble currentSpeechBubbleID;

    protected AbstractEntityCQR(World worldIn) {
        super(worldIn);
        if (worldIn.field_72995_K) {
            this.chooseNewRandomSpeechBubble();
        }
        this.field_70728_aV = 5;
        this.initializeSize();
    }

    public void enableBossBar() {
        if (!this.field_70170_p.field_72995_K && this.bossInfoServer == null) {
            this.bossInfoServer = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.NOTCHED_10);
            this.bossInfoServer.func_186758_d(CQRConfig.bosses.enableBossBars);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_LEADER, (Object)false);
        this.field_70180_af.func_187214_a(INVISIBILITY, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(IS_SITTING, (Object)false);
        this.field_70180_af.func_187214_a(HAS_TARGET, (Object)false);
        this.field_70180_af.func_187214_a(TALKING, (Object)false);
        this.field_70180_af.func_187214_a(TEXTURE_INDEX, (Object)this.getTextureVariant(this.func_70681_au()));
        this.field_70180_af.func_187214_a(MAGIC_ARMOR_ACTIVE, (Object)false);
        this.field_70180_af.func_187214_a(SPELL_INFORMATION, (Object)0);
        this.field_70180_af.func_187214_a(SPIN_TO_WIN, (Object)false);
        this.field_70180_af.func_187214_a(TEXTURE_OVERRIDE, (Object)"");
        this.field_70180_af.func_187214_a(FACTION_OVERRIDE_SYNC, (Object)"");
        this.field_70180_af.func_187214_a(SHOULDER_ENTITY, (Object)new NBTTagCompound());
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getBaseHealth());
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        PathNavigateGroundCQR navigator = new PathNavigateGroundCQR((EntityLiving)this, worldIn);
        ((PathNavigateGround)navigator).func_179691_c(true);
        ((PathNavigateGround)navigator).func_179688_b(this.canOpenDoors());
        return navigator;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return this.attackEntityFrom(source, amount, false);
    }

    public boolean attackEntityFrom(DamageSource source, float amount, boolean sentFromPart) {
        boolean flag;
        ResourceLocation resLoc;
        if (CQRConfig.advanced.enableSpecialFeatures && source.func_76346_g() != null && (resLoc = EntityList.func_191301_a((Entity)source.func_76346_g())) != null && resLoc.func_110624_b().equalsIgnoreCase("iceandfire")) {
            amount *= 0.5f;
        }
        this.spawnShoulderEntities();
        if (this.field_70170_p.func_72912_H().func_76093_s()) {
            amount *= 0.7f;
        } else {
            EnumDifficulty difficulty = this.field_70170_p.func_175659_aa();
            if (difficulty == EnumDifficulty.HARD) {
                amount *= 0.8f;
            } else if (difficulty == EnumDifficulty.NORMAL) {
                amount *= 0.9f;
            }
        }
        amount = this.handleDamageCap(source, amount);
        if (!this.field_70170_p.field_72995_K && amount > 0.0f && this.func_184583_d(source)) {
            if (source.func_76364_f() instanceof EntityLivingBase && !(source.func_76364_f() instanceof EntityPlayer) && ((EntityLivingBase)source.func_76364_f()).func_184614_ca().func_77973_b() instanceof ItemAxe) {
                this.lastTickShieldDisabled = this.field_70173_aa;
            } else {
                this.damageBlockedWithShield += amount;
                if ((double)this.damageBlockedWithShield >= CQRConfig.general.damageBlockedByShield) {
                    this.damageBlockedWithShield = 0.0f;
                    this.lastTickShieldDisabled = this.field_70173_aa;
                }
            }
        }
        if ((flag = super.func_70097_a(source, amount)) && CQRConfig.mobs.armorShattersOnMobs) {
            this.handleArmorBreaking();
        }
        return flag;
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((EntityLivingBase)this, (Entity)entityIn, (float)strength, (double)xRatio, (double)zRatio);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        xRatio = event.getRatioX();
        zRatio = event.getRatioZ();
        double knockbackResistance = this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
        this.field_70160_al = true;
        double d = 1.0 / (double)MathHelper.func_76133_a((double)(xRatio * xRatio + zRatio * zRatio));
        this.field_70159_w *= 0.5;
        this.field_70179_y *= 0.5;
        this.field_70159_w -= xRatio * d * (double)(strength *= 1.0f - Math.min((float)knockbackResistance, 1.0f));
        this.field_70179_y -= zRatio * d * (double)strength;
        if (this.field_70122_E) {
            this.field_70181_x *= 0.5;
            this.field_70181_x += (double)strength;
            if (this.field_70181_x > 0.4) {
                this.field_70181_x = 0.4;
            }
        }
    }

    protected boolean damageCapEnabled() {
        return CQRConfig.mobs.enableDamageCapForNonBossMobs;
    }

    protected float maxDamageInPercentOfMaxHP() {
        return CQRConfig.mobs.maxUncappedDamageInMaxHPPercent;
    }

    protected float maxUncappedDamage() {
        return CQRConfig.mobs.maxUncappedDamageForNonBossMobs;
    }

    private float handleDamageCap(DamageSource source, float originalAmount) {
        if (source.func_180136_u() || source.func_76357_e()) {
            return originalAmount;
        }
        if (this.damageCapEnabled()) {
            return Math.min(Math.max(this.maxUncappedDamage(), this.func_110138_aP() * this.maxDamageInPercentOfMaxHP()), originalAmount);
        }
        return originalAmount;
    }

    public boolean func_184583_d(DamageSource damageSourceIn) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && this.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = this.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        Item item;
        if (this.isHoldingPotion()) {
            this.swapWeaponAndPotionSlotItemStacks();
        }
        if ((item = this.func_184614_ca().func_77973_b()) instanceof IFakeWeapon) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(((IFakeWeapon)item).getOriginalItem()));
        }
        super.func_70645_a(cause);
        this.updateReputationOnDeath(cause);
    }

    protected void func_184651_r() {
        if (CQRConfig.advanced.debugAI) {
            this.field_70714_bg = new EntityAITasksProfiled(this.field_70170_p.field_72984_F, this.field_70170_p);
            this.field_70715_bh = new EntityAITasksProfiled(this.field_70170_p.field_72984_F, this.field_70170_p);
        }
        this.spellHandler = this.createSpellHandler();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIOpenCloseDoor(this));
        if (this.canMountEntity()) {
            this.horseAI = new EntityAIRideHorse<AbstractEntityCQR>(this, 1.5);
            this.field_70714_bg.func_75776_a(8, this.horseAI);
        }
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIHealingPotion(this));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)this.spellHandler);
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIAttackSpecial(this));
        this.field_70714_bg.func_75776_a(13, new EntityAIAttackRanged<AbstractEntityCQR>(this));
        this.field_70714_bg.func_75776_a(14, (EntityAIBase)new EntityAIPotionThrower(this));
        this.field_70714_bg.func_75776_a(15, (EntityAIBase)new EntityAIFireball(this));
        this.field_70714_bg.func_75776_a(16, (EntityAIBase)new EntityAIHooker(this));
        this.field_70714_bg.func_75776_a(17, (EntityAIBase)new EntityAIBackstab(this));
        this.field_70714_bg.func_75776_a(18, (EntityAIBase)new EntityAIAttack(this));
        this.field_70714_bg.func_75776_a(19, (EntityAIBase)new EntityAICursedBoneSummoner(this));
        this.field_70714_bg.func_75776_a(20, (EntityAIBase)new EntityAIFollowAttackTarget(this));
        this.field_70714_bg.func_75776_a(22, (EntityAIBase)new EntityAIFireFighter(this));
        this.field_70714_bg.func_75776_a(23, (EntityAIBase)new EntityAITorchIgniter(this));
        this.field_70714_bg.func_75776_a(24, (EntityAIBase)new EntityAILooter(this));
        this.field_70714_bg.func_75776_a(25, (EntityAIBase)new EntityAITameAndLeashPet(this));
        this.field_70714_bg.func_75776_a(26, (EntityAIBase)new EntityAISearchMount(this));
        this.field_70714_bg.func_75776_a(30, (EntityAIBase)new EntityAIMoveToLeader(this));
        this.field_70714_bg.func_75776_a(31, (EntityAIBase)new EntityAIFollowPath(this));
        this.field_70714_bg.func_75776_a(32, (EntityAIBase)new EntityAIMoveToHome(this));
        this.field_70714_bg.func_75776_a(33, (EntityAIBase)new EntityAIIdleSit(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAICQRNearestAttackTarget(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(this));
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setHealingPotions(1);
        this.setItemStackToExtraSlot(EntityEquipmentExtraSlot.BADGE, new ItemStack(CQRItems.BADGE));
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            this.func_184642_a(slot, 0.04f);
        }
        return livingdata;
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        ItemStack stack = this.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBow) {
            ItemStack stack1 = this.getItemStackFromExtraSlot(EntityEquipmentExtraSlot.ARROW);
            if (stack1.func_190926_b()) {
                stack1 = new ItemStack(Items.field_151032_g, this.func_70681_au().nextInt(3));
            } else {
                stack1 = stack1.func_77946_l();
                stack1.func_190920_e(this.func_70681_au().nextInt(3));
            }
            this.func_70099_a(stack1, 0.0f);
        }
        double modalValue = CQRConfig.mobs.dropDurabilityModalValue;
        double standardDeviation = CQRConfig.mobs.dropDurabilityStandardDeviation;
        double min = Math.min(CQRConfig.mobs.dropDurabilityMinimum, modalValue);
        double max = Math.max(CQRConfig.mobs.dropDurabilityMaximum, modalValue);
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            IItemHandler inv;
            ItemStack itemstack = this.func_184582_a(entityequipmentslot);
            double d0 = this.getDropChance(entityequipmentslot);
            boolean flag = d0 > 1.0;
            boolean backpackflag = false;
            if (itemstack.func_77973_b() instanceof ItemBackpack && (inv = (IItemHandler)itemstack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    if (inv.getStackInSlot(i).func_190926_b()) continue;
                    backpackflag = true;
                    break;
                }
            }
            if (!backpackflag && (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack) || !wasRecentlyHit && !flag || !((double)(this.field_70146_Z.nextFloat() - (float)lootingModifier * 0.01f) < d0))) continue;
            if (!flag && itemstack.func_77984_f() && !backpackflag) {
                double durability = modalValue + MathHelper.func_151237_a((double)(this.field_70146_Z.nextGaussian() * standardDeviation), (double)(min - modalValue), (double)(max - modalValue));
                itemstack.func_77964_b((int)((double)itemstack.func_77958_k() * (1.0 - durability)));
            }
            this.func_70099_a(itemstack, 0.0f);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.field_70775_bC != null) {
            compound.func_74782_a("home", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.field_70775_bC));
        }
        if (this.leaderUUID != null) {
            compound.func_74782_a("leader", (NBTBase)NBTUtil.func_186862_a((UUID)this.leaderUUID));
        }
        if (this.factionName != null && !this.factionName.equalsIgnoreCase(this.getDefaultFaction().name())) {
            compound.func_74778_a("factionOverride", this.factionName);
        }
        compound.func_74768_a("textureIndex", ((Integer)this.field_70180_af.func_187225_a(TEXTURE_INDEX)).intValue());
        compound.func_74774_a("usedHealingPotions", this.usedPotions);
        this.callOnWriteToNBT(compound);
        compound.func_74757_a("holdingPotion", this.holdingPotion);
        compound.func_74780_a("healthScale", this.healthScale);
        NBTTagCompound pathTag = new NBTTagCompound();
        pathTag.func_74782_a("path", (NBTBase)this.path.writeToNBT());
        pathTag.func_74768_a("prevPathTargetPoint", this.prevPathTargetPoint);
        pathTag.func_74768_a("currentPathTargetPoint", this.currentPathTargetPoint);
        compound.func_74782_a("pathTag", (NBTBase)pathTag);
        if (!this.getLeftShoulderEntity().func_82582_d()) {
            compound.func_74782_a("ShoulderEntityLeft", (NBTBase)this.getLeftShoulderEntity());
        }
        compound.func_74782_a("trades", (NBTBase)this.trades.writeToNBT(new NBTTagCompound()));
        compound.func_74772_a("lastTimedRestockTime", this.getLastTimedRestockTime());
        if (this.hasTextureOverride()) {
            compound.func_74778_a("textureOverride", this.getTextureOverride().toString());
        }
        if (this.bossInfoServer != null) {
            compound.func_74757_a("hasBossBar", true);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        String ct;
        NBTTagCompound pathTag;
        super.func_70037_a(compound);
        if (compound.func_74764_b("home")) {
            this.field_70775_bC = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("home"));
        }
        if (compound.func_74764_b("leader")) {
            this.leaderUUID = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("leader"));
        }
        if (compound.func_74764_b("factionOverride")) {
            this.setFaction(compound.func_74779_i("factionOverride"));
        }
        this.field_70180_af.func_187227_b(TEXTURE_INDEX, (Object)compound.func_74762_e("textureIndex"));
        this.usedPotions = compound.func_74771_c("usedHealingPotions");
        this.callOnReadFromNBT(compound);
        this.holdingPotion = compound.func_74767_n("holdingPotion");
        this.setHealthScale(compound.func_150297_b("healthScale", 6) ? compound.func_74769_h("healthScale") : 1.0);
        if (compound.func_150297_b("pathingAI", 10)) {
            pathTag = compound.func_74775_l("pathingAI");
            NBTTagList nbtTagList = pathTag.func_150295_c("pathPoints", 10);
            this.path.clear();
            for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
                BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)nbtTagList.func_150305_b(i));
                this.path.addNode(this.path.getNode(this.path.getSize() - 1), pos, 0, 0, 0.0f, 1, 0, 24000, true);
            }
            this.currentPathTargetPoint = pathTag.func_74762_e("currentPathPoint");
            this.prevPathTargetPoint = nbtTagList.func_74745_c() > 1 ? (this.currentPathTargetPoint > 0 ? this.currentPathTargetPoint - 1 : nbtTagList.func_74745_c()) : -1;
        } else if (compound.func_150297_b("pathTag", 10)) {
            pathTag = compound.func_74775_l("pathTag");
            this.path.readFromNBT(pathTag.func_74775_l("path"));
            this.prevPathTargetPoint = pathTag.func_74762_e("prevPathTargetPoint");
            this.currentPathTargetPoint = pathTag.func_74762_e("currentPathTargetPoint");
        }
        if (compound.func_150297_b("ShoulderEntityLeft", 10)) {
            this.setLeftShoulderEntity(compound.func_74775_l("ShoulderEntityLeft"));
        }
        this.trades.readFromNBT(compound.func_74775_l("trades"));
        if (compound.func_150297_b("lastTimedRestockTime", 4)) {
            this.lastTimedTradeRestock = compound.func_74763_f("lastTimedRestockTime");
        }
        if (compound.func_150297_b("textureOverride", 8) && !(ct = compound.func_74779_i("textureOverride")).isEmpty()) {
            this.setCustomTexture(new ResourceLocation(ct));
        }
        if (compound.func_74764_b("hasBossBar")) {
            this.enableBossBar();
        }
        if (this.func_145818_k_() && this.bossInfoServer != null) {
            this.bossInfoServer.func_186739_a(this.func_145748_c_());
        }
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.func_184586_b(hand).func_77973_b() instanceof ItemNameTag) {
            return super.func_184645_a(player, hand);
        }
        boolean flag = false;
        if (!player.func_70093_af()) {
            if (player.func_184812_l_() || this.getLeader() == player) {
                if (!this.field_70170_p.field_72995_K) {
                    player.openGui((Object)CQRMain.INSTANCE, 6, this.field_70170_p, this.func_145782_y(), 0, 0);
                }
                flag = true;
            } else if (!this.getFaction().isEnemy((Entity)player) && this.hasTrades()) {
                if (!this.field_70170_p.field_72995_K) {
                    player.openGui((Object)CQRMain.INSTANCE, 8, this.field_70170_p, this.func_145782_y(), 0, 0);
                }
                flag = true;
            }
        } else if (player.func_184812_l_() || !this.getFaction().isEnemy((Entity)player) && this.hasTrades()) {
            if (!this.field_70170_p.field_72995_K) {
                player.openGui((Object)CQRMain.INSTANCE, 8, this.field_70170_p, this.func_145782_y(), 0, 0);
            }
            flag = true;
        }
        if (flag && !this.func_70671_ap().func_180424_b() && !this.func_70781_l()) {
            float yaw;
            double x1 = player.field_70165_t - this.field_70165_t;
            double z1 = player.field_70161_v - this.field_70161_v;
            this.field_70177_z = yaw = (float)Math.toDegrees(Math.atan2(-x1, z1));
            this.field_70759_as = yaw;
            this.field_70761_aq = yaw;
        }
        return flag;
    }

    @Override
    public boolean hasTrades() {
        return !this.trades.isEmpty();
    }

    protected abstract ResourceLocation func_184647_J();

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        ResourceLocation resourcelocation = this.func_184647_J();
        if (resourcelocation != null) {
            LootTable lootTable = this.field_70170_p.func_184146_ak().func_186521_a(resourcelocation);
            LootContext.Builder lootContextBuilder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this).func_186473_a(source);
            if (wasRecentlyHit && this.field_70717_bb != null) {
                lootContextBuilder = lootContextBuilder.func_186470_a(this.field_70717_bb).func_186469_a(this.field_70717_bb.func_184817_da());
            }
            for (ItemStack itemstack : lootTable.func_186462_a(this.field_70146_Z, lootContextBuilder.func_186471_a())) {
                this.func_70099_a(itemstack, 0.0f);
            }
        }
        this.dropBadgeContentOnDeath();
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    protected void dropBadgeContentOnDeath() {
        ItemStack badge = this.getItemStackFromExtraSlot(EntityEquipmentExtraSlot.BADGE);
        if (badge.func_77973_b() instanceof ItemBadge) {
            IItemHandler capability = (IItemHandler)badge.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < capability.getSlots(); ++i) {
                this.func_70099_a(capability.getStackInSlot(i), 0.0f);
            }
        }
    }

    public void func_70071_h_() {
        IAttributeInstance attribute;
        ItemStack stackMainhand;
        EntityLivingBase attackTarget = this.func_70638_az();
        if (attackTarget != null) {
            this.lastTickWithAttackTarget = this.field_70173_aa;
            if (this.isInSightRange((Entity)attackTarget) && this.func_70635_at().func_75522_a((Entity)attackTarget)) {
                this.lastTimeSeenAttackTarget = this.field_70173_aa;
            }
            if (this.lastTimeSeenAttackTarget + 100 >= this.field_70173_aa) {
                this.lastPosAttackTarget = attackTarget.func_174791_d();
            }
        }
        if (this.lastTickWithAttackTarget + 60 < this.field_70173_aa && this.damageBlockedWithShield > 0.0f) {
            this.damageBlockedWithShield = Math.max(this.damageBlockedWithShield - 0.02f, 0.0f);
        }
        if (!(stackMainhand = this.func_184614_ca()).func_111283_C(EntityEquipmentSlot.MAINHAND).containsKey((Object)SharedMonsterAttributes.field_188790_f.func_111108_a())) {
            attribute = this.func_110148_a(SharedMonsterAttributes.field_188790_f);
            if (attribute.func_111127_a(BASE_ATTACK_SPEED_ID) == null) {
                AttributeModifier modifier = new AttributeModifier(BASE_ATTACK_SPEED_ID, "Base Attack Speed", -2.4, 0);
                modifier.func_111168_a(false);
                attribute.func_111121_a(modifier);
            }
        } else {
            attribute = this.func_110148_a(SharedMonsterAttributes.field_188790_f);
            attribute.func_188479_b(BASE_ATTACK_SPEED_ID);
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.isMagicArmorActive()) {
            this.updateCooldownForMagicArmor();
        }
        if (!this.field_70170_p.field_72995_K && !this.func_184222_aU() && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            SpawnerFactory.placeSpawner(new Entity[]{this}, false, null, this.field_70170_p, this.func_180425_c());
            this.func_70106_y();
        }
        ItemStack stack = this.getItemStackFromExtraSlot(EntityEquipmentExtraSlot.POTION);
        if (!this.field_70170_p.field_72995_K && stack != this.prevPotion) {
            CQRMain.NETWORK.sendToAllTracking((IMessage)new SPacketItemStackSync(this.func_145782_y(), EntityEquipmentExtraSlot.POTION.getIndex(), stack), (Entity)this);
        }
        this.prevPotion = stack;
        if (this.func_70093_af() && !this.prevSneaking) {
            this.resize(1.0f, 0.8f);
        } else if (!this.func_70093_af() && this.prevSneaking) {
            this.resize(1.0f, 1.25f);
        }
        if (this.isSitting() && !this.prevSitting) {
            this.resize(1.0f, 0.75f);
        } else if (!this.isSitting() && this.prevSitting) {
            this.resize(1.0f, 1.3333334f);
        }
        this.prevSneaking = this.func_70093_af();
        this.prevSitting = this.isSitting();
        if (!this.field_70170_p.field_72995_K) {
            int spellInformation = 0;
            if (this.spellHandler != null) {
                if (this.spellHandler.isSpellCharging()) {
                    spellInformation |= 0x4000000;
                }
                if (this.spellHandler.isSpellCasting()) {
                    spellInformation |= 0x2000000;
                }
                if (this.spellHandler.getActiveSpell() instanceof IEntityAISpellAnimatedVanilla) {
                    IEntityAISpellAnimatedVanilla spell = (IEntityAISpellAnimatedVanilla)((Object)this.spellHandler.getActiveSpell());
                    spellInformation |= 0x1000000;
                    spellInformation |= ((int)((double)spell.getRed() * 255.0) & 0xFF) << 16;
                    spellInformation |= ((int)((double)spell.getGreen() * 255.0) & 0xFF) << 8;
                    spellInformation |= (int)((double)spell.getBlue() * 255.0) & 0xFF;
                }
            }
            this.field_70180_af.func_187227_b(SPELL_INFORMATION, (Object)spellInformation);
        } else {
            if (this.isSpellCharging() && this.isSpellAnimated()) {
                int spellColor = (Integer)this.field_70180_af.func_187225_a(SPELL_INFORMATION);
                double red = (double)(spellColor >> 16 & 0xFF) / 255.0;
                double green = (double)(spellColor >> 8 & 0xFF) / 255.0;
                double blue = (double)(spellColor & 0xFF) / 255.0;
                float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
                float f1 = MathHelper.func_76134_b((float)f);
                float f2 = MathHelper.func_76126_a((float)f);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (double)f1 * (double)this.field_70130_N, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + (double)f2 * (double)this.field_70130_N, red, green, blue, new int[0]);
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t - (double)f1 * (double)this.field_70130_N, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v - (double)f2 * (double)this.field_70130_N, red, green, blue, new int[0]);
            }
            if (this.isChatting() && this.field_70173_aa % 80 == 0) {
                this.chooseNewRandomSpeechBubble();
            }
        }
        this.updateInvisibility();
        this.updateLeader();
        this.updateTradeRestockTimer();
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
        if (this.bossInfoServer != null) {
            this.bossInfoServer.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        if (this.bossInfoServer != null) {
            this.bossInfoServer.func_186760_a(player);
        }
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        if (this.bossInfoServer != null) {
            this.bossInfoServer.func_186761_b(player);
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        if (this.bossInfoServer != null) {
            this.bossInfoServer.func_186739_a(this.func_145748_c_());
        }
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    protected final SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.func_184583_d(damageSourceIn) ? SoundEvents.field_187767_eL : this.getDefaultHurtSound(damageSourceIn);
    }

    protected SoundEvent getDefaultHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.field_187741_cz;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187738_cy;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        ResourceLocation resLoc;
        this.spawnShoulderEntities();
        if (this.func_184614_ca().func_77973_b() instanceof ItemStaffHealing) {
            if (entityIn instanceof EntityLivingBase) {
                if (!this.field_70170_p.field_72995_K) {
                    ((EntityLivingBase)entityIn).func_70691_i(4.0f);
                    entityIn.func_70015_d(0);
                    ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.HEART, entityIn.field_70165_t, entityIn.field_70163_u + (double)entityIn.field_70131_O * 0.5, entityIn.field_70161_v, 4, 0.25, 0.25, 0.25, 0.0, new int[0]);
                    this.field_70170_p.func_184148_a(null, entityIn.field_70165_t, entityIn.field_70163_u + (double)entityIn.field_70131_O * 0.5, entityIn.field_70161_v, CQRSounds.MAGIC, SoundCategory.MASTER, 0.6f, 0.6f + this.field_70146_Z.nextFloat() * 0.2f);
                }
                return true;
            }
            return false;
        }
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (CQRConfig.advanced.enableSpecialFeatures && (resLoc = EntityList.func_191301_a((Entity)entityIn)) != null && resLoc.func_110624_b().equalsIgnoreCase("iceandfire")) {
            f *= 2.0f;
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    protected boolean func_146066_aG() {
        return true;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.getSizeVariation());
        buffer.writeDouble(this.getHealthScale());
        buffer.writeFloat(this.getDropChance(EntityEquipmentSlot.HEAD));
        buffer.writeFloat(this.getDropChance(EntityEquipmentSlot.CHEST));
        buffer.writeFloat(this.getDropChance(EntityEquipmentSlot.LEGS));
        buffer.writeFloat(this.getDropChance(EntityEquipmentSlot.FEET));
        buffer.writeFloat(this.getDropChance(EntityEquipmentSlot.MAINHAND));
        buffer.writeFloat(this.getDropChance(EntityEquipmentSlot.OFFHAND));
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.getItemStackFromExtraSlot(EntityEquipmentExtraSlot.POTION));
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.trades.writeToNBT(new NBTTagCompound()));
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setSizeVariation(additionalData.readFloat());
        this.setHealthScale(additionalData.readDouble());
        this.func_184642_a(EntityEquipmentSlot.HEAD, additionalData.readFloat());
        this.func_184642_a(EntityEquipmentSlot.CHEST, additionalData.readFloat());
        this.func_184642_a(EntityEquipmentSlot.LEGS, additionalData.readFloat());
        this.func_184642_a(EntityEquipmentSlot.FEET, additionalData.readFloat());
        this.func_184642_a(EntityEquipmentSlot.MAINHAND, additionalData.readFloat());
        this.func_184642_a(EntityEquipmentSlot.OFFHAND, additionalData.readFloat());
        this.setItemStackToExtraSlot(EntityEquipmentExtraSlot.POTION, ByteBufUtils.readItemStack((ByteBuf)additionalData));
        this.trades.readFromNBT(ByteBufUtils.readTag((ByteBuf)additionalData));
        this.chooseNewRandomSpeechBubble();
    }

    public void updateLeader() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.field_70180_af.func_187227_b(IS_LEADER, (Object)(this.field_70173_aa - this.lastTickPingedAsLeader < 200 ? 1 : 0));
        if (this.leaderUUID == null) {
            this.leader = null;
            return;
        }
        if (this.leader == null) {
            if ((this.func_145782_y() + this.field_70173_aa) % 20 != 0) {
                return;
            }
            Entity entity = EntityUtil.getEntityByUUID(this.field_70170_p, this.leaderUUID);
            if (entity instanceof EntityLivingBase) {
                this.leader = (EntityLivingBase)entity;
            }
        } else if (!this.leader.func_70089_S()) {
            this.leaderUUID = null;
            this.leader = null;
        }
        if (this.leader instanceof AbstractEntityCQR) {
            ((AbstractEntityCQR)this.leader).lastTickPingedAsLeader = this.leader.field_70173_aa;
        }
    }

    public EntityLivingBase getLeader() {
        return this.leader;
    }

    public void setLeader(EntityLivingBase leader) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (leader == null) {
            this.leaderUUID = null;
            this.leader = null;
        } else {
            this.leaderUUID = leader.getPersistentID();
            this.leader = leader;
        }
    }

    public boolean hasLeader() {
        return this.getLeader() != null;
    }

    public boolean isLeader() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_LEADER);
    }

    public BlockPos getHomePositionCQR() {
        return this.field_70775_bC;
    }

    public void setHomePositionCQR(BlockPos homePosition) {
        this.field_70775_bC = homePosition;
    }

    public boolean hasHomePositionCQR() {
        return this.getHomePositionCQR() != null;
    }

    public abstract float getBaseHealth();

    public void setBaseHealthDependingOnPos(BlockPos pos) {
        if (CQRConfig.mobs.enableHealthChangeOnDistance && !this.field_70170_p.field_72995_K) {
            double x = (double)pos.func_177958_n() - (double)DungeonGenUtils.getSpawnX(this.field_70170_p);
            double z = (double)pos.func_177952_p() - (double)DungeonGenUtils.getSpawnZ(this.field_70170_p);
            double distance = Math.sqrt(x * x + z * z);
            double amount = 0.1 * (double)((int)(distance / (double)CQRConfig.mobs.distanceDivisor));
            EntityUtil.applyMaxHealthModifier((EntityLivingBase)this, HEALTH_SCALE_DISTANCE_TO_SPAWN_ID, "Health Scale Distance To Spawn", amount);
        }
    }

    public void handleArmorBreaking() {
        if (!this.field_70170_p.field_72995_K && this.usedPotions + 1 > this.getHealingPotions()) {
            boolean armorBroke = false;
            float hpPrcntg = this.func_110143_aJ() / this.func_110138_aP();
            float[] thresholds = new float[]{0.8f, 0.6f, 0.4f, 0.2f};
            EntityEquipmentSlot[] slots = new EntityEquipmentSlot[]{EntityEquipmentSlot.FEET, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST};
            for (int i = 0; i < 4 && !(hpPrcntg > thresholds[i]); ++i) {
                if (this.func_184582_a(slots[i]).func_190926_b()) continue;
                this.func_184201_a(slots[i], ItemStack.field_190927_a);
                armorBroke = true;
            }
            if (armorBroke) {
                this.func_184185_a(SoundEvents.field_187635_cQ, 1.75f, 0.8f);
            }
        }
    }

    public int getHealingPotions() {
        ItemStack stack = this.getHeldItemPotion();
        if (stack.func_77973_b() instanceof ItemPotionHealing) {
            return stack.func_190916_E();
        }
        return 0;
    }

    public void setHealingPotions(int amount) {
        ItemStack stack = new ItemStack(CQRItems.POTION_HEALING, amount);
        if (this.holdingPotion) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
        } else {
            this.setItemStackToExtraSlot(EntityEquipmentExtraSlot.POTION, stack);
        }
    }

    public ItemStack getItemStackFromExtraSlot(EntityEquipmentExtraSlot slot) {
        CapabilityExtraItemHandler capability = (CapabilityExtraItemHandler)((Object)this.getCapability(CapabilityExtraItemHandlerProvider.EXTRA_ITEM_HANDLER, null));
        return capability.getStackInSlot(slot.getIndex());
    }

    public void setItemStackToExtraSlot(EntityEquipmentExtraSlot slot, ItemStack stack) {
        CapabilityExtraItemHandler capability = (CapabilityExtraItemHandler)((Object)this.getCapability(CapabilityExtraItemHandlerProvider.EXTRA_ITEM_HANDLER, null));
        capability.setStackInSlot(slot.getIndex(), stack);
    }

    public void swapWeaponAndPotionSlotItemStacks() {
        ItemStack stack1 = this.func_184582_a(EntityEquipmentSlot.MAINHAND);
        ItemStack stack2 = this.getItemStackFromExtraSlot(EntityEquipmentExtraSlot.POTION);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, stack2);
        this.setItemStackToExtraSlot(EntityEquipmentExtraSlot.POTION, stack1);
        this.holdingPotion = !this.holdingPotion;
    }

    public boolean isHoldingPotion() {
        return this.holdingPotion;
    }

    protected abstract EDefaultFaction getDefaultFaction();

    protected Faction getDefaultFactionInstance() {
        if (this.defaultFactionInstance == null) {
            this.defaultFactionInstance = FactionRegistry.instance((Entity)this).getFactionInstance(this.getDefaultFaction().name());
        }
        return this.defaultFactionInstance;
    }

    @Nullable
    public Faction getFaction() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.factionInstance == null && this.factionName != null && !this.factionName.isEmpty()) {
                this.factionInstance = FactionRegistry.instance((Entity)this).getFactionInstance(this.factionName);
            }
            if (this.factionInstance != null) {
                return this.factionInstance;
            }
        } else {
            String syncedFaction = (String)this.field_70180_af.func_187225_a(FACTION_OVERRIDE_SYNC);
            if (!(syncedFaction == null || syncedFaction.isEmpty() || this.factionName != null && this.factionName.equals(syncedFaction))) {
                this.factionName = syncedFaction;
                this.factionInstance = FactionRegistry.instance((Entity)this).getFactionInstance(syncedFaction);
            }
            if (this.factionInstance != null) {
                return this.factionInstance;
            }
        }
        return this.getDefaultFactionInstance();
    }

    public void setFaction(String newFac) {
        this.setFaction(newFac, false);
    }

    public void setFaction(String newFac, boolean ignoreCTS) {
        Faction faction;
        if (!this.field_70170_p.field_72995_K && (faction = FactionRegistry.instance((Entity)this).getFactionInstance(newFac)) != null) {
            ResourceLocation rs;
            this.factionInstance = null;
            this.factionName = newFac;
            if (!ignoreCTS && (rs = faction.getRandomTextureFor((Entity)this)) != null) {
                this.setCustomTexture(rs);
            }
            this.field_70180_af.func_187227_b(FACTION_OVERRIDE_SYNC, (Object)newFac);
        }
    }

    @Override
    public void setCustomTexture(@Nonnull ResourceLocation texture) {
        this.field_70180_af.func_187227_b(TEXTURE_OVERRIDE, (Object)texture.toString());
    }

    public boolean hasFaction() {
        return this.getFaction() != null;
    }

    public void updateReputationOnDeath(DamageSource cause) {
        if (cause.func_76346_g() instanceof EntityPlayer && this.hasFaction() && !this.field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)cause.func_76346_g();
            int range = CQRConfig.mobs.factionUpdateRadius;
            double x1 = player.field_70165_t - (double)range;
            double y1 = player.field_70163_u - (double)range;
            double z1 = player.field_70161_v - (double)range;
            double x2 = player.field_70165_t + (double)range;
            double y2 = player.field_70163_u + (double)range;
            double z2 = player.field_70161_v + (double)range;
            AxisAlignedBB aabb = new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
            ArrayList<Faction> checkedFactions = new ArrayList<Faction>();
            for (AbstractEntityCQR cqrentity : this.field_70170_p.func_72872_a(AbstractEntityCQR.class, aabb)) {
                if (!cqrentity.hasFaction() || checkedFactions.contains(cqrentity.getFaction()) || !cqrentity.func_70685_l((Entity)this) && !cqrentity.func_70685_l((Entity)player)) continue;
                Faction faction = cqrentity.getFaction();
                if (this.getFaction().equals(faction)) {
                    faction.decrementReputation(player, faction.getRepuMemberKill());
                } else if (this.getFaction().isEnemy(faction)) {
                    faction.incrementReputation(player, faction.getRepuEnemyKill());
                } else if (this.getFaction().isAlly(faction)) {
                    faction.decrementReputation(player, faction.getRepuAllyKill());
                }
                checkedFactions.add(faction);
            }
        }
    }

    public void onExportFromWorld() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        for (Path.PathNode node : this.path.getNodes()) {
            node.setPos(node.getPos().func_177982_a(-x, -y, -z));
        }
    }

    public void onSpawnFromCQRSpawnerInDungeon(DungeonPlacement placement) {
        this.setHomePositionCQR(new BlockPos((Entity)this));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getBaseHealth());
        this.func_70606_j(this.func_110138_aP());
        this.setBaseHealthDependingOnPos(placement.getPos());
        this.setLastTimedRestockTime(this.field_70170_p.func_82737_E());
        for (Path.PathNode node : this.path.getNodes()) {
            node.setPos((BlockPos)DungeonPlacement.transform(node.getPos().func_177958_n(), node.getPos().func_177956_o(), node.getPos().func_177952_p(), BlockPos.field_177992_a, placement.getMirror(), placement.getRotation()));
            node.setWaitingRotation(AbstractEntityCQR.getTransformedYaw(node.getWaitingRotation(), placement.getMirror(), placement.getRotation()));
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack = this.func_184582_a(slot);
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemShieldDummy) || placement.getInhabitant() == null) continue;
            this.func_184201_a(slot, new ItemStack(placement.getInhabitant().getShieldReplacement(), 1));
        }
        if (placement.getInhabitant() != null && placement.getInhabitant().getFactionOverride() != null && !placement.getInhabitant().getFactionOverride().isEmpty() && FactionRegistry.instance((Entity)this).getFactionInstance(placement.getInhabitant().getFactionOverride()) != null) {
            this.setFaction(placement.getInhabitant().getFactionOverride());
        }
    }

    private static float getTransformedYaw(float rotationYaw, Mirror mirror, Rotation rotation) {
        float f = MathHelper.func_76142_g((float)rotationYaw);
        switch (mirror) {
            case LEFT_RIGHT: {
                f = 180.0f - f;
                break;
            }
            case FRONT_BACK: {
                f = -f;
                break;
            }
        }
        switch (rotation) {
            case CLOCKWISE_90: {
                f += 90.0f;
                break;
            }
            case CLOCKWISE_180: {
                f += 180.0f;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                f -= 90.0f;
                break;
            }
        }
        return MathHelper.func_76142_g((float)f);
    }

    public boolean hasCape() {
        return false;
    }

    public ResourceLocation getResourceLocationOfCape() {
        return null;
    }

    public void setSitting(boolean sitting) {
        this.field_70180_af.func_187227_b(IS_SITTING, (Object)sitting);
    }

    public boolean isSitting() {
        if (this.hasTrades()) {
            return false;
        }
        return (Boolean)this.field_70180_af.func_187225_a(IS_SITTING);
    }

    public void setChatting(boolean chatting) {
        this.field_70180_af.func_187227_b(TALKING, (Object)chatting);
    }

    public boolean isChatting() {
        return (Boolean)this.field_70180_af.func_187225_a(TALKING);
    }

    @SideOnly(value=Side.CLIENT)
    public ESpeechBubble getCurrentSpeechBubble() {
        return this.currentSpeechBubbleID;
    }

    @SideOnly(value=Side.CLIENT)
    public void chooseNewRandomSpeechBubble() {
        this.currentSpeechBubbleID = this.hasTrades() ? ESpeechBubble.getRandTraderBubble(this.field_70146_Z) : ESpeechBubble.getRandNormalBubble(this.field_70146_Z);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getTextureIndex() {
        return (Integer)this.field_70180_af.func_187225_a(TEXTURE_INDEX);
    }

    public double getAttackReach(EntityLivingBase target) {
        double reach = ((double)this.field_70130_N + (double)target.field_70130_N) * 0.5 + 0.85;
        ItemStack stack = this.func_184614_ca();
        if (stack.func_77973_b() instanceof ItemSpearBase) {
            reach += ((ItemSpearBase)stack.func_77973_b()).getReach();
        }
        return reach;
    }

    public boolean isInAttackReach(EntityLivingBase target) {
        return this.isInReach(target, this.getAttackReach(target));
    }

    public boolean isInReach(EntityLivingBase target, double distance) {
        double y;
        double x = target.field_70165_t - this.field_70165_t;
        if (target.field_70163_u + (double)target.field_70131_O < this.field_70163_u) {
            y = target.field_70163_u + (double)target.field_70131_O - this.field_70163_u;
            y *= 1.0 + (double)this.func_70047_e() / (double)this.field_70131_O;
        } else if (target.field_70163_u > this.field_70163_u + (double)this.field_70131_O) {
            y = target.field_70163_u - (this.field_70163_u + (double)this.field_70131_O);
            y *= 1.0 + ((double)this.field_70131_O - (double)this.func_70047_e()) / (double)this.field_70131_O;
        } else {
            y = 0.0;
        }
        double z = target.field_70161_v - this.field_70161_v;
        return x * x + y * y + z * z <= distance * distance;
    }

    public boolean canStrafe() {
        if (this.horseAI != null) {
            return this.func_184208_bv() == null;
        }
        return this.func_184187_bx() == null;
    }

    public boolean canOpenDoors() {
        return true;
    }

    public boolean canPutOutFire() {
        return true;
    }

    public boolean canIgniteTorch() {
        return true;
    }

    public boolean canTameEntity() {
        return true;
    }

    public boolean canMountEntity() {
        return true;
    }

    public boolean isEntityInFieldOfView(EntityLivingBase target) {
        double x = target.field_70165_t - this.field_70165_t;
        double z = target.field_70161_v - this.field_70161_v;
        double d = Math.toDegrees(Math.atan2(-x, z));
        if (!ItemUtil.compareRotations(this.field_70759_as, d, 80.0)) {
            return false;
        }
        double y = target.field_70163_u + (double)target.func_70047_e() - this.field_70163_u - (double)this.func_70047_e();
        double xz = Math.sqrt(x * x + z * z);
        double d1 = Math.toDegrees(Math.atan2(y, xz));
        return ItemUtil.compareRotations(this.field_70125_A, d1, 50.0);
    }

    public void setHealthScale(double newHealthScale) {
        if (this.healthScale != newHealthScale) {
            if (!this.field_70170_p.field_72995_K) {
                EntityUtil.applyMaxHealthModifier((EntityLivingBase)this, HEALTH_SCALE_SLIDER_ID, "Health Scale Slider", newHealthScale - 1.0);
            }
            this.healthScale = newHealthScale;
        }
    }

    public double getHealthScale() {
        return this.healthScale;
    }

    public float getDropChance(EntityEquipmentSlot slot) {
        switch (slot.func_188453_a()) {
            case HAND: {
                return this.field_82174_bp[slot.func_188454_b()];
            }
            case ARMOR: {
                return this.field_184655_bs[slot.func_188454_b()];
            }
        }
        return 0.0f;
    }

    public boolean isInSightRange(Entity target) {
        double sightRange = 32.0;
        sightRange *= 0.6 + 0.4 * (double)this.field_70170_p.func_175699_k(new BlockPos(target)) / 15.0;
        return this.func_70068_e(target) <= (sightRange *= this.func_70644_a(MobEffects.field_76440_q) ? 0.5 : 1.0) * sightRange;
    }

    public ItemStack getHeldItemWeapon() {
        return this.isHoldingPotion() ? this.getItemStackFromExtraSlot(EntityEquipmentExtraSlot.POTION) : this.func_184614_ca();
    }

    public ItemStack getHeldItemPotion() {
        return this.isHoldingPotion() ? this.func_184614_ca() : this.getItemStackFromExtraSlot(EntityEquipmentExtraSlot.POTION);
    }

    public boolean isMagicArmorActive() {
        if (!this.field_70170_p.field_72995_K) {
            return this.armorActive;
        }
        return (Boolean)this.field_70180_af.func_187225_a(MAGIC_ARMOR_ACTIVE);
    }

    public void setMagicArmorActive(boolean val) {
        if (val != this.armorActive) {
            this.armorActive = val;
            this.func_184224_h(this.armorActive);
            this.field_70180_af.func_187227_b(MAGIC_ARMOR_ACTIVE, (Object)val);
        }
    }

    protected void updateCooldownForMagicArmor() {
        --this.magicArmorCooldown;
        if (this.magicArmorCooldown <= 0) {
            this.setMagicArmorActive(false);
        }
    }

    public void setMagicArmorCooldown(int val) {
        this.magicArmorCooldown = val;
        this.setMagicArmorActive(true);
    }

    @Override
    public float getDefaultWidth() {
        return 0.6f;
    }

    @Override
    public float getDefaultHeight() {
        return 1.875f;
    }

    @Override
    public void resize(float widthScale, float heightSacle) {
        this.func_70105_a(this.field_70130_N * widthScale, this.field_70131_O * heightSacle);
        if ((double)(this.field_70138_W * heightSacle) >= 1.0) {
            this.field_70138_W *= heightSacle;
        }
    }

    public Path getPath() {
        return this.path;
    }

    public void setCurrentPathTargetPoint(int value) {
        this.prevPathTargetPoint = this.currentPathTargetPoint;
        this.currentPathTargetPoint = value;
    }

    public int getCurrentPathTargetPoint() {
        return this.currentPathTargetPoint;
    }

    public int getPrevPathTargetPoint() {
        return this.prevPathTargetPoint;
    }

    public int getLastTickWithAttackTarget() {
        return this.lastTickWithAttackTarget;
    }

    public int getLastTimeSeenAttackTarget() {
        return this.lastTimeSeenAttackTarget;
    }

    public Vec3d getLastPosAttackTarget() {
        return this.lastPosAttackTarget;
    }

    public EntityAISpellHandler createSpellHandler() {
        return new EntityAISpellHandler(this, 200);
    }

    public boolean isSpellCharging() {
        return ((Integer)this.field_70180_af.func_187225_a(SPELL_INFORMATION) >> 26 & 1) == 1;
    }

    public boolean isSpellCasting() {
        return ((Integer)this.field_70180_af.func_187225_a(SPELL_INFORMATION) >> 25 & 1) == 1;
    }

    public boolean isSpellAnimated() {
        return ((Integer)this.field_70180_af.func_187225_a(SPELL_INFORMATION) >> 24 & 1) == 1;
    }

    public void setLastTimeHitByAxeWhileBlocking(int tick) {
        this.lastTickShieldDisabled = tick;
    }

    public int getLastTimeHitByAxeWhileBlocking() {
        return this.lastTickShieldDisabled;
    }

    public boolean hasAttackTarget() {
        if (this.field_70170_p.field_72995_K) {
            return (Boolean)this.field_70180_af.func_187225_a(HAS_TARGET);
        }
        return this.func_70638_az() != null && !this.func_70638_az().field_70128_L;
    }

    public void func_70624_b(EntityLivingBase entitylivingbaseIn) {
        EntityLivingBase prevAttackTarget = this.func_70638_az();
        super.func_70624_b(entitylivingbaseIn);
        EntityLivingBase attackTarget = this.func_70638_az();
        if (prevAttackTarget == attackTarget) {
            return;
        }
        if (attackTarget == null) {
            this.field_70180_af.func_187227_b(HAS_TARGET, (Object)false);
            this.lastTimeSeenAttackTarget = Integer.MIN_VALUE;
            this.lastPosAttackTarget = this.func_174791_d();
            Item item = this.func_184614_ca().func_77973_b();
            if (item instanceof IFakeWeapon) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(((IFakeWeapon)item).getOriginalItem()));
            }
        } else {
            this.field_70180_af.func_187227_b(HAS_TARGET, (Object)true);
            this.lastTimeSeenAttackTarget = this.field_70173_aa;
            this.lastPosAttackTarget = attackTarget.func_174791_d();
            Item item = this.func_184614_ca().func_77973_b();
            if (TargetUtil.isAllyCheckingLeaders((EntityLivingBase)this, attackTarget)) {
                if (item instanceof IFakeWeapon) {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(((IFakeWeapon)item).getOriginalItem()));
                }
            } else if (item instanceof ISupportWeapon) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(((ISupportWeapon)item).getFakeWeapon()));
            }
        }
    }

    public boolean addShoulderEntity(NBTTagCompound compound) {
        if (!this.func_184218_aH() && this.field_70122_E && !this.func_70090_H()) {
            if (this.getLeftShoulderEntity().func_82582_d()) {
                this.setLeftShoulderEntity(compound);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void spawnShoulderEntities() {
        this.spawnShoulderEntity(this.getLeftShoulderEntity());
        this.setLeftShoulderEntity(new NBTTagCompound());
    }

    private void spawnShoulderEntity(@Nullable NBTTagCompound compound) {
        if (!this.field_70170_p.field_72995_K && compound != null && !compound.func_82582_d()) {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)compound, (World)this.field_70170_p);
            if (entity instanceof EntityTameable) {
                ((EntityTameable)entity).func_184754_b(this.field_96093_i);
            }
            entity.func_70107_b(this.field_70165_t, this.field_70163_u + (double)0.7f, this.field_70161_v);
            this.field_70170_p.func_72838_d(entity);
        }
    }

    public NBTTagCompound getLeftShoulderEntity() {
        return (NBTTagCompound)this.field_70180_af.func_187225_a(SHOULDER_ENTITY);
    }

    protected void setLeftShoulderEntity(NBTTagCompound tag) {
        this.field_70180_af.func_187227_b(SHOULDER_ENTITY, (Object)tag);
    }

    public boolean canUseSpinToWinAttack() {
        return this.func_184187_bx() == null;
    }

    public boolean isSpinToWinActive() {
        return this.canUseSpinToWinAttack() && (Boolean)this.field_70180_af.func_187225_a(SPIN_TO_WIN) != false;
    }

    public void setSpinToWin(boolean value) {
        if (this.func_70613_aW()) {
            this.field_70180_af.func_187227_b(SPIN_TO_WIN, (Object)value);
        }
    }

    @Override
    public TraderOffer getTrades() {
        return this.trades;
    }

    public void teleport(double x, double y, double z) {
        this.func_70107_b(x, y, z);
        CQRMain.NETWORK.sendToAllTracking((IMessage)new SPacketUpdateEntityPrevPos((Entity)this), (Entity)this);
    }

    @Override
    public boolean hasTextureOverride() {
        return this.field_70180_af.func_187225_a(TEXTURE_OVERRIDE) != null && !((String)this.field_70180_af.func_187225_a(TEXTURE_OVERRIDE)).isEmpty();
    }

    @Override
    public ResourceLocation getTextureOverride() {
        if (this.textureOverride == null || !this.textureOverride.toString().equals(this.field_70180_af.func_187225_a(TEXTURE_OVERRIDE))) {
            this.textureOverride = new ResourceLocation((String)this.field_70180_af.func_187225_a(TEXTURE_OVERRIDE));
        }
        return this.textureOverride;
    }

    public void updateInvisibility() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.invisibilityTick > 0) {
                --this.invisibilityTick;
                this.field_70180_af.func_187227_b(INVISIBILITY, (Object)Float.valueOf(Math.min(((Float)this.field_70180_af.func_187225_a(INVISIBILITY)).floatValue() + 1.0f / (float)this.getInvisibilityTurningTime(), 1.0f)));
            } else {
                this.field_70180_af.func_187227_b(INVISIBILITY, (Object)Float.valueOf(Math.max(((Float)this.field_70180_af.func_187225_a(INVISIBILITY)).floatValue() - 1.0f / (float)this.getInvisibilityTurningTime(), 0.0f)));
            }
        }
    }

    protected int getInvisibilityTurningTime() {
        return 15;
    }

    public void setInvisibility(int ticks) {
        this.invisibilityTick = ticks;
    }

    public float getInvisibility() {
        return ((Float)this.field_70180_af.func_187225_a(INVISIBILITY)).floatValue();
    }

    @Override
    public float getSizeVariation() {
        return this.sizeScaling;
    }

    @Override
    public void applySizeVariation(float value) {
        this.sizeScaling = value;
    }

    public boolean canPlayDeathAnimation() {
        return this.field_70729_aU || (double)this.func_110143_aJ() < 0.01 || this.field_70128_L || !this.func_70089_S();
    }

    @Override
    public long getLastTimedRestockTime() {
        return this.lastTimedTradeRestock;
    }

    @Override
    public void setLastTimedRestockTime(long newValue) {
        this.lastTimedTradeRestock = newValue;
    }
}

