/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.misc;

import com.google.common.base.Predicate;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cqr.cqrepoured.capability.electric.CapabilityElectricShock;
import team.cqr.cqrepoured.capability.electric.CapabilityElectricShockProvider;
import team.cqr.cqrepoured.entity.IDontRenderFire;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.faction.FactionRegistry;
import team.cqr.cqrepoured.util.EntityUtil;

public class EntityElectricField
extends Entity
implements IDontRenderFire,
IEntityOwnable {
    private static Set<BlockPos> EXISTING_FIELDS = new HashSet<BlockPos>();
    private Queue<EnumFacing> facesToSpreadTo = this.generateFacesQueue();
    private int charge;
    private int spreadTimer = 15;
    private UUID ownerID = null;
    private Predicate<EntityLivingBase> selectionPredicate = input -> {
        if (!TargetUtil.PREDICATE_CAN_BE_ELECTROCUTED.apply(input)) {
            return false;
        }
        if (this.ownerID == null || this.func_70902_q() == null || this.func_70902_q().field_70128_L || !this.func_70902_q().func_70089_S()) {
            return true;
        }
        if (input.getPersistentID().equals(this.ownerID)) {
            return false;
        }
        if (input instanceof IEntityOwnable) {
            return !((IEntityOwnable)input).func_184753_b().equals(this.ownerID);
        }
        Faction ownerFaction = FactionRegistry.instance(this).getFactionOf(this.func_70902_q());
        if (ownerFaction != null) {
            return TargetUtil.createPredicateNonAlly(ownerFaction).apply(input);
        }
        if (this.func_70902_q() instanceof EntityLivingBase) {
            return TargetUtil.isAllyCheckingLeaders((EntityLivingBase)this.func_70902_q(), input);
        }
        return true;
    };

    public EntityElectricField(World worldIn) {
        this(worldIn, 100, null);
    }

    private Queue<EnumFacing> generateFacesQueue() {
        LinkedList<EnumFacing> q = new LinkedList<EnumFacing>();
        q.add(EnumFacing.UP);
        q.add(EnumFacing.DOWN);
        q.add(EnumFacing.NORTH);
        q.add(EnumFacing.EAST);
        q.add(EnumFacing.SOUTH);
        q.add(EnumFacing.WEST);
        return q;
    }

    public EntityElectricField(World worldIn, int charge, UUID ownerId) {
        super(worldIn);
        this.field_70145_X = true;
        this.charge = charge;
        this.ownerID = ownerId;
        this.func_70105_a(1.125f, 1.125f);
    }

    protected void func_70088_a() {
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        BlockPos p = new BlockPos(x, y, z);
        EXISTING_FIELDS.add(p);
    }

    public boolean func_70104_M() {
        return false;
    }

    protected List<EntityLivingBase> getEntitiesAffectedByField() {
        return this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ(), this.selectionPredicate);
    }

    public boolean func_70027_ad() {
        return false;
    }

    public void destroyField() {
        this.func_70106_y();
        EXISTING_FIELDS.remove(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v));
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            --this.charge;
            BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.charge < 0) {
                this.destroyField();
                return;
            }
            this.getEntitiesAffectedByField().forEach(t -> {
                ((CapabilityElectricShock)t.getCapability(CapabilityElectricShockProvider.ELECTROCUTE_HANDLER_CQR, null)).setRemainingTicks(200);
                ((CapabilityElectricShock)t.getCapability(CapabilityElectricShockProvider.ELECTROCUTE_HANDLER_CQR, null)).setRemainingSpreads(4);
            });
            if (!this.facesToSpreadTo.isEmpty()) {
                --this.spreadTimer;
                if (this.spreadTimer == 0) {
                    EnumFacing face;
                    this.spreadTimer = 5;
                    while (!this.facesToSpreadTo.isEmpty() && (face = this.facesToSpreadTo.poll()) != null) {
                        int charge;
                        IBlockState blockState;
                        BlockPos currentPos = pos.func_177972_a(face);
                        if (EXISTING_FIELDS.contains(currentPos) || !(blockState = this.field_70170_p.func_180495_p(currentPos)).func_185904_a().func_76224_d() && blockState.func_185904_a() != Material.field_151573_f || (charge = this.charge - 10) <= 0) continue;
                        EntityElectricField newField = new EntityElectricField(this.field_70170_p, charge, this.ownerID);
                        newField.func_70107_b((double)currentPos.func_177958_n() + 0.5, currentPos.func_177956_o(), (double)currentPos.func_177952_p() + 0.5);
                        this.field_70170_p.func_72838_d((Entity)newField);
                        break;
                    }
                }
            }
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.charge = compound.func_74762_e("charge");
        if (compound.func_74764_b("ownerId")) {
            this.ownerID = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("ownerId"));
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("charge", this.charge);
        if (this.func_70902_q() != null) {
            compound.func_74782_a("ownerId", (NBTBase)NBTUtil.func_186862_a((UUID)this.func_184753_b()));
        }
    }

    @Nullable
    public UUID func_184753_b() {
        return this.ownerID;
    }

    public void setCharge(int charge) {
        this.charge = charge;
    }

    @Nullable
    public Entity func_70902_q() {
        return EntityUtil.getEntityByUUID(this.field_70170_p, this.ownerID);
    }
}

