/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.misc;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.entity.IDontRenderFire;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.entity.bases.ISummoner;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.faction.FactionRegistry;

public class EntitySummoningCircle
extends Entity
implements IEntityAdditionalSpawnData,
IDontRenderFire {
    protected static final int BORDER_WHEN_TO_SPAWN_IN_TICKS = 60;
    protected ResourceLocation entityToSpawn;
    protected float timeMultiplierForSummon;
    protected ECircleTexture texture;
    protected ISummoner summoner;
    protected EntityLivingBase summonerLiving;
    protected Vec3d velForSummon = null;

    public EntitySummoningCircle(World worldIn) {
        this(worldIn, new ResourceLocation("minecraft", "zombie"), 1.0f, ECircleTexture.ZOMBIE, null);
    }

    public EntitySummoningCircle(World worldIn, ResourceLocation entityToSpawn, float timeMultiplier, ECircleTexture texture, ISummoner summoner) {
        this(worldIn, entityToSpawn, timeMultiplier, texture, summoner, null);
    }

    public EntitySummoningCircle(World worldIn, ResourceLocation entityToSpawn, float timeMultiplier, ECircleTexture texture, ISummoner isummoner, EntityLivingBase summoner) {
        super(worldIn);
        this.func_70105_a(2.0f, 0.005f);
        this.entityToSpawn = entityToSpawn;
        this.timeMultiplierForSummon = timeMultiplier;
        this.texture = texture;
        this.summoner = isummoner;
        this.summonerLiving = summoner;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if ((float)this.field_70173_aa >= 60.0f * this.timeMultiplierForSummon) {
                Entity summon = EntityList.func_188429_b((ResourceLocation)this.entityToSpawn, (World)this.field_70170_p);
                if (summon != null) {
                    summon.func_70107_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v);
                    if (this.velForSummon != null) {
                        summon.field_70159_w = this.velForSummon.field_72450_a;
                        summon.field_70181_x = this.velForSummon.field_72448_b;
                        summon.field_70179_y = this.velForSummon.field_72449_c;
                        summon.field_70133_I = true;
                    }
                    if (this.summonerLiving instanceof EntityPlayer && summon instanceof AbstractEntityCQR) {
                        Arrays.stream(EntityEquipmentSlot.values()).forEach(slot -> ((AbstractEntityCQR)summon).func_184642_a((EntityEquipmentSlot)slot, 1.01f));
                    }
                    this.field_70170_p.func_72838_d(summon);
                    if (this.summonerLiving != null && summon instanceof AbstractEntityCQR) {
                        ((AbstractEntityCQR)summon).setLeader(this.summonerLiving);
                        Faction faction = FactionRegistry.instance(this).getFactionOf((Entity)this.summonerLiving);
                        if (faction != null) {
                            ((AbstractEntityCQR)summon).setFaction(faction.getName());
                        }
                    }
                    if (this.summoner != null && !this.summoner.getSummoner().field_70128_L) {
                        this.summoner.setSummonedEntityFaction(summon);
                        this.summoner.tryEquipSummon(summon, this.field_70170_p.field_73012_v);
                        this.summoner.addSummonedEntityToList(summon);
                    }
                }
                this.func_70106_y();
            }
        } else if ((float)this.field_70173_aa >= 60.0f * this.timeMultiplierForSummon * 0.8f) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t, this.field_70163_u + 0.02, this.field_70161_v, this.field_70146_Z.nextDouble(), this.field_70146_Z.nextDouble(), this.field_70146_Z.nextDouble(), new int[0]);
            }
            if (!this.field_70170_p.field_72995_K) {
                Faction faction = this.summoner != null ? this.summoner.getSummonerFaction() : null;
                for (Entity ent : this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.func_180425_c().func_177963_a((double)(this.field_70130_N / 2.0f), 0.0, (double)(this.field_70130_N / 2.0f)), this.func_180425_c().func_177963_a((double)(-this.field_70130_N / 2.0f), 3.0, (double)(-this.field_70130_N / 2.0f))), faction != null ? TargetUtil.createPredicateNonAlly(faction) : TargetUtil.PREDICATE_LIVING)) {
                    if (ent == null || !ent.func_70089_S() || !(ent instanceof EntityLivingBase)) continue;
                    ((EntityLivingBase)ent).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 80, 0));
                }
            }
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.timeMultiplierForSummon = compound.func_74760_g("cqrdata.timeMultiplier");
        String resD = compound.func_74779_i("cqrdata.entityToSpawn.Domain");
        String resP = compound.func_74779_i("cqrdata.entityToSpawn.Path");
        this.entityToSpawn = new ResourceLocation(resD, resP);
        this.field_70173_aa = compound.func_74762_e("ticksExisted");
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("cqrdata.timeMultiplier", this.timeMultiplierForSummon);
        compound.func_74778_a("cqrdata.entityToSpawn.Domain", this.entityToSpawn.func_110624_b());
        compound.func_74778_a("cqrdata.entityToSpawn.Path", this.entityToSpawn.func_110623_a());
        compound.func_74768_a("ticksExisted", this.field_70173_aa);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeByte(this.texture.ordinal());
        buffer.writeFloat(this.timeMultiplierForSummon);
        buffer.writeInt(this.field_70173_aa);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.texture = ECircleTexture.values()[additionalData.readByte()];
        this.timeMultiplierForSummon = additionalData.readFloat();
        this.field_70173_aa = additionalData.readInt();
    }

    @SideOnly(value=Side.CLIENT)
    public int getTextureID() {
        return this.texture.ordinal();
    }

    public void setVelocityForSummon(Vec3d v) {
        this.velForSummon = v;
    }

    public void setSummon(ResourceLocation summon) {
        if (summon != null) {
            this.entityToSpawn = summon;
        }
    }

    public static enum ECircleTexture {
        ZOMBIE,
        SKELETON,
        FLYING_SKULL,
        FLYING_SWORD,
        METEOR;


        static {
            ECircleTexture.values();
        }
    }
}

