/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.pathfinding;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import team.cqr.cqrepoured.entity.ai.EntityAIOpenCloseDoor;
import team.cqr.cqrepoured.world.ChunkCacheCQR;

public class PathNavigateGroundCQR
extends PathNavigateGround {
    private int ticksAtLastPos;
    private Vec3d lastPosCheck = Vec3d.field_186680_a;
    private Vec3d timeoutCachedNode = Vec3d.field_186680_a;
    private long timeoutTimer;
    private long lastTimeoutCheck;
    private double timeoutLimit;
    private long lastTimeUpdated;
    private BlockPos targetPos;
    private PathFinder pathFinder;

    public PathNavigateGroundCQR(EntityLiving entitylivingIn, World worldIn) {
        super(entitylivingIn, worldIn);
    }

    protected PathFinder func_179679_a() {
        this.field_179695_a = new WalkNodeProcessor(){

            public PathNodeType func_193577_a(IBlockAccess p_193577_1_, int x, int y, int z, int xSize, int ySize, int zSize, boolean canOpenDoorsIn, boolean canEnterDoorsIn, EnumSet<PathNodeType> p_193577_10_, PathNodeType p_193577_11_, BlockPos p_193577_12_) {
                for (int i = 0; i < xSize; ++i) {
                    for (int j = 0; j < ySize; ++j) {
                        for (int k = 0; k < zSize; ++k) {
                            int l = i + x;
                            int i1 = j + y;
                            int j1 = k + z;
                            PathNodeType pathnodetype = this.func_186330_a(p_193577_1_, l, i1, j1);
                            if (pathnodetype == PathNodeType.DOOR_WOOD_CLOSED && canOpenDoorsIn && canEnterDoorsIn) {
                                pathnodetype = PathNodeType.WALKABLE;
                            }
                            if (pathnodetype == PathNodeType.DOOR_IRON_CLOSED && canOpenDoorsIn && canEnterDoorsIn && EntityAIOpenCloseDoor.canMoveThroughDoor(p_193577_1_, new BlockPos(l, i1, j1), EnumFacing.func_176737_a((float)(l - p_193577_12_.func_177958_n()), (float)(i1 - p_193577_12_.func_177956_o()), (float)(j1 - p_193577_12_.func_177952_p())).func_176734_d(), true)) {
                                pathnodetype = PathNodeType.WALKABLE;
                            }
                            if (pathnodetype == PathNodeType.DOOR_OPEN && !canEnterDoorsIn) {
                                pathnodetype = PathNodeType.BLOCKED;
                            }
                            if (pathnodetype == PathNodeType.RAIL && !(p_193577_1_.func_180495_p(p_193577_12_).func_177230_c() instanceof BlockRailBase) && !(p_193577_1_.func_180495_p(p_193577_12_.func_177977_b()).func_177230_c() instanceof BlockRailBase)) {
                                pathnodetype = PathNodeType.FENCE;
                            }
                            if (i == 0 && j == 0 && k == 0) {
                                p_193577_11_ = pathnodetype;
                            }
                            p_193577_10_.add(pathnodetype);
                        }
                    }
                }
                return p_193577_11_;
            }

            protected PathNodeType func_189553_b(IBlockAccess p_189553_1_, int p_189553_2_, int p_189553_3_, int p_189553_4_) {
                BlockPos blockpos = new BlockPos(p_189553_2_, p_189553_3_, p_189553_4_);
                IBlockState iblockstate = p_189553_1_.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                Material material = iblockstate.func_185904_a();
                PathNodeType type = block.getAiPathNodeType(iblockstate, p_189553_1_, blockpos, this.currentEntity);
                if (type != null) {
                    return type;
                }
                if (material == Material.field_151579_a) {
                    return PathNodeType.OPEN;
                }
                if (block != Blocks.field_150415_aT && block != Blocks.field_180400_cw && block != Blocks.field_150392_bi) {
                    if (block == Blocks.field_150480_ab) {
                        return PathNodeType.DAMAGE_FIRE;
                    }
                    if (block == Blocks.field_150434_aF) {
                        return PathNodeType.DAMAGE_CACTUS;
                    }
                    if (block instanceof BlockDoor && material == Material.field_151575_d && !((Boolean)iblockstate.func_185899_b(p_189553_1_, blockpos).func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                        return PathNodeType.DOOR_WOOD_CLOSED;
                    }
                    if (block instanceof BlockDoor && material == Material.field_151573_f && !((Boolean)iblockstate.func_185899_b(p_189553_1_, blockpos).func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                        return PathNodeType.DOOR_IRON_CLOSED;
                    }
                    if (block instanceof BlockDoor && ((Boolean)iblockstate.func_185899_b(p_189553_1_, blockpos).func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                        return PathNodeType.DOOR_OPEN;
                    }
                    if (block instanceof BlockRailBase) {
                        return PathNodeType.RAIL;
                    }
                    if (!(block instanceof BlockFence || block instanceof BlockWall || block instanceof BlockFenceGate && !((Boolean)iblockstate.func_177229_b((IProperty)BlockFenceGate.field_176466_a)).booleanValue())) {
                        if (material == Material.field_151586_h) {
                            return PathNodeType.WATER;
                        }
                        if (material == Material.field_151587_i) {
                            return PathNodeType.LAVA;
                        }
                        return block.func_176205_b(p_189553_1_, blockpos) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
                    }
                    return PathNodeType.FENCE;
                }
                return PathNodeType.TRAPDOOR;
            }
        };
        this.field_179695_a.func_186317_a(true);
        this.pathFinder = new PathFinder(this.field_179695_a);
        return this.pathFinder;
    }

    public float func_111269_d() {
        return 256.0f;
    }

    public void func_188554_j() {
        if (this.hasMount()) {
            this.getMount().func_70661_as().func_188554_j();
        }
        if (this.field_75513_b.func_82737_E() - this.lastTimeUpdated > 20L) {
            if (this.targetPos != null) {
                this.field_75514_c = null;
                this.field_75514_c = this.func_179680_a(this.targetPos);
                this.lastTimeUpdated = this.field_75513_b.func_82737_E();
                this.field_188562_p = false;
            }
        } else {
            this.field_188562_p = true;
        }
    }

    public void func_75501_e() {
        super.func_75501_e();
        if (!this.func_75500_f() && this.hasMount()) {
            this.getMount().func_70661_as().func_75501_e();
        }
    }

    private boolean hasMount() {
        return this.field_75515_a.func_184187_bx() instanceof EntityLiving;
    }

    public Path func_179680_a(BlockPos pos) {
        if (this.field_75513_b.func_180495_p(pos).func_185904_a() == Material.field_151579_a) {
            BlockPos blockpos = pos.func_177977_b();
            while (blockpos.func_177956_o() > 0 && this.field_75513_b.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a) {
                blockpos = blockpos.func_177977_b();
            }
            if (blockpos.func_177956_o() > 0) {
                return this.getPathToPosCQR(blockpos.func_177984_a());
            }
            while (blockpos.func_177956_o() < this.field_75513_b.func_72800_K() && this.field_75513_b.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a) {
                blockpos = blockpos.func_177984_a();
            }
            pos = blockpos;
        }
        if (!this.field_75513_b.func_180495_p(pos).func_185904_a().func_76220_a()) {
            return this.getPathToPosCQR(pos);
        }
        BlockPos blockpos1 = pos.func_177984_a();
        while (blockpos1.func_177956_o() < this.field_75513_b.func_72800_K() && this.field_75513_b.func_180495_p(blockpos1).func_185904_a().func_76220_a()) {
            blockpos1 = blockpos1.func_177984_a();
        }
        return this.getPathToPosCQR(blockpos1);
    }

    @Nullable
    private Path getPathToPosCQR(BlockPos pos) {
        if (!this.func_75485_k()) {
            return null;
        }
        if (this.field_75514_c != null && !this.field_75514_c.func_75879_b() && pos.equals((Object)this.targetPos)) {
            return this.field_75514_c;
        }
        EntityLiving ent = this.hasMount() ? this.getMount() : this.field_75515_a;
        float distance = MathHelper.func_76133_a((double)ent.func_174831_c(pos));
        if (distance > this.func_111269_d()) {
            return null;
        }
        this.field_75513_b.field_72984_F.func_76320_a("pathfind");
        BlockPos entityPos = new BlockPos((Entity)(this.hasMount() ? this.getMount() : this.field_75515_a));
        ChunkCacheCQR chunkcache = new ChunkCacheCQR(this.field_75513_b, entityPos, pos, entityPos, 32, false);
        Path path = this.pathFinder.func_186336_a((IBlockAccess)chunkcache, this.hasMount() ? this.getMount() : this.field_75515_a, pos, (float)MathHelper.func_76123_f((float)(distance + 32.0f)));
        this.field_75513_b.field_72984_F.func_76319_b();
        return path;
    }

    public boolean func_75484_a(Path pathentityIn, double speedIn) {
        if (pathentityIn == null) {
            this.field_75514_c = null;
            this.targetPos = null;
            return false;
        }
        if (this.hasMount()) {
            this.getMount().func_70661_as().func_75484_a(pathentityIn, speedIn);
        }
        if (pathentityIn.func_75876_a(this.field_75514_c)) {
            return true;
        }
        this.field_75514_c = pathentityIn;
        this.func_75487_m();
        if (this.field_75514_c.func_75874_d() <= 0) {
            this.field_75514_c = null;
            this.targetPos = null;
            return false;
        }
        PathPoint finalPathPoint = pathentityIn.func_75870_c();
        this.targetPos = new BlockPos(finalPathPoint.field_75839_a, finalPathPoint.field_75837_b, finalPathPoint.field_75838_c);
        this.field_75511_d = speedIn;
        this.ticksAtLastPos = this.field_75510_g;
        this.lastPosCheck = this.func_75502_i();
        return true;
    }

    protected boolean func_75485_k() {
        return super.func_75485_k() || this.hasMount();
    }

    protected void func_179677_a(Vec3d positionVec3) {
        if (this.field_75510_g - this.ticksAtLastPos >= 100) {
            double aiMoveSpeed = this.hasMount() ? (double)this.getMount().func_70689_ay() : (double)this.field_75515_a.func_70689_ay();
            aiMoveSpeed = aiMoveSpeed * aiMoveSpeed * 0.98 / 0.454;
            if (positionVec3.func_72438_d(this.lastPosCheck) / 100.0 < aiMoveSpeed * 0.5) {
                this.func_75499_g();
            }
            this.ticksAtLastPos = this.field_75510_g;
            this.lastPosCheck = positionVec3;
        }
        if (this.field_75514_c != null && !this.field_75514_c.func_75879_b()) {
            Vec3d vec3d = this.field_75514_c.func_186310_f();
            if (!vec3d.equals((Object)this.timeoutCachedNode)) {
                this.timeoutCachedNode = vec3d;
                this.timeoutTimer = this.field_75510_g;
                double aiMoveSpeedOrig = this.hasMount() ? (double)this.getMount().func_70689_ay() : (double)this.field_75515_a.func_70689_ay();
                double aiMoveSpeed = aiMoveSpeedOrig;
                if (aiMoveSpeed > 0.0) {
                    aiMoveSpeed = aiMoveSpeed * aiMoveSpeed * 0.98 / 0.454;
                    double distance = positionVec3.func_72438_d(this.timeoutCachedNode);
                    this.timeoutLimit = aiMoveSpeedOrig > 0.0 ? (double)MathHelper.func_76143_f((double)(distance / aiMoveSpeed)) : 0.0;
                } else {
                    this.timeoutLimit = 0.0;
                }
            }
            if (this.timeoutLimit > 0.0 && (double)((long)this.field_75510_g - this.timeoutTimer) > this.timeoutLimit * 2.0) {
                this.timeoutCachedNode = Vec3d.field_186680_a;
                this.timeoutTimer = 0L;
                this.timeoutLimit = 0.0;
                this.func_75499_g();
            }
        }
    }

    @Nullable
    private EntityLiving getMount() {
        try {
            return (EntityLiving)this.field_75515_a.func_184187_bx();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public void func_75499_g() {
        if (this.hasMount()) {
            this.getMount().func_70661_as().func_75499_g();
        }
        this.field_75514_c = null;
        this.targetPos = null;
        super.func_75499_g();
    }
}

