/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.event.world.structure.protection;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import meldexun.reflectionutil.ReflectionField;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.capability.protectedregions.CapabilityProtectedRegionData;
import team.cqr.cqrepoured.capability.protectedregions.CapabilityProtectedRegionDataProvider;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.network.server.packet.SPacketSyncProtectedRegions;
import team.cqr.cqrepoured.network.server.packet.SPacketSyncProtectionConfig;
import team.cqr.cqrepoured.util.data.FileIOUtil;
import team.cqr.cqrepoured.world.structure.protection.IProtectedRegionManager;
import team.cqr.cqrepoured.world.structure.protection.ProtectedRegion;
import team.cqr.cqrepoured.world.structure.protection.ProtectedRegionHelper;
import team.cqr.cqrepoured.world.structure.protection.ProtectedRegionManager;
import team.cqr.cqrepoured.world.structure.protection.ServerProtectedRegionManager;

@Mod.EventBusSubscriber(modid="cqrepoured")
public class ProtectedRegionEventHandler {
    @SideOnly(value=Side.CLIENT)
    private static CQRConfig.DungeonProtection cachedProtectionConfig;
    @Deprecated
    private static final ReflectionField<Map<UUID, ServerProtectedRegionManager.ProtectedRegionContainer>> FIELD_PROTECTED_REGIONS;
    @Deprecated
    private static final ReflectionField<Set<UUID>> FIELD_PROTECTED_REGION_UUIDS;

    private ProtectedRegionEventHandler() {
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        IProtectedRegionManager protectedRegionManager;
        if (FMLCommonHandler.instance().getSide().isServer() || !CQRMain.proxy.isOwnerOfIntegratedServer(event.player)) {
            CQRMain.NETWORK.sendTo((IMessage)new SPacketSyncProtectionConfig(CQRConfig.dungeonProtection), (EntityPlayerMP)event.player);
        }
        if ((protectedRegionManager = ProtectedRegionManager.getInstance(event.player.field_70170_p)) == null) {
            return;
        }
        ProtectedRegionEventHandler.syncProtectedRegions(protectedRegionManager, (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        IProtectedRegionManager protectedRegionManager = ProtectedRegionManager.getInstance(event.player.field_70170_p);
        if (protectedRegionManager == null) {
            return;
        }
        ProtectedRegionEventHandler.syncProtectedRegions(protectedRegionManager, (EntityPlayerMP)event.player);
    }

    private static void syncProtectedRegions(IProtectedRegionManager protectedRegionManager, EntityPlayerMP player) {
        ArrayList list = new ArrayList();
        protectedRegionManager.getProtectedRegions().forEach(list::add);
        if (!list.isEmpty()) {
            ArrayList<ProtectedRegion> list1 = new ArrayList<ProtectedRegion>();
            boolean firstPacket = true;
            int sum = 0;
            for (int i = 0; i < list.size(); ++i) {
                ProtectedRegion protectedRegion = (ProtectedRegion)list.get(i);
                BlockPos size = protectedRegion.getEndPos().func_177973_b((Vec3i)protectedRegion.getStartPos()).func_177982_a(1, 1, 1);
                int j = size.func_177958_n() * size.func_177956_o() * size.func_177952_p();
                if (sum + j > 10000000) {
                    CQRMain.NETWORK.sendTo((IMessage)new SPacketSyncProtectedRegions(list1, firstPacket), player);
                    list1.clear();
                    firstPacket = false;
                }
                list1.add(protectedRegion);
                sum += j;
                if (i != list.size() - 1) continue;
                CQRMain.NETWORK.sendTo((IMessage)new SPacketSyncProtectedRegions(list1, firstPacket), player);
            }
        } else {
            CQRMain.NETWORK.sendTo((IMessage)new SPacketSyncProtectedRegions(Collections.emptyList(), true), player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onClientConnectedToServerEvent(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!Minecraft.func_71410_x().func_71387_A()) {
            cachedProtectionConfig = CQRConfig.dungeonProtection;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onClientDisconnectionFromServerEvent(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        IProtectedRegionManager protectedRegionManager = ProtectedRegionManager.getInstance((World)Minecraft.func_71410_x().field_71441_e);
        if (protectedRegionManager == null) {
            return;
        }
        protectedRegionManager.clearProtectedRegions();
        if (!Minecraft.func_71410_x().func_71387_A()) {
            CQRConfig.dungeonProtection = cachedProtectionConfig;
            ProtectedRegionHelper.updateWhitelists();
        }
    }

    @SubscribeEvent
    public static void onWorldCreatedEvent(WorldEvent.CreateSpawnPosition event) {
        ProtectedRegionManager.handleWorldLoad(event.getWorld());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onWorldLoadEvent(WorldEvent.Load event) {
        ProtectedRegionEventHandler.checkDeprecatedProtectedRegions(event.getWorld());
        ProtectedRegionManager.handleWorldLoad(event.getWorld());
    }

    @SubscribeEvent
    public static void onWorldSaveEvent(WorldEvent.Save event) {
        ProtectedRegionManager.handleWorldSave(event.getWorld());
    }

    @SubscribeEvent
    public static void onWorldUnloadEvent(WorldEvent.Unload event) {
        ProtectedRegionManager.handleWorldUnload(event.getWorld());
    }

    @SubscribeEvent
    public static void onChunkUnloadEvent(ChunkEvent.Load event) {
        ProtectedRegionManager.handleChunkLoad(event.getWorld(), event.getChunk());
    }

    @SubscribeEvent
    public static void onChunkUnloadEvent(ChunkEvent.Unload event) {
        ProtectedRegionManager.handleChunkUnload(event.getWorld(), event.getChunk());
    }

    @SubscribeEvent
    public static void onWorldTickEvent(TickEvent.WorldTickEvent event) {
        ProtectedRegionManager.handleWorldTick(event.world);
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        BlockPos pos;
        World world = event.getWorld();
        if (ProtectedRegionHelper.isBlockBreakingPrevented(world, pos = event.getPos(), (Entity)event.getPlayer(), true, true)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockPlaceEvent(BlockEvent.EntityPlaceEvent event) {
        if (ProtectedRegionHelper.isBlockPlacingPrevented(event.getWorld(), event.getPos(), event.getEntity(), event.getPlacedBlock(), true, true)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBucketUseEvent(FillBucketEvent event) {
        RayTraceResult result = event.getTarget();
        if (result == null) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = result.func_178782_a();
        ItemStack stack = event.getEmptyBucket();
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
        if (fluidStack == null || fluidStack.amount <= 0 || fluidStack.getFluid() == null || !fluidStack.getFluid().canBePlacedInWorld()) {
            IBlockState state = world.func_180495_p(pos.func_177972_a(result.field_178784_b));
            if (state.func_185904_a().func_76224_d() && ProtectedRegionHelper.isBlockBreakingPrevented(event.getWorld(), result.func_178782_a(), (Entity)event.getEntityPlayer(), true, true)) {
                event.setCanceled(true);
            }
        } else {
            IBlockState state = fluidStack.getFluid().getBlock().func_176223_P();
            if (ProtectedRegionHelper.isBlockPlacingPrevented(world, pos.func_177972_a(result.field_178784_b), (Entity)event.getEntityPlayer(), state, true, true)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlockEvent(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        BlockPos offsetPos = pos.func_177972_a(event.getFace());
        if (event.getWorld().func_180495_p(offsetPos).func_177230_c() == Blocks.field_150480_ab) {
            if (ProtectedRegionHelper.isBlockBreakingPrevented(player.field_70170_p, offsetPos, (Entity)player, false, true, null)) {
                event.setCanceled(true);
            }
        } else if (ProtectedRegionHelper.isBlockBreakingPrevented(player.field_70170_p, pos, (Entity)player, false, true, event.getFace())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        EnumHand hand;
        Vec3d hitVec;
        ItemStack stack;
        IBlockState state;
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        EnumFacing facing = event.getFace();
        if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if ((state = ProtectedRegionHelper.getBlockFromItem(stack = event.getItemStack(), world, pos, facing, hitVec = event.getHitVec(), (EntityLivingBase)player, hand = event.getHand())) == null) {
            return;
        }
        if (ProtectedRegionHelper.isBlockPlacingPrevented(world, pos, (Entity)player, state, false, true)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        if (ProtectedRegionHelper.isBlockBreakingPrevented(player.field_70170_p, pos, (Entity)player, false, true)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onExplosionEventDetonate(ExplosionEvent.Detonate event) {
        ProtectedRegionHelper.removeExplosionPreventedPositions(event.getWorld(), event.getExplosion(), true);
    }

    @SubscribeEvent
    public static void onWorldEventPotentialSpawns(WorldEvent.PotentialSpawns event) {
        if (event.getList().isEmpty()) {
            return;
        }
        if (ProtectedRegionHelper.isEntitySpawningPrevented(event.getWorld(), event.getPos())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        World world = entity.field_70170_p;
        UUID uuid = entity.getPersistentID();
        IProtectedRegionManager manager = ProtectedRegionManager.getInstance(world);
        if (manager != null) {
            for (ProtectedRegion protectedRegion : manager.getProtectedRegions()) {
                if (!protectedRegion.isEntityDependency(uuid)) continue;
                protectedRegion.removeEntityDependency(uuid);
            }
        }
    }

    @Deprecated
    private static void checkDeprecatedProtectedRegions(World world) {
        if (world.field_72995_K) {
            return;
        }
        int dim = world.field_73011_w.getDimension();
        File folder = dim == 0 ? new File(world.func_72860_G().func_75765_b(), "data/CQR/protected_regions") : new File(world.func_72860_G().func_75765_b(), "DIM" + dim + "/data/CQR/protected_regions");
        if (!folder.exists()) {
            return;
        }
        ArrayList files = new ArrayList(FileUtils.listFiles((File)folder, (String[])new String[]{"nbt"}, (boolean)false));
        if (files.isEmpty()) {
            return;
        }
        NBTTagCompound compound = FileIOUtil.readNBTFromFile((File)files.get(0));
        if (compound != null && compound.func_74779_i("version").equals("1.2.0")) {
            return;
        }
        boolean flag = ProtectedRegion.logVersionWarnings;
        ProtectedRegion.logVersionWarnings = false;
        CQRMain.logger.info("Updating deprectated protected region files...");
        long t = System.currentTimeMillis();
        for (int i = 0; i < files.size(); ++i) {
            if (System.currentTimeMillis() - t > 2000L) {
                CQRMain.logger.info(String.format("%.2f%%", (double)i / (double)files.size() * 100.0));
                t = System.currentTimeMillis();
            }
            File file = (File)files.get(i);
            NBTTagCompound tag = FileIOUtil.readNBTFromFile(file);
            ProtectedRegion protectedRegion = new ProtectedRegion(world, tag);
            FileIOUtil.writeNBTToFile(protectedRegion.writeToNBT(), file);
            ProtectedRegionEventHandler.updateChunkCapabilityEfficiently((WorldServer)world, protectedRegion);
        }
        ProtectedRegion.logVersionWarnings = flag;
        RegionFileCache.func_76551_a();
    }

    @Deprecated
    private static void updateChunkCapabilityEfficiently(WorldServer world, ProtectedRegion protectedRegion) {
        IProtectedRegionManager manager = ProtectedRegionManager.getInstance((World)world);
        BlockPos p1 = protectedRegion.getStartPos();
        BlockPos p2 = protectedRegion.getEndPos();
        for (int x = p1.func_177958_n() >> 4; x <= p2.func_177958_n() >> 4; ++x) {
            for (int z = p1.func_177952_p() >> 4; z <= p2.func_177952_p() >> 4; ++z) {
                Chunk chunk = world.func_72863_F().func_186026_b(x, z);
                if (chunk != null) {
                    CapabilityProtectedRegionData cap = (CapabilityProtectedRegionData)chunk.getCapability(CapabilityProtectedRegionDataProvider.PROTECTED_REGION_DATA, null);
                    cap.addProtectedRegionUuid(protectedRegion.getUuid());
                    FIELD_PROTECTED_REGIONS.get(manager).put(protectedRegion.getUuid(), new ServerProtectedRegionManager.ProtectedRegionContainer(protectedRegion, false));
                    continue;
                }
                NBTTagCompound chunkNBT = ProtectedRegionEventHandler.getChunkNBT(world, x, z);
                if (chunkNBT != null) {
                    NBTTagCompound levelTag = chunkNBT.func_74775_l("Level");
                    if (!levelTag.func_150297_b("ForgeCaps", 10)) {
                        levelTag.func_74782_a("ForgeCaps", (NBTBase)new NBTTagCompound());
                    }
                    NBTTagCompound capabilityTag = levelTag.func_74775_l("ForgeCaps");
                    CapabilityProtectedRegionData cap = new CapabilityProtectedRegionData(null);
                    cap.readFromNBT(capabilityTag.func_74775_l(CapabilityProtectedRegionDataProvider.LOCATION.toString()));
                    FIELD_PROTECTED_REGION_UUIDS.get(cap).add(protectedRegion.getUuid());
                    capabilityTag.func_74782_a(CapabilityProtectedRegionDataProvider.LOCATION.toString(), (NBTBase)cap.writeToNBT());
                    try {
                        ((AnvilChunkLoader)world.func_72863_F().field_73247_e).func_183013_b(new ChunkPos(x, z), chunkNBT);
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed saving chunk!", e);
                    }
                }
                chunk = world.func_72964_e(x, z);
                CapabilityProtectedRegionData cap = (CapabilityProtectedRegionData)chunk.getCapability(CapabilityProtectedRegionDataProvider.PROTECTED_REGION_DATA, null);
                cap.addProtectedRegionUuid(protectedRegion.getUuid());
                FIELD_PROTECTED_REGIONS.get(manager).put(protectedRegion.getUuid(), new ServerProtectedRegionManager.ProtectedRegionContainer(protectedRegion, false));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    private static NBTTagCompound getChunkNBT(WorldServer world, int chunkX, int chunkZ) {
        AnvilChunkLoader chunkLoader = (AnvilChunkLoader)world.func_72863_F().field_73247_e;
        try (DataInputStream datainputstream = RegionFileCache.func_76549_c((File)chunkLoader.field_75825_d, (int)chunkX, (int)chunkZ);){
            if (datainputstream == null) return null;
            NBTTagCompound nBTTagCompound = chunkLoader.field_193416_e.func_188257_a((IFixType)FixTypes.CHUNK, CompressedStreamTools.func_74794_a((DataInputStream)datainputstream));
            return nBTTagCompound;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        FIELD_PROTECTED_REGIONS = new ReflectionField(ServerProtectedRegionManager.class, "protectedRegions", "protectedRegions");
        FIELD_PROTECTED_REGION_UUIDS = new ReflectionField(CapabilityProtectedRegionData.class, "protectedRegionUuids", "protectedRegionUuids");
    }
}

