/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.inventory;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.entity.trade.Trade;
import team.cqr.cqrepoured.entity.trade.TraderOffer;

public class InventoryMerchant
implements IInventory {
    private final AbstractEntityCQR entity;
    private final EntityPlayer player;
    private final NonNullList<ItemStack> slots = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    @Nullable
    private Trade currentTrade;
    private int currentTradeIndex;

    public InventoryMerchant(AbstractEntityCQR entity, EntityPlayer player) {
        this.entity = entity;
        this.player = player;
    }

    public String func_70005_c_() {
        return this.entity.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_70302_i_() {
        return this.slots.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.slots) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.slots.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStackHelper.func_188382_a(this.slots, (int)index, (int)(index == 5 ? ((ItemStack)this.slots.get(index)).func_190916_E() : count));
        if (!stack.func_190926_b()) {
            this.resetTradeAndSlots();
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = ItemStackHelper.func_188383_a(this.slots, (int)index);
        if (!stack.func_190926_b()) {
            this.resetTradeAndSlots();
        }
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.slots.set(index, (Object)stack);
        this.resetTradeAndSlots();
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.entity.field_70128_L) {
            return false;
        }
        return player.func_70068_e((Entity)this.entity) <= 64.0;
    }

    public void func_70296_d() {
        this.resetTradeAndSlots();
    }

    public void resetTradeAndSlots() {
        TraderOffer traderOffer = this.entity.getTrades();
        if (traderOffer != null && !traderOffer.isEmpty()) {
            this.currentTrade = traderOffer.get(this.currentTradeIndex);
            ItemStack[] input = new ItemStack[]{this.func_70301_a(0), this.func_70301_a(1), this.func_70301_a(2), this.func_70301_a(3)};
            if (this.currentTrade != null && this.currentTrade.isUnlockedFor(this.player) && this.currentTrade.isInStock() && this.currentTrade.doItemsMatch(input)) {
                this.slots.set(4, (Object)this.currentTrade.getOutput());
            } else {
                this.slots.set(4, (Object)ItemStack.field_190927_a);
            }
        } else {
            this.currentTrade = null;
            this.slots.set(4, (Object)ItemStack.field_190927_a);
        }
    }

    public void setCurrentTradeIndex(int index) {
        if (this.currentTradeIndex != index) {
            this.currentTradeIndex = index;
            this.resetTradeAndSlots();
        }
    }

    public Trade getCurrentTrade() {
        return this.currentTrade;
    }

    public int getCurrentTradeIndex() {
        return this.currentTradeIndex;
    }

    public void func_174888_l() {
        this.slots.clear();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }
}

