/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemTeleportStone
extends Item {
    private static final String X = "x";
    private static final String Y = "y";
    private static final String Z = "z";
    private static final String DIMENSION = "dimension";

    public ItemTeleportStone() {
        this.func_77656_e(100);
        this.func_77625_d(1);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound tag;
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (isSelected && entityIn instanceof EntityPlayer && worldIn.field_72995_K && worldIn.func_82737_E() % 4L == 0L && (tag = stack.func_77978_p()) != null && tag.func_74764_b(X) && tag.func_74764_b(Y) && tag.func_74764_b(Z) && tag.func_74764_b(DIMENSION) && worldIn.field_73011_w.getDimension() == tag.func_74762_e(DIMENSION)) {
            double x = (double)MathHelper.func_76128_c((double)tag.func_74769_h(X)) + MathHelper.func_151237_a((double)(worldIn.field_73012_v.nextGaussian() * 0.3), (double)-0.5, (double)0.5);
            double y = (double)MathHelper.func_76128_c((double)tag.func_74769_h(Y)) + MathHelper.func_151237_a((double)(worldIn.field_73012_v.nextGaussian() * 0.1), (double)-0.1, (double)0.1);
            double z = (double)MathHelper.func_76128_c((double)tag.func_74769_h(Z)) + MathHelper.func_151237_a((double)(worldIn.field_73012_v.nextGaussian() * 0.3), (double)-0.5, (double)0.5);
            worldIn.func_175688_a(EnumParticleTypes.DRAGON_BREATH, x + 0.5, y + 0.1, z + 0.5, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private static void transferPlayerToDimension(EntityPlayerMP player, int dimension, PlayerList manager) {
        int oldDim = player.field_71093_bK;
        WorldServer oldWorld = manager.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dimension;
        WorldServer newWorld = manager.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, newWorld.func_175659_aa(), newWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        oldWorld.func_72973_f((Entity)player);
        if (player.func_184207_aI()) {
            player.func_184226_ay();
        }
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        player.field_70128_L = false;
        ItemTeleportStone.transferEntityToWorld((Entity)player, oldWorld, newWorld);
        manager.func_72375_a(player, oldWorld);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(newWorld);
        manager.func_72354_b(player, newWorld);
        manager.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDim, dimension);
    }

    private static void transferEntityToWorld(Entity entity, WorldServer oldWorld, WorldServer newWorld) {
        WorldProvider oldWorldProvider = oldWorld.field_73011_w;
        WorldProvider newWorldProvider = newWorld.field_73011_w;
        double moveFactor = oldWorldProvider.getMovementFactor() / newWorldProvider.getMovementFactor();
        double x = entity.field_70165_t * moveFactor;
        double z = entity.field_70161_v * moveFactor;
        oldWorld.field_72984_F.func_76320_a("placing");
        x = MathHelper.func_151237_a((double)x, (double)-2.9999872E7, (double)2.9999872E7);
        z = MathHelper.func_151237_a((double)z, (double)-2.9999872E7, (double)2.9999872E7);
        if (entity.func_70089_S()) {
            entity.func_70012_b(x, entity.field_70163_u, z, entity.field_70177_z, entity.field_70125_A);
            newWorld.func_72838_d(entity);
            newWorld.func_72866_a(entity, false);
        }
        oldWorld.field_72984_F.func_76319_b();
        entity.func_70029_a((World)newWorld);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entityLiving;
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 60);
            if (player.func_70093_af() && stack.func_77942_o()) {
                stack.func_77978_p().func_82580_o(X);
                stack.func_77978_p().func_82580_o(Y);
                stack.func_77978_p().func_82580_o(Z);
                worldIn.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_193781_bp, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                for (int i = 0; i < 10; ++i) {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, player.field_70165_t + worldIn.field_73012_v.nextDouble() - 0.5, player.field_70163_u + 0.5, player.field_70161_v + worldIn.field_73012_v.nextDouble() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                }
            } else {
                if (this.getPoint(stack) == null || !stack.func_77942_o()) {
                    this.setPoint(stack, player);
                    for (int i = 0; i < 10; ++i) {
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, player.field_70165_t + worldIn.field_73012_v.nextDouble() - 0.5, player.field_70163_u + 0.5, player.field_70161_v + worldIn.field_73012_v.nextDouble() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                    }
                    worldIn.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_193781_bp, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                    return super.func_77654_b(stack, worldIn, entityLiving);
                }
                if (stack.func_77942_o() && !player.func_70093_af() && stack.func_77978_p().func_74764_b(X) && stack.func_77978_p().func_74764_b(Y) && stack.func_77978_p().func_74764_b(Z)) {
                    MinecraftServer server;
                    int dimension = stack.func_77978_p().func_150297_b(DIMENSION, 3) ? stack.func_77978_p().func_74762_e(DIMENSION) : 0;
                    BlockPos pos = this.getPoint(stack);
                    if (player.func_184207_aI()) {
                        player.func_184226_ay();
                    }
                    if (player.func_184218_aH()) {
                        player.func_184210_p();
                    }
                    if (dimension != player.func_130014_f_().field_73011_w.getDimension() && (server = player.field_70170_p.func_73046_m()) != null) {
                        ItemTeleportStone.transferPlayerToDimension(player, dimension, server.func_184103_al());
                    }
                    player.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                    for (int i = 0; i < 30; ++i) {
                        worldIn.func_175688_a(EnumParticleTypes.PORTAL, player.field_70165_t + worldIn.field_73012_v.nextDouble() - 0.5, player.field_70163_u + 0.5, player.field_70161_v + worldIn.field_73012_v.nextDouble() - 0.5, 0.0, 0.0, 0.0, new int[0]);
                    }
                    worldIn.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_77972_a(1, entityLiving);
                    }
                    return super.func_77654_b(stack, worldIn, entityLiving);
                }
            }
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.teleport_stone.name", (Object[])new Object[0]));
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(X) && stack.func_77978_p().func_74764_b(Y) && stack.func_77978_p().func_74764_b(Z)) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.teleport_stone_position.name", (Object[])new Object[0]));
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)("X: " + (int)stack.func_77978_p().func_74769_h(X)), (Object[])new Object[0]));
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)("Y: " + (int)stack.func_77978_p().func_74769_h(Y)), (Object[])new Object[0]));
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)("Z: " + (int)stack.func_77978_p().func_74769_h(Z)), (Object[])new Object[0]));
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)("Dimension: " + (stack.func_77978_p().func_150297_b(DIMENSION, 3) ? stack.func_77978_p().func_74762_e(DIMENSION) : 0)), (Object[])new Object[0]));
            }
        } else {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.click_shift.name", (Object[])new Object[0]));
        }
    }

    private void setPoint(ItemStack stack, EntityPlayerMP player) {
        NBTTagCompound stone = stack.func_77978_p();
        if (stone == null) {
            stone = new NBTTagCompound();
            stack.func_77982_d(stone);
        }
        if (!stone.func_74764_b(X)) {
            stone.func_74780_a(X, player.field_70165_t);
        }
        if (!stone.func_74764_b(Y)) {
            stone.func_74780_a(Y, player.field_70163_u);
        }
        if (!stone.func_74764_b(Z)) {
            stone.func_74780_a(Z, player.field_70161_v);
        }
        stone.func_74768_a(DIMENSION, player.field_71093_bK);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getPoint(stack) != null;
    }

    @Nullable
    private BlockPos getPoint(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(X) && stack.func_77978_p().func_74764_b(Y) && stack.func_77978_p().func_74764_b(Z)) {
            NBTTagCompound stone = stack.func_77978_p();
            double x = stone.func_74769_h(X);
            double y = stone.func_74769_h(Y);
            double z = stone.func_74769_h(Z);
            return new BlockPos(x, y, z);
        }
        return null;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }
}

