/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.item.armor;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import team.cqr.cqrepoured.capability.armor.CapabilityCooldownHandlerHelper;
import team.cqr.cqrepoured.client.init.CQRArmorModels;
import team.cqr.cqrepoured.init.CQRItems;

public class ItemArmorTurtle
extends ItemArmor {
    private AttributeModifier health = new AttributeModifier("TurtleHealthModifier", 2.0, 0);

    public ItemArmorTurtle(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityLiving.func_184640_d((ItemStack)stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)this.health);
        }
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int cooldown;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (cooldown = CapabilityCooldownHandlerHelper.getCooldown((EntityLivingBase)player, CQRItems.CHESTPLATE_TURTLE)) > 0) {
            tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"description.turtle_armor_charging.name", (Object[])new Object[0]) + this.convertCooldown(cooldown));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.turtle_armor.name", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.click_shift.name", (Object[])new Object[0]));
        }
    }

    private String convertCooldown(int cd) {
        int i = cd / 20;
        int minutes = i / 60;
        int seconds = i % 60;
        if (seconds < 10) {
            return minutes + ":0" + seconds;
        }
        return minutes + ":" + seconds;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return armorSlot == EntityEquipmentSlot.LEGS ? CQRArmorModels.turtleArmorLegs : CQRArmorModels.turtleArmor;
    }
}

