/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation;

import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import team.cqr.cqrepoured.util.Perlin3D;
import team.cqr.cqrepoured.world.structure.generation.generation.part.BlockDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableBlockInfo;

public class PlateauBuilder {
    public static BlockDungeonPart.Builder makeRandomBlob(Block fillBlock, BlockPos startPos, BlockPos endPos, int wallSize, long seed) {
        BlockDungeonPart.Builder partBuilder = new BlockDungeonPart.Builder();
        Perlin3D perlinNoise1 = new Perlin3D(seed, 8);
        Perlin3D perlinNoise2 = new Perlin3D(seed, 32);
        int sizeX = endPos.func_177958_n() - startPos.func_177958_n();
        int sizeZ = endPos.func_177952_p() - startPos.func_177952_p();
        int sizeY = endPos.func_177956_o() - startPos.func_177956_o();
        sizeX = (int)((double)sizeX * 1.25);
        sizeZ = (int)((double)sizeZ * 1.25);
        sizeY = (int)((double)sizeY * 1.35);
        for (int iX = 0; iX < sizeX; ++iX) {
            for (int iY = 0; iY < sizeY; ++iY) {
                for (int iZ = 0; iZ < sizeZ; ++iZ) {
                    double perlin2;
                    double perlin1;
                    float noise = Math.max(0.0f, 2.0f - (float)(sizeY - iY) / 4.0f);
                    noise += Math.max(0.0f, (float)wallSize - (float)iX / 2.0f);
                    noise += Math.max(0.0f, (float)wallSize - (float)(sizeX - iX) / 2.0f);
                    noise += Math.max(0.0f, (float)wallSize - (float)iZ / 2.0f);
                    if ((noise += Math.max(0.0f, (float)wallSize - (float)(sizeZ - iZ) / 2.0f)) >= 0.5f && (perlin1 = (double)perlinNoise1.getNoiseAt(startPos.func_177958_n() + iX, startPos.func_177956_o() + iY, startPos.func_177952_p() + iZ)) * (double)noise >= 0.5 && perlin1 * (perlin2 = (double)perlinNoise2.getNoiseAt(startPos.func_177958_n() + iX, startPos.func_177956_o() + iY, startPos.func_177952_p() + iZ)) * (double)noise >= 0.5) continue;
                    partBuilder.add(new PreparableBlockInfo(iX, iY, iZ, fillBlock.func_176223_P(), null));
                }
            }
        }
        return partBuilder;
    }

    public static BlockDungeonPart.Builder makeRandomBlob2(Block fillBlock, BlockPos startPos, BlockPos endPos, int wallSize, long seed) {
        BlockDungeonPart.Builder partBuilder = new BlockDungeonPart.Builder();
        Perlin3D perlinNoise1 = new Perlin3D(seed, 8);
        Perlin3D perlinNoise2 = new Perlin3D(seed, 32);
        int sizeX = endPos.func_177958_n() - startPos.func_177958_n() + 1 + wallSize * 2;
        int sizeZ = endPos.func_177952_p() - startPos.func_177952_p() + 1 + wallSize * 2;
        int sizeY = endPos.func_177956_o() - startPos.func_177956_o() + 1 + wallSize * 2;
        for (int iX = 0; iX < sizeX; ++iX) {
            for (int iY = 0; iY < sizeY; ++iY) {
                for (int iZ = 0; iZ < sizeZ; ++iZ) {
                    double perlin2;
                    double perlin1;
                    float noise = Math.max(0.0f, (float)wallSize - (float)iY * 0.5f);
                    noise += Math.max(0.0f, (float)wallSize - (float)(sizeY - iY) * 0.5f);
                    noise += Math.max(0.0f, (float)wallSize - (float)iX * 0.5f);
                    noise += Math.max(0.0f, (float)wallSize - (float)(sizeX - iX) * 0.5f);
                    noise += Math.max(0.0f, (float)wallSize - (float)iZ * 0.5f);
                    if ((noise += Math.max(0.0f, (float)wallSize - (float)(sizeZ - iZ) * 0.5f)) >= 0.5f && (perlin1 = (double)perlinNoise1.getNoiseAt(startPos.func_177958_n() + iX, startPos.func_177956_o() + iY, startPos.func_177952_p() + iZ)) * (double)noise >= 0.5 && perlin1 * (perlin2 = (double)perlinNoise2.getNoiseAt(startPos.func_177958_n() + iX, startPos.func_177956_o() + iY, startPos.func_177952_p() + iZ)) * (double)noise >= 0.5) continue;
                    partBuilder.add(new PreparableBlockInfo(iX, iY, iZ, fillBlock.func_176223_P(), null));
                }
            }
        }
        return partBuilder;
    }
}

