/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generation.preparable;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.tileentity.TileEntityBoss;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonPlacement;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratableBlockInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratableBossInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratablePosInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparablePosInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableSpawnerInfo;
import team.cqr.cqrepoured.world.structure.generation.structurefile.BlockStatePalette;

public class PreparableBossInfo
extends PreparablePosInfo {
    @Nullable
    private final NBTTagCompound bossTag;

    public PreparableBossInfo(BlockPos pos, TileEntityBoss tileEntityBoss) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), tileEntityBoss);
    }

    public PreparableBossInfo(int x, int y, int z, TileEntityBoss tileEntityBoss) {
        this(x, y, z, PreparableBossInfo.getBossTag(tileEntityBoss));
    }

    public PreparableBossInfo(BlockPos pos, @Nullable NBTTagCompound bossTag) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), bossTag);
    }

    public PreparableBossInfo(int x, int y, int z, @Nullable NBTTagCompound bossTag) {
        super(x, y, z);
        this.bossTag = bossTag;
    }

    @Nullable
    private static NBTTagCompound getBossTag(TileEntityBoss tileEntityBoss) {
        ItemStack stack = ((IItemHandler)tileEntityBoss.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0);
        if (!stack.func_77942_o()) {
            return null;
        }
        if (!stack.func_77978_p().func_150297_b("EntityIn", 10)) {
            return null;
        }
        return stack.func_77978_p().func_74775_l("EntityIn");
    }

    @Override
    protected GeneratablePosInfo prepare(World world, DungeonPlacement placement, BlockPos pos) {
        Entity entity = this.bossTag != null ? this.createEntityFromTag(world, placement, pos) : (placement.getInhabitant().getBossID() != null ? this.createEntityFromBossID(world, placement, pos) : this.createEntityFromEntityID(world, placement, pos));
        placement.getProtectedRegionBuilder().addEntity(entity);
        return new GeneratableBossInfo(pos, entity);
    }

    @Override
    protected GeneratablePosInfo prepareDebug(World world, DungeonPlacement placement, BlockPos pos) {
        TileEntityBoss tileEntity = new TileEntityBoss();
        if (this.bossTag != null) {
            ItemStack stack = new ItemStack(CQRItems.SOUL_BOTTLE);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a("EntityIn", (NBTBase)this.bossTag);
            stack.func_77982_d(tag);
            tileEntity.inventory.setStackInSlot(0, stack);
        }
        return new GeneratableBlockInfo(pos, CQRBlocks.BOSS_BLOCK.func_176223_P(), tileEntity);
    }

    private Entity createEntityFromTag(World world, DungeonPlacement placement, BlockPos pos) {
        Entity entity = PreparableSpawnerInfo.createEntityFromTag(world, placement, pos, this.bossTag);
        if (entity instanceof AbstractEntityCQR) {
            ((AbstractEntityCQR)entity).enableBossBar();
        }
        return entity;
    }

    private Entity createEntityFromBossID(World world, DungeonPlacement placement, BlockPos pos) {
        Entity entity = EntityList.func_188429_b((ResourceLocation)placement.getInhabitant().getBossID(), (World)world);
        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_180482_a(world.func_175649_E(pos), null);
            ((EntityLiving)entity).func_110163_bv();
            if (entity instanceof AbstractEntityCQR) {
                ((AbstractEntityCQR)entity).onSpawnFromCQRSpawnerInDungeon(placement);
                ((AbstractEntityCQR)entity).enableBossBar();
            }
        }
        return entity;
    }

    private Entity createEntityFromEntityID(World world, DungeonPlacement placement, BlockPos pos) {
        Entity entity = EntityList.func_188429_b((ResourceLocation)placement.getInhabitant().getEntityID(), (World)world);
        entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        entity.func_96094_a("Temporary Boss");
        if (entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            living.func_180482_a(world.func_175649_E(pos), null);
            living.func_110163_bv();
            if (entity instanceof AbstractEntityCQR) {
                AbstractEntityCQR entityCQR = (AbstractEntityCQR)entity;
                entityCQR.onSpawnFromCQRSpawnerInDungeon(placement);
                entityCQR.enableBossBar();
                entityCQR.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)entityCQR.getBaseHealth() * 5.0);
            } else {
                living.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
            }
            living.func_70606_j(living.func_110138_aP());
            living.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier("temp_boss_speed_buff", 0.35, 2));
            living.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151048_u));
            living.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(CQRItems.CURSED_BONE));
            living.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(CQRItems.HELMET_HEAVY_DIAMOND));
            living.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(CQRItems.CHESTPLATE_HEAVY_DIAMOND));
            living.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(CQRItems.LEGGINGS_HEAVY_DIAMOND));
            living.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(CQRItems.BOOTS_HEAVY_DIAMOND));
        }
        return entity;
    }

    @Nullable
    public NBTTagCompound getBossTag() {
        return this.bossTag;
    }

    public static class Serializer
    implements PreparablePosInfo.Registry.ISerializer<PreparableBossInfo> {
        @Override
        public void write(PreparableBossInfo preparable, ByteBuf buf, BlockStatePalette palette, NBTTagList nbtList) {
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)(preparable.bossTag != null ? nbtList.func_74745_c() << 1 | 1 : 0), (int)5);
            if (preparable.bossTag != null) {
                nbtList.func_74742_a((NBTBase)preparable.bossTag);
            }
        }

        @Override
        public PreparableBossInfo read(int x, int y, int z, ByteBuf buf, BlockStatePalette palette, NBTTagList nbtList) {
            int data = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
            NBTTagCompound bossTag = null;
            if ((data & 1) == 1) {
                bossTag = nbtList.func_150305_b(data >>> 1);
            }
            return new PreparableBossInfo(x, y, z, bossTag);
        }

        @Override
        @Deprecated
        public PreparableBossInfo read(int x, int y, int z, NBTTagIntArray nbtIntArray, BlockStatePalette palette, NBTTagList nbtList) {
            return new PreparableBossInfo(x, y, z, (NBTTagCompound)null);
        }
    }

    public static class Factory
    implements PreparablePosInfo.Registry.IFactory<TileEntityBoss> {
        @Override
        public PreparablePosInfo create(World world, int x, int y, int z, IBlockState state, Supplier<TileEntityBoss> tileEntitySupplier) {
            return new PreparableBossInfo(x, y, z, tileEntitySupplier.get());
        }
    }
}

