/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generation.preparable;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonPlacement;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratableEntityInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.IPreparable;

public class PreparableEntityInfo
implements IPreparable<GeneratableEntityInfo> {
    private final NBTTagCompound entityData;

    public PreparableEntityInfo(BlockPos structurePos, Entity entity) {
        this.entityData = new NBTTagCompound();
        entity.func_70039_c(this.entityData);
        this.entityData.func_82580_o("UUIDMost");
        this.entityData.func_82580_o("UUIDLeast");
        NBTTagList nbtTagList = this.entityData.func_150295_c("Pos", 6);
        nbtTagList.func_150304_a(0, (NBTBase)new NBTTagDouble(entity.field_70165_t - (double)structurePos.func_177958_n()));
        nbtTagList.func_150304_a(1, (NBTBase)new NBTTagDouble(entity.field_70163_u - (double)structurePos.func_177956_o()));
        nbtTagList.func_150304_a(2, (NBTBase)new NBTTagDouble(entity.field_70161_v - (double)structurePos.func_177952_p()));
        if (entity instanceof EntityHanging) {
            BlockPos blockpos = ((EntityHanging)entity).func_174857_n();
            this.entityData.func_74768_a("TileX", blockpos.func_177958_n() - structurePos.func_177958_n());
            this.entityData.func_74768_a("TileY", blockpos.func_177956_o() - structurePos.func_177956_o());
            this.entityData.func_74768_a("TileZ", blockpos.func_177952_p() - structurePos.func_177952_p());
        }
    }

    public PreparableEntityInfo(NBTTagCompound entityData) {
        this.entityData = entityData;
    }

    @Override
    public GeneratableEntityInfo prepareNormal(World world, DungeonPlacement placement) {
        double z;
        double y;
        double x;
        Entity entity = EntityList.func_75615_a((NBTTagCompound)this.entityData, (World)world);
        if (entity instanceof EntityHanging) {
            x = this.entityData.func_74762_e("TileX");
            y = this.entityData.func_74762_e("TileY");
            z = this.entityData.func_74762_e("TileZ");
            if (entity instanceof EntityPainting && placement.getMirror() != Mirror.NONE) {
                int n = (((EntityPainting)entity).field_70522_e.field_75703_B >> 4) + 1 & 1;
                switch (((EntityPainting)entity).field_174860_b.func_176735_f()) {
                    case NORTH: {
                        z -= (double)n;
                        break;
                    }
                    case EAST: {
                        x += (double)n;
                        break;
                    }
                    case SOUTH: {
                        z += (double)n;
                        break;
                    }
                    case WEST: {
                        x -= (double)n;
                        break;
                    }
                }
            }
            BlockPos.MutableBlockPos pos = placement.transform((int)x, (int)y, (int)z);
            x = pos.func_177958_n();
            y = pos.func_177956_o();
            z = pos.func_177952_p();
        } else {
            NBTTagList tagList = this.entityData.func_150295_c("Pos", 6);
            DungeonPlacement.MutableVec3d vec = placement.transform(tagList.func_150309_d(0), tagList.func_150309_d(1), tagList.func_150309_d(2));
            x = vec.x;
            y = vec.y;
            z = vec.z;
        }
        float transformedYaw = placement.transform(entity);
        entity.func_70012_b(x, y, z, transformedYaw, entity.field_70125_A);
        entity.func_181013_g(transformedYaw);
        entity.func_70034_d(transformedYaw);
        return new GeneratableEntityInfo(entity);
    }

    @Override
    public GeneratableEntityInfo prepareDebug(World world, DungeonPlacement placement) {
        return this.prepareNormal(world, placement);
    }

    public NBTTagCompound getEntityData() {
        return this.entityData;
    }
}

