/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generation.preparable;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockStructureVoid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cqr.cqrepoured.block.BlockBossBlock;
import team.cqr.cqrepoured.block.BlockExporterChest;
import team.cqr.cqrepoured.block.BlockForceFieldNexus;
import team.cqr.cqrepoured.block.BlockMapPlaceholder;
import team.cqr.cqrepoured.block.BlockNull;
import team.cqr.cqrepoured.block.BlockSpawner;
import team.cqr.cqrepoured.block.BlockTNTCQR;
import team.cqr.cqrepoured.world.structure.generation.generation.DungeonPlacement;
import team.cqr.cqrepoured.world.structure.generation.generation.generatable.GeneratablePosInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.IPreparable;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableBannerInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableBlockInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableBossInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableEmptyInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableForceFieldNexusInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableLootChestInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableMapInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableSpawnerInfo;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableTNTCQRInfo;
import team.cqr.cqrepoured.world.structure.generation.structurefile.BlockStatePalette;

public abstract class PreparablePosInfo
implements IPreparable<GeneratablePosInfo> {
    private final int x;
    private final int y;
    private final int z;

    protected PreparablePosInfo(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public GeneratablePosInfo prepareNormal(World world, DungeonPlacement placement) {
        BlockPos.MutableBlockPos pos = placement.transform(this.x, this.y, this.z);
        if (world.func_189509_E((BlockPos)pos)) {
            return null;
        }
        return this.prepare(world, placement, (BlockPos)pos);
    }

    @Override
    public GeneratablePosInfo prepareDebug(World world, DungeonPlacement placement) {
        BlockPos.MutableBlockPos pos = placement.transform(this.x, this.y, this.z);
        if (world.func_189509_E((BlockPos)pos)) {
            return null;
        }
        return this.prepareDebug(world, placement, (BlockPos)pos);
    }

    protected abstract GeneratablePosInfo prepare(World var1, DungeonPlacement var2, BlockPos var3);

    protected abstract GeneratablePosInfo prepareDebug(World var1, DungeonPlacement var2, BlockPos var3);

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getChunkX() {
        return this.x >> 4;
    }

    public int getChunkY() {
        return this.y >> 4;
    }

    public int getChunkZ() {
        return this.z >> 4;
    }

    public static class Registry {
        private static final Map<Class<? extends Block>, IFactory<?>> BLOCK_CLASS_2_EXPORTER = new HashMap();
        private static byte nextId = 0;
        private static final Object2ByteMap<Class<? extends PreparablePosInfo>> CLASS_2_ID = new Object2ByteOpenHashMap();
        private static final Byte2ObjectMap<ISerializer<?>> ID_2_SERIALIZER = new Byte2ObjectOpenHashMap();

        private static void register(Class<? extends Block> blockClass, IFactory<?> func) {
            if (BLOCK_CLASS_2_EXPORTER.containsKey(blockClass)) {
                throw new IllegalArgumentException("Duplicate entry for class: " + blockClass.getSimpleName());
            }
            BLOCK_CLASS_2_EXPORTER.put(blockClass, func);
        }

        public static <T extends TileEntity> IFactory<T> getFactory(Class<? extends Block> blockClass) {
            IFactory<Object> factory = BLOCK_CLASS_2_EXPORTER.get(blockClass);
            if (factory == null && blockClass != Block.class) {
                factory = Registry.getFactory(blockClass.getSuperclass());
                BLOCK_CLASS_2_EXPORTER.put(blockClass, factory);
            }
            if (factory == null) {
                throw new NullPointerException();
            }
            return factory;
        }

        public static <T extends TileEntity> PreparablePosInfo create(World world, BlockPos pos, int x, int y, int z, IBlockState state) {
            Class<?> blockClass = state.func_177230_c().getClass();
            IFactory<T> factory = Registry.getFactory(blockClass);
            return factory.create(world, pos, x, y, z, state);
        }

        private static <T extends PreparablePosInfo> void register(Class<T> clazz, ISerializer<T> serializer) {
            if (CLASS_2_ID.containsKey(clazz)) {
                throw new IllegalArgumentException("Duplicate entry for class: " + clazz.getSimpleName());
            }
            byte by = nextId;
            nextId = (byte)(by + 1);
            byte id = by;
            CLASS_2_ID.put(clazz, id);
            ID_2_SERIALIZER.put(id, serializer);
        }

        public static <T extends PreparablePosInfo> void write(T preparable, ByteBuf buf, BlockStatePalette palette, NBTTagList compoundList) {
            if (!CLASS_2_ID.containsKey(preparable.getClass())) {
                throw new IllegalArgumentException("Class not registered: " + preparable.getClass().getSimpleName());
            }
            byte id = CLASS_2_ID.getByte(preparable.getClass());
            buf.writeByte((int)id);
            ISerializer serializer = (ISerializer)ID_2_SERIALIZER.get(id);
            serializer.write(preparable, buf, palette, compoundList);
        }

        public static PreparablePosInfo read(int x, int y, int z, ByteBuf buf, BlockStatePalette palette, NBTTagList compoundList) {
            byte id = buf.readByte();
            if (!ID_2_SERIALIZER.containsKey(id)) {
                throw new IllegalArgumentException("No serializer registered for id: " + id);
            }
            ISerializer serializer = (ISerializer)ID_2_SERIALIZER.get(id);
            return serializer.read(x, y, z, buf, palette, compoundList);
        }

        @Deprecated
        public static PreparablePosInfo read(int x, int y, int z, NBTTagIntArray nbtIntArray, BlockStatePalette palette, NBTTagList compoundList) {
            int[] intArray = nbtIntArray.func_150302_c();
            if (intArray.length == 0) {
                return new PreparableEmptyInfo(x, y, z);
            }
            byte id = (byte)intArray[0];
            if (!ID_2_SERIALIZER.containsKey(id)) {
                throw new IllegalArgumentException("No serializer registered for id: " + id);
            }
            ISerializer serializer = (ISerializer)ID_2_SERIALIZER.get(id);
            return serializer.read(x, y, z, nbtIntArray, palette, compoundList);
        }

        static {
            Registry.register(BlockNull.class, new PreparableEmptyInfo.Factory());
            Registry.register(BlockStructureVoid.class, new PreparableEmptyInfo.Factory());
            Registry.register(Block.class, new PreparableBlockInfo.Factory());
            Registry.register(BlockBanner.class, new PreparableBannerInfo.Factory());
            Registry.register(BlockBossBlock.class, new PreparableBossInfo.Factory());
            Registry.register(BlockForceFieldNexus.class, new PreparableForceFieldNexusInfo.Factory());
            Registry.register(BlockExporterChest.class, new PreparableLootChestInfo.Factory());
            Registry.register(BlockSpawner.class, new PreparableSpawnerInfo.Factory());
            Registry.register(BlockMapPlaceholder.class, new PreparableMapInfo.Factory());
            Registry.register(BlockTNTCQR.class, new PreparableTNTCQRInfo.Factory());
            Registry.register(PreparableEmptyInfo.class, new PreparableEmptyInfo.Serializer());
            Registry.register(PreparableBlockInfo.class, new PreparableBlockInfo.Serializer());
            Registry.register(PreparableBannerInfo.class, new PreparableBannerInfo.Serializer());
            Registry.register(PreparableBossInfo.class, new PreparableBossInfo.Serializer());
            Registry.register(PreparableForceFieldNexusInfo.class, new PreparableForceFieldNexusInfo.Serializer());
            Registry.register(PreparableLootChestInfo.class, new PreparableLootChestInfo.Serializer());
            Registry.register(PreparableSpawnerInfo.class, new PreparableSpawnerInfo.Serializer());
            Registry.register(PreparableMapInfo.class, new PreparableMapInfo.Serializer());
            Registry.register(PreparableTNTCQRInfo.class, new PreparableTNTCQRInfo.Serializer());
        }

        public static interface ISerializer<T extends PreparablePosInfo> {
            public void write(T var1, ByteBuf var2, BlockStatePalette var3, NBTTagList var4);

            public T read(int var1, int var2, int var3, ByteBuf var4, BlockStatePalette var5, NBTTagList var6);

            @Deprecated
            public T read(int var1, int var2, int var3, NBTTagIntArray var4, BlockStatePalette var5, NBTTagList var6);
        }

        public static interface IFactory<T extends TileEntity> {
            default public PreparablePosInfo create(World world, BlockPos pos, int x, int y, int z, IBlockState state) {
                return this.create(world, x, y, z, state, () -> state.func_177230_c().hasTileEntity(state) ? world.func_175625_s(pos) : null);
            }

            public PreparablePosInfo create(World var1, int var2, int var3, int var4, IBlockState var5, Supplier<T> var6);

            public static NBTTagCompound writeTileEntityToNBT(@Nullable TileEntity tileEntity) {
                if (tileEntity == null) {
                    return null;
                }
                NBTTagCompound compound = tileEntity.func_189515_b(new NBTTagCompound());
                compound.func_82580_o("x");
                compound.func_82580_o("y");
                compound.func_82580_o("z");
                return compound;
            }
        }
    }
}

