/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.castleparts;

import java.util.Objects;
import net.minecraft.util.EnumFacing;

public class RoomGridPosition {
    private int floor;
    private int x;
    private int z;

    public RoomGridPosition(int floor, int x, int z) {
        this.floor = floor;
        this.x = x;
        this.z = z;
    }

    public RoomGridPosition(RoomGridPosition pos) {
        this.floor = pos.floor;
        this.x = pos.x;
        this.z = pos.z;
    }

    public int getFloor() {
        return this.floor;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public void setFloor(int floor) {
        this.floor = floor;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public RoomGridPosition move(EnumFacing direction) {
        return this.move(direction, 1);
    }

    public RoomGridPosition move(EnumFacing direction, int distance) {
        int floor = this.getFloor();
        int x = this.getX();
        int z = this.getZ();
        block8: for (int i = 0; i < distance; ++i) {
            switch (direction) {
                case NORTH: {
                    --z;
                    continue block8;
                }
                case SOUTH: {
                    ++z;
                    continue block8;
                }
                case WEST: {
                    --x;
                    continue block8;
                }
                case EAST: {
                    ++x;
                    continue block8;
                }
                case UP: {
                    ++floor;
                    continue block8;
                }
                case DOWN: {
                    --floor;
                    continue block8;
                }
            }
        }
        return new RoomGridPosition(floor, x, z);
    }

    public String toString() {
        return String.format("RoomGridPosition{floor=%d, x=%d, z=%d}", this.floor, this.x, this.z);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RoomGridPosition)) {
            return false;
        }
        RoomGridPosition position = (RoomGridPosition)obj;
        return this.floor == position.floor && this.x == position.x && this.z == position.z;
    }

    public int hashCode() {
        return Objects.hash(this.floor, this.x, this.z);
    }
}

