/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.generation.generators.stronghold.spiral;

import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.world.structure.generation.generation.part.BlockDungeonPart;
import team.cqr.cqrepoured.world.structure.generation.generation.preparable.PreparableBlockInfo;
import team.cqr.cqrepoured.world.structure.generation.generators.volcano.StairCaseHelper;

public class EntranceBuilderHelper {
    public static final int SEGMENT_LENGTH = 3;

    public static void buildEntranceSegment(BlockPos startPosCentered, BlockDungeonPart.Builder partBuilder, EnumFacing direction) {
        BlockPos corner1 = null;
        BlockPos corner2 = null;
        BlockPos pillar1 = null;
        BlockPos pillar2 = null;
        BlockPos torch1 = null;
        BlockPos torch2 = null;
        switch (direction) {
            case EAST: {
                corner1 = startPosCentered.func_177982_a(0, 0, -3);
                corner2 = startPosCentered.func_177982_a(3, 0, 3);
                pillar1 = startPosCentered.func_177982_a(1, 0, 2);
                pillar2 = startPosCentered.func_177982_a(1, 0, -2);
                torch1 = startPosCentered.func_177982_a(1, 4, 1);
                torch2 = startPosCentered.func_177982_a(1, 4, -1);
                break;
            }
            case NORTH: {
                corner1 = startPosCentered.func_177982_a(-3, 0, 0);
                corner2 = startPosCentered.func_177982_a(3, 0, -3);
                pillar1 = startPosCentered.func_177982_a(2, 0, -1);
                pillar2 = startPosCentered.func_177982_a(-2, 0, -1);
                torch1 = startPosCentered.func_177982_a(1, 4, -1);
                torch2 = startPosCentered.func_177982_a(-1, 4, -1);
                break;
            }
            case SOUTH: {
                corner1 = startPosCentered.func_177982_a(3, 0, 0);
                corner2 = startPosCentered.func_177982_a(-3, 0, 3);
                pillar1 = startPosCentered.func_177982_a(-2, 0, 1);
                pillar2 = startPosCentered.func_177982_a(2, 0, 1);
                torch1 = startPosCentered.func_177982_a(-1, 4, 1);
                torch2 = startPosCentered.func_177982_a(1, 4, 1);
                break;
            }
            case WEST: {
                corner1 = startPosCentered.func_177982_a(0, 0, 3);
                corner2 = startPosCentered.func_177982_a(-3, 0, -3);
                pillar1 = startPosCentered.func_177982_a(-1, 0, -2);
                pillar2 = startPosCentered.func_177982_a(-1, 0, 2);
                torch1 = startPosCentered.func_177982_a(-1, 4, -1);
                torch2 = startPosCentered.func_177982_a(-1, 4, 1);
                break;
            }
        }
        if (corner1 != null && corner2 != null && pillar1 != null && pillar2 != null) {
            BlockPos.func_177980_a((BlockPos)corner1, (BlockPos)corner2.func_177982_a(0, 6, 0)).forEach(t -> partBuilder.add(new PreparableBlockInfo((BlockPos)t, Blocks.field_150350_a.func_176223_P(), null)));
            EntranceBuilderHelper.buildFloorAndCeiling(corner1, corner2, 5, partBuilder);
            EntranceBuilderHelper.buildPillar(pillar1, partBuilder);
            partBuilder.add(new PreparableBlockInfo(torch1, CQRBlocks.UNLIT_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)StairCaseHelper.getFacingWithRotation(direction, Rotation.COUNTERCLOCKWISE_90)), null));
            EntranceBuilderHelper.buildPillar(pillar2, partBuilder);
            partBuilder.add(new PreparableBlockInfo(torch2, CQRBlocks.UNLIT_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)StairCaseHelper.getFacingWithRotation(direction, Rotation.CLOCKWISE_90)), null));
        }
    }

    private static void buildPillar(BlockPos bottom, BlockDungeonPart.Builder partBuilder) {
        for (int iY = 1; iY <= 4; ++iY) {
            BlockPos pos = bottom.func_177982_a(0, iY, 0);
            partBuilder.add(new PreparableBlockInfo(pos, CQRBlocks.GRANITE_PILLAR.func_176223_P().func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.Y), null));
        }
        partBuilder.add(new PreparableBlockInfo(bottom.func_177982_a(0, 5, 0), CQRBlocks.GRANITE_CARVED.func_176223_P(), null));
    }

    private static void buildFloorAndCeiling(BlockPos start, BlockPos end, int ceilingHeight, BlockDungeonPart.Builder partBuilder) {
        BlockPos endP = new BlockPos(end.func_177958_n(), start.func_177956_o(), end.func_177952_p());
        for (BlockPos p : BlockPos.func_177980_a((BlockPos)start, (BlockPos)endP)) {
            partBuilder.add(new PreparableBlockInfo(p, CQRBlocks.GRANITE_SMALL.func_176223_P(), null));
        }
        for (BlockPos p : BlockPos.func_177980_a((BlockPos)start.func_177982_a(0, ceilingHeight + 1, 0), (BlockPos)endP.func_177982_a(0, ceilingHeight + 1, 0))) {
            partBuilder.add(new PreparableBlockInfo(p, CQRBlocks.GRANITE_SQUARE.func_176223_P(), null));
        }
    }
}

