/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.world.structure.protection;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import team.cqr.cqrepoured.world.structure.protection.ClientProtectedRegionManager;
import team.cqr.cqrepoured.world.structure.protection.IProtectedRegionManager;
import team.cqr.cqrepoured.world.structure.protection.ServerProtectedRegionManager;

public class ProtectedRegionManager {
    private static final ClientProtectedRegionManager CLIENT_INSTANCE = new ClientProtectedRegionManager();
    private static final Int2ObjectMap<ServerProtectedRegionManager> INSTANCES = new Int2ObjectOpenHashMap();

    private ProtectedRegionManager() {
    }

    @Nullable
    public static IProtectedRegionManager getInstance(World world) {
        if (world == null) {
            return null;
        }
        if (world.field_72995_K) {
            return CLIENT_INSTANCE;
        }
        return (IProtectedRegionManager)INSTANCES.get(world.field_73011_w.getDimension());
    }

    public static void handleWorldLoad(World world) {
        if (world.field_72995_K) {
            return;
        }
        INSTANCES.computeIfAbsent((Object)world.field_73011_w.getDimension(), key -> new ServerProtectedRegionManager(world));
    }

    public static void handleWorldSave(World world) {
        if (world.field_72995_K) {
            return;
        }
        ServerProtectedRegionManager manager = (ServerProtectedRegionManager)INSTANCES.get(world.field_73011_w.getDimension());
        if (manager != null) {
            manager.saveProtectedRegions();
        }
    }

    public static void handleWorldUnload(World world) {
        if (world.field_72995_K) {
            return;
        }
        INSTANCES.remove(world.field_73011_w.getDimension());
    }

    public static void handleChunkLoad(World world, Chunk chunk) {
        if (world.field_72995_K) {
            return;
        }
        ServerProtectedRegionManager manager = (ServerProtectedRegionManager)INSTANCES.get(world.field_73011_w.getDimension());
        if (manager != null) {
            manager.handleChunkLoad(chunk);
        }
    }

    public static void handleChunkUnload(World world, Chunk chunk) {
        if (world.field_72995_K) {
            return;
        }
        ServerProtectedRegionManager manager = (ServerProtectedRegionManager)INSTANCES.get(world.field_73011_w.getDimension());
        if (manager != null) {
            manager.handleChunkUnload(chunk);
        }
    }

    public static void handleWorldTick(World world) {
        if (world.field_72995_K) {
            return;
        }
        ServerProtectedRegionManager manager = (ServerProtectedRegionManager)INSTANCES.get(world.field_73011_w.getDimension());
        if (manager != null) {
            manager.handleWorldTick();
        }
    }
}

